/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.item.StrainersDataComponents;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrainerTankBlockEntity
extends BlockEntity {
    public final FluidTank FLUID_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            StrainerTankBlockEntity.this.setChanged();
            StrainerTankBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return StrainerTankBlockEntity.this.FLUID_TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return StrainerTankBlockEntity.this.FLUID_TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return StrainerTankBlockEntity.this.FLUID_TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return resource.getAmount() - StrainerTankBlockEntity.this.FLUID_TANK.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return null;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return null;
        }
    };

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    public StrainerTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STRAINER_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        SimpleFluidContent fluidContent = (SimpleFluidContent)components.get(StrainersDataComponents.FLUID_TYPE);
        if (fluidContent != null) {
            this.FLUID_TANK.setFluid(new FluidStack(fluidContent.getFluid(), this.FLUID_TANK.getFluid().getAmount()));
            this.sync();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.FLUID_TANK.isEmpty()) {
            components.set(StrainersDataComponents.FLUID_TYPE, (Object)SimpleFluidContent.copyOf((FluidStack)this.FLUID_TANK.getFluid()));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("fluid_generator.fluidTank", (Tag)this.FLUID_TANK.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.FLUID_TANK.readFromNBT(provider, compoundTag.getCompound("fluid_generator.fluidTank"));
        super.loadAdditional(compoundTag, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.FLUID_TANK);
    }

    public void tick() {
        this.sync();
    }
}

