/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity.client;

import com.benbenlaw.strainers.block.entity.WoodenStrainerBlockEntity;
import com.benbenlaw.strainers.config.StrainersConfigFile;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class StrainerMeshEntityRenderer
implements BlockEntityRenderer<WoodenStrainerBlockEntity> {
    public StrainerMeshEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WoodenStrainerBlockEntity entity, float ticks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack mesh = entity.getItemStackHandler().getStackInSlot(1);
        ItemStack insideItem = entity.getItemStackHandler().getStackInSlot(0);
        int progress = entity.progress;
        int maxProgress = entity.maxProgress;
        if (StrainersConfigFile.SPEC.isLoaded()) {
            if (!mesh.isEmpty() && ((Boolean)StrainersConfigFile.showMeshesInWorld.get()).booleanValue()) {
                poseStack.pushPose();
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.UP || direction == Direction.DOWN) continue;
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 1.23f, 0.0f);
                    poseStack.scale(1.9f, 1.9f, 1.9f);
                    switch (direction) {
                        case NORTH: {
                            poseStack.translate(0.26, 0.0, (double)0.02f);
                            break;
                        }
                        case SOUTH: {
                            poseStack.translate(0.26, 0.0, 0.5);
                            break;
                        }
                        case WEST: {
                            poseStack.translate(0.5, 0.0, 0.26);
                            poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
                            break;
                        }
                        case EAST: {
                            poseStack.translate((double)0.02f, 0.0, 0.26);
                            poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
                        }
                    }
                    BakedModel model = itemRenderer.getModel(mesh, null, null, 0);
                    itemRenderer.render(mesh, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.getLevel(), entity.getBlockPos().above()), overlay, model);
                    poseStack.popPose();
                }
                poseStack.popPose();
            }
            if (((Boolean)StrainersConfigFile.showItemBeingStrainerInWorld.get()).booleanValue()) {
                if (insideItem.getItem() instanceof BlockItem) {
                    double percentageValue = 100.0 / (double)maxProgress;
                    double totalCompletedValue = percentageValue * (double)progress;
                    float adjustedFloat = (float)(totalCompletedValue / 100.0);
                    poseStack.pushPose();
                    poseStack.translate(0.5, (double)(1.0f - adjustedFloat) - 0.1, 0.5);
                    poseStack.scale(3.3f, 3.3f, 3.3f);
                    BakedModel insideModel = itemRenderer.getModel(insideItem, null, null, 0);
                    itemRenderer.render(insideItem, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.getLevel(), entity.getBlockPos().above()), overlay, insideModel);
                    poseStack.popPose();
                } else {
                    poseStack.pushPose();
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP || direction == Direction.DOWN) continue;
                        poseStack.pushPose();
                        poseStack.translate(0.0f, 0.25f, 0.0f);
                        poseStack.scale(1.9f, 1.9f, 1.9f);
                        switch (direction) {
                            case NORTH: {
                                poseStack.translate(0.26, 0.0, (double)0.02f);
                                break;
                            }
                            case SOUTH: {
                                poseStack.translate(0.26, 0.0, 0.5);
                                break;
                            }
                            case WEST: {
                                poseStack.translate(0.5, 0.0, 0.26);
                                poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
                                break;
                            }
                            case EAST: {
                                poseStack.translate((double)0.02f, 0.0, 0.26);
                                poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
                            }
                        }
                        BakedModel insideModel = itemRenderer.getModel(insideItem, null, null, 0);
                        itemRenderer.render(insideItem, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.getLevel(), entity.getBlockPos().above()), overlay, insideModel);
                        poseStack.popPose();
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

