/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.datagen.recipes;

import com.benbenlaw.strainers.recipe.MeshChanceResult;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StrainerRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected BlockState aboveBlock;
    protected Ingredient input;
    protected NonNullList<MeshChanceResult> results;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public StrainerRecipeBuilder(BlockState aboveBlock, Ingredient input, NonNullList<MeshChanceResult> results) {
        this.aboveBlock = aboveBlock;
        this.input = input;
        this.results = results;
    }

    public static StrainerRecipeBuilder strainerRecipe(BlockState aboveBlock, Ingredient input, NonNullList<MeshChanceResult> results) {
        return new StrainerRecipeBuilder(aboveBlock, input, results);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item getResult() {
        return ((MeshChanceResult)this.results.getFirst()).chanceResult().stack().getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"strainer/"));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        StrainerRecipe strainerRecipe = new StrainerRecipe(this.aboveBlock, this.input, this.results);
        recipeOutput.accept(id, (Recipe)strainerRecipe, builder.build(id.withPrefix("recipe/strainer/")));
    }
}

