/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.util;

import com.benbenlaw.strainers.config.StrainersConfigFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class StrainersIngredientDurations {
    private static final Map<Ingredient, Integer> map = new HashMap<Ingredient, Integer>();

    public static void loadItemDurationsFromConfig(List<? extends String> entries) {
        for (String string : entries) {
            Ingredient ingredient;
            String[] parts = string.split("=");
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String durationString = parts[1].trim();
            if (key.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                ingredient = Ingredient.of((TagKey)tag);
            } else {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)key));
                ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
            }
            try {
                int duration = Integer.parseInt(durationString);
                map.put(ingredient, duration);
                System.out.println("Loaded block duration: " + key + " = " + duration);
            }
            catch (Exception e) {
                System.err.println("Error parsing block duration entry: " + string);
            }
        }
    }

    public static Map<Ingredient, Integer> getMap() {
        return map;
    }

    public static int getDuration(ItemStack stack) {
        for (Map.Entry<Ingredient, Integer> entry : map.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        return (Integer)StrainersConfigFile.strainerMaxProgress.get();
    }
}

