/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.screen.custom.CompactorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactorBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            CompactorBlockEntity.this.setChanged();
            CompactorBlockEntity.this.sync();
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (CompactorBlockEntity.this.isInputSlot(slot, stack)) {
                return CompactorBlockEntity.this.insertIntoInputs(stack, simulate);
            }
            if (CompactorBlockEntity.this.isOutputSlot(slot)) {
                return CompactorBlockEntity.this.insertIntoOutputs(stack, simulate);
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public final ContainerData data;
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] OUTPUT_SLOTS = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
    private final IItemHandler compactorItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, this::isInputSlot, this::isOutputSlot);

    private boolean isInputSlot(int slot, ItemStack itemStack) {
        for (int inputSlot : INPUT_SLOTS) {
            if (slot != inputSlot) continue;
            return true;
        }
        return false;
    }

    private boolean isOutputSlot(int slot) {
        for (int outputSlot : OUTPUT_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.compactorItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public CompactorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.COMPACTOR_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new SimpleContainerData(2);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.strainers.compactor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new CompactorMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        if (!this.level.isClientSide() && this.level.getGameTime() % 20L == 0L) {
            for (int slot : INPUT_SLOTS) {
                ItemStack stack = this.itemHandler.getStackInSlot(slot);
                if (stack.isEmpty() || stack.getCount() < 4) continue;
                if (stack.getCount() >= 9 && this.tryCraft(stack, 3, slot)) {
                    return;
                }
                if (stack.getCount() < 4 || !this.tryCraft(stack, 2, slot)) continue;
                return;
            }
        }
    }

    private boolean tryCraft(ItemStack stack, int currentSize, int inputSlot) {
        assert (this.level != null);
        for (RecipeHolder holder : this.level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            ItemStack result;
            ShapedRecipe shapedRecipe;
            CraftingRecipe recipe = (CraftingRecipe)holder.value();
            if (!(recipe instanceof ShapedRecipe) || (shapedRecipe = (ShapedRecipe)recipe).getWidth() != currentSize || shapedRecipe.getHeight() != currentSize) continue;
            boolean matches = true;
            for (Ingredient ingredient : shapedRecipe.getIngredients()) {
                if (ingredient.test(stack)) continue;
                matches = false;
                break;
            }
            if (!matches || (result = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy()).isEmpty() || !this.insertResult(result)) continue;
            stack.shrink(currentSize * currentSize);
            this.itemHandler.setStackInSlot(inputSlot, stack);
            this.setChanged();
            this.sync();
            return true;
        }
        return false;
    }

    private boolean insertResult(ItemStack result) {
        for (int slot : OUTPUT_SLOTS) {
            ItemStack outputStack = this.itemHandler.getStackInSlot(slot);
            if (outputStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)result) || outputStack.getCount() >= outputStack.getMaxStackSize()) continue;
            int transferable = Math.min(result.getCount(), outputStack.getMaxStackSize() - outputStack.getCount());
            outputStack.grow(transferable);
            result.shrink(transferable);
            this.itemHandler.setStackInSlot(slot, outputStack);
            if (!result.isEmpty()) continue;
            return true;
        }
        for (int slot : OUTPUT_SLOTS) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            this.itemHandler.setStackInSlot(slot, result.copy());
            result.setCount(0);
            return true;
        }
        return result.isEmpty();
    }

    private boolean insertInput(ItemStack stack) {
        for (int slot : INPUT_SLOTS) {
            ItemStack existing = this.itemHandler.getStackInSlot(slot);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack) || existing.getCount() >= existing.getMaxStackSize()) continue;
            int transferable = Math.min(stack.getCount(), existing.getMaxStackSize() - existing.getCount());
            existing.grow(transferable);
            stack.shrink(transferable);
            this.itemHandler.setStackInSlot(slot, existing);
            if (!stack.isEmpty()) continue;
            return true;
        }
        for (int slot : INPUT_SLOTS) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            this.itemHandler.setStackInSlot(slot, stack.copy());
            stack.setCount(0);
            return true;
        }
        return stack.isEmpty();
    }

    private ItemStack insertIntoInputs(ItemStack stack, boolean simulate) {
        ItemStack remaining = stack.copy();
        for (int slot : INPUT_SLOTS) {
            int transferable;
            ItemStack existing = this.itemHandler.getStackInSlot(slot);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)remaining) || (transferable = Math.min(remaining.getCount(), existing.getMaxStackSize() - existing.getCount())) <= 0) continue;
            if (!simulate) {
                existing.grow(transferable);
                this.itemHandler.setStackInSlot(slot, existing);
            }
            remaining.shrink(transferable);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (int slot : INPUT_SLOTS) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            if (!simulate) {
                this.itemHandler.setStackInSlot(slot, remaining.copy());
            }
            return ItemStack.EMPTY;
        }
        return remaining;
    }

    private ItemStack insertIntoOutputs(ItemStack stack, boolean simulate) {
        ItemStack remaining = stack.copy();
        for (int slot : OUTPUT_SLOTS) {
            int transferable;
            ItemStack existing = this.itemHandler.getStackInSlot(slot);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)remaining) || (transferable = Math.min(remaining.getCount(), existing.getMaxStackSize() - existing.getCount())) <= 0) continue;
            if (!simulate) {
                existing.grow(transferable);
                this.itemHandler.setStackInSlot(slot, existing);
            }
            remaining.shrink(transferable);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (int slot : OUTPUT_SLOTS) {
            if (!this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            if (!simulate) {
                this.itemHandler.setStackInSlot(slot, remaining.copy());
            }
            return ItemStack.EMPTY;
        }
        return remaining;
    }
}

