/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.integration.jei.JEIBlockRenderHelper;
import com.benbenlaw.strainers.integration.jei.JEIStrainersPlugin;
import com.benbenlaw.strainers.integration.jei.StrainerRecipeDisplay;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.benbenlaw.strainers.util.ModTags;
import com.benbenlaw.strainers.util.StrainersIngredientDurations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class StrainerRecipeCategory
implements IRecipeCategory<StrainerRecipeDisplay> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"strainer");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)"textures/gui/jei_strainer.png");
    public static final RecipeType<StrainerRecipeDisplay> RECIPE_TYPE = RecipeType.create((String)"strainers", (String)"strainer", StrainerRecipeDisplay.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridWidgetFactory;

    public StrainerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 155, 56);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.WOODEN_STRAINER.get()));
        this.scrollGridWidgetFactory = helper.createScrollGridFactory(5, 3);
        this.scrollGridWidgetFactory.setPosition(50, 1);
    }

    public RecipeType<StrainerRecipeDisplay> getRecipeType() {
        return JEIStrainersPlugin.STRAINER;
    }

    public Component getTitle() {
        return Component.literal((String)"Strainers");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(StrainerRecipeDisplay recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)StrainerRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((StrainerRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final StrainerRecipeDisplay recipe, IFocusGroup focusGroup) {
        Fluid fluidState = recipe.aboveBlock().getFluidState().getType();
        if (fluidState == Fluids.EMPTY) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addItemStack(recipe.aboveBlock().getBlock().asItem().getDefaultInstance())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(this){

                public void render(GuiGraphics guiGraphics, ItemStack stack) {
                    JEIBlockRenderHelper.renderBlock(guiGraphics, recipe.aboveBlock(), 1, 12, 0.6f);
                }

                public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
                    ArrayList<Component> tooltip = new ArrayList<Component>();
                    tooltip.add((Component)recipe.aboveBlock().getBlock().getName());
                    BlockState targetState = recipe.aboveBlock();
                    BlockState defaultState = targetState.getBlock().defaultBlockState();
                    for (Map.Entry entry : targetState.getValues().entrySet()) {
                        Comparable defaultValue;
                        Property property = (Property)entry.getKey();
                        Comparable recipeValue = (Comparable)entry.getValue();
                        if (recipeValue.equals(defaultValue = defaultState.getValue(property))) continue;
                        String key = property.getName();
                        String value = recipeValue.toString();
                        tooltip.add((Component)Component.literal((String)(key + ": " + value)));
                    }
                    return tooltip;
                }
            });
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addFluidStack(fluidState)).setFluidRenderer(1000L, true, 16, 16);
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 20).addIngredients(recipe.input())).addRichTooltipCallback((slotView, tooltip) -> {
            Optional<ItemStack> currentItem = Optional.of(slotView.getDisplayedItemStack().orElse(ItemStack.EMPTY));
            if (currentItem.get().is(ModTags.Items.NOT_CONSUMED)) {
                tooltip.add((FormattedText)Component.translatable((String)"block.strainer.jei.not_consumed").withStyle(ChatFormatting.GOLD));
            }
        });
        builder.addSlot(RecipeIngredientRole.CATALYST, 2, 38).addIngredients(recipe.mesh());
        for (ChanceResult result : recipe.getChanceResults()) {
            ((IRecipeSlotBuilder)builder.addSlotToWidget(RecipeIngredientRole.OUTPUT, this.scrollGridWidgetFactory).addItemStack(result.stack())).addRichTooltipCallback((slotView, tooltip) -> {
                double baseChance = result.chance();
                int asPercent = Math.round((float)(baseChance * 100.0));
                tooltip.add((FormattedText)Component.translatable((String)"block.strainer.jei.chance").append(String.valueOf(asPercent)).append("%").withStyle(ChatFormatting.GOLD));
            });
        }
    }

    public void draw(StrainerRecipeDisplay recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)22, (int)20, (int)0, (int)0, (int)26, (int)19)) {
            int duration = StrainersIngredientDurations.getDuration(recipe.input().getItems()[0]);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.strainer.duration", (Object[])new Object[]{duration}), (int)mouseX, (int)mouseY);
        }
    }
}

