/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.core.recipe.ChanceResult;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record MeshChanceResult(ChanceResult chanceResult, Ingredient mesh) {
    public static final MeshChanceResult EMPTY = new MeshChanceResult(ChanceResult.EMPTY, Ingredient.EMPTY);
    public static final Codec<MeshChanceResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(r -> r.chanceResult().stack()), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(r -> Float.valueOf(r.chanceResult().chance())), (App)Ingredient.CODEC.optionalFieldOf("mesh", (Object)Ingredient.EMPTY).forGetter(MeshChanceResult::mesh)).apply((Applicative)instance, (stack, chance, mesh) -> new MeshChanceResult(new ChanceResult(stack, chance.floatValue()), (Ingredient)mesh)));
    public static final StreamCodec<RegistryFriendlyByteBuf, MeshChanceResult> STREAM_CODEC = StreamCodec.of((buffer, value) -> value.write((RegistryFriendlyByteBuf)buffer), MeshChanceResult::read);

    public ItemStack rollOutput(RandomSource rand, ItemStack meshStack) {
        if (!this.mesh.isEmpty() && !this.mesh.test(meshStack)) {
            return ItemStack.EMPTY;
        }
        return this.chanceResult.rollOutput(rand);
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        ChanceResult result = this.chanceResult();
        result.write(buffer);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)this.mesh());
    }

    public static MeshChanceResult read(RegistryFriendlyByteBuf buffer) {
        ChanceResult result = ChanceResult.read((RegistryFriendlyByteBuf)buffer);
        Ingredient mesh = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        return new MeshChanceResult(result, mesh);
    }
}

