/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.strainers.block.custom.StrainerTankBlock;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.benbenlaw.strainers.recipe.MeshChanceResult;
import com.benbenlaw.strainers.recipe.StrainerRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public record StrainerRecipe(BlockState aboveBlock, Ingredient input, NonNullList<MeshChanceResult> results) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        if (level.isClientSide()) {
            return false;
        }
        boolean hasInput = this.input.test(container.getItem(0));
        ItemStack meshStack = container.getItem(1);
        if (container instanceof StrainerRecipeInput) {
            BlockEntity entity;
            StrainerRecipeInput strainerRecipeInput = (StrainerRecipeInput)container;
            if (meshStack.isEmpty()) {
                return false;
            }
            BlockState aboveBlockState = level.getBlockState(strainerRecipeInput.getPos().above());
            if (level.getBlockState(strainerRecipeInput.getPos().above()).getBlock() instanceof StrainerTankBlock && (entity = level.getBlockEntity(strainerRecipeInput.getPos().above())) instanceof StrainerTankBlockEntity) {
                StrainerTankBlockEntity tankEntity = (StrainerTankBlockEntity)entity;
                Fluid fluid = tankEntity.FLUID_TANK.getFluid().getFluid();
                aboveBlockState = fluid.defaultFluidState().createLegacyBlock();
            }
            return hasInput && aboveBlockState.equals(this.aboveBlock) && this.results.stream().anyMatch(meshChanceResult -> meshChanceResult.mesh().test(meshStack));
        }
        return false;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ((MeshChanceResult)this.results.getFirst()).chanceResult().stack();
    }

    public List<ItemStack> getResults() {
        return this.getRollResults().stream().map(results -> results.chanceResult().stack()).collect(Collectors.toList());
    }

    public NonNullList<MeshChanceResult> getRollResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(RandomSource rand, ItemStack meshStack) {
        ArrayList<ItemStack> resultsList = new ArrayList<ItemStack>();
        for (MeshChanceResult output : this.results) {
            ItemStack stack = output.rollOutput(rand, meshStack);
            if (stack.isEmpty()) continue;
            resultsList.add(stack);
        }
        return resultsList;
    }

    public BlockState getBlockAbove() {
        return this.aboveBlock;
    }

    public Ingredient getMesh() {
        return ((MeshChanceResult)this.results.getFirst()).mesh();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StrainerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<StrainerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("above_block").forGetter(StrainerRecipe::aboveBlock), (App)Ingredient.CODEC.fieldOf("input").forGetter(StrainerRecipe::input), (App)Codec.list(MeshChanceResult.CODEC).fieldOf("results").flatXmap(resultList -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)resultList);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(StrainerRecipe::results)).apply((Applicative)instance, StrainerRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, StrainerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<StrainerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, StrainerRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static StrainerRecipe read(RegistryFriendlyByteBuf buffer) {
            BlockState aboveBlock = Block.stateById((int)buffer.readInt());
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.withSize((int)size, (Object)MeshChanceResult.EMPTY);
            outputs.replaceAll(ignored -> MeshChanceResult.read(buffer));
            return new StrainerRecipe(aboveBlock, input, (NonNullList<MeshChanceResult>)outputs);
        }

        private static void write(RegistryFriendlyByteBuf buffer, StrainerRecipe recipe) {
            buffer.writeInt(Block.getId((BlockState)recipe.aboveBlock));
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeVarInt(recipe.results.size());
            for (MeshChanceResult output : recipe.results) {
                output.write(buffer);
            }
        }
    }

    public static class Type
    implements RecipeType<StrainerRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

