/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Cloth;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.FvtmPlayerData;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.data.Recipe;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.model.ModelGroupList;
import net.fexcraft.mod.fvtm.model.ModelLoader;
import net.fexcraft.mod.fvtm.sys.particle.Particle;
import net.fexcraft.mod.fvtm.util.PartItemApp;
import net.fexcraft.mod.fvtm.util.Registry;
import net.fexcraft.mod.fvtm.util.VehItemApp;
import net.fexcraft.mod.fvtm.util.ess.RailSpawnSystem;
import net.fexcraft.mod.fvtm.util.ess.SimplePhysSpawnSystem;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.UniStack;

public class FvtmRegistry {
    public static final String CORE_VER = "1.0.0";
    public static File CONFIG_DIR;
    public static Config CONFIG;
    public static boolean is112;
    public static boolean is120;
    public static boolean is121;
    public static IDL INTERNAL_ADDON_ID;
    public static IDL NONE_CLOTH_MAT;
    public static IDL AIR;
    public static IDL NULL_TEXTURE;
    public static IDL WHITE_TEXTURE;
    public static IDL STANDARD_GAUGE;
    public static final Registry<Addon> ADDONS;
    public static final Registry<Fuel> FUELS;
    public static final Registry<Material> MATERIALS;
    public static final Registry<Consumable> CONSUMABLES;
    public static final Registry<Vehicle> VEHICLES;
    public static final Registry<Part> PARTS;
    public static final Registry<Block> BLOCKS;
    public static final Registry<Cloth> CLOTHES;
    public static final Registry<WireType> WIRES;
    public static final Registry<WireDeco> WIREDECOS;
    public static final Registry<Container> CONTAINERS;
    public static final Registry<RailGauge> RAILGAUGES;
    public static final Registry<MultiBlock> MULTIBLOCKS;
    public static final Registry<Decoration> DECORATIONS;
    public static final Registry<Sign> SIGNS;
    public static final Registry<Recipe> RECIPES;
    public static TreeMap<String, TreeMap<String, ArrayList<Fuel>>> SORTED_FUELS;
    public static final HashMap<String, Particle> PARTICLES;
    public static final LinkedHashMap<String, Class<? extends Attribute<?>>> ATTRIBUTES;
    public static final LinkedHashMap<String, Class<? extends PartFunction>> PART_FUNCTIONS;
    public static final LinkedHashMap<String, Class<? extends BlockFunction>> BLOCK_FUNCTIONS;
    public static final LinkedHashMap<String, ModelGroupList> MODELS;
    public static final ArrayList<ModelLoader> MODEL_LOADERS;
    public static final HashMap<IDL, Object> CONTENT_BLOCKS;
    public static final HashMap<IDL, ItemWrapper> CONTENT_ITEMS;
    public static final HashMap<String, ItemWrapper> ITEMS;

    public static final void init(String loadver, File conf) {
        UniReg.LOADER_VERSION = loadver;
        is112 = EnvInfo.is112();
        is120 = EnvInfo.is120();
        is121 = EnvInfo.is121();
        CONFIG_DIR = conf;
        if (!CONFIG_DIR.exists()) {
            CONFIG_DIR.mkdirs();
        }
        CONFIG = new Config(new File(conf, "fvtm.json"));
        INTERNAL_ADDON_ID = IDLManager.getIDLCached((String)"fvtm:fvtm");
        AIR = IDLManager.getIDLCached((String)"minecraft:air");
        NULL_TEXTURE = IDLManager.getIDLNamed((String)"No Texture;fvtm:textures/entity/null.png");
        WHITE_TEXTURE = IDLManager.getIDLNamed((String)"No Texture;fvtm:textures/entity/white.png");
        STANDARD_GAUGE = IDLManager.getIDLCached((String)"fvtm:standard");
        UniStack.register((Appendable)new VehItemApp(null));
        UniStack.register((Appendable)new PartItemApp(null));
        UniEntity.register((Appendable)new FvtmPlayerData(null));
        EntitySystem.add(new RailSpawnSystem());
        EntitySystem.add(new SimplePhysSpawnSystem());
    }

    public static Addon getAddon(String id) {
        for (Addon addon : ADDONS) {
            if (!addon.getID().id().equals(id)) continue;
            return addon;
        }
        return null;
    }

    public static Fuel getFuel(String id) {
        return FUELS.get(id);
    }

    public static Fuel getFuel(IDL idl) {
        return FUELS.get(idl);
    }

    public static String getFuelName(IDL id) {
        return FvtmRegistry.getFuelName(id.colon());
    }

    public static String getFuelName(String id) {
        Fuel fuel = FvtmRegistry.getFuel(id);
        return fuel == null ? "not-found" : fuel.getName();
    }

    public static ItemWrapper getItem(String id) {
        ItemWrapper wrapper = ITEMS.get(id);
        if (wrapper == null) {
            wrapper = FvtmResources.INSTANCE.getItemWrapper(id);
        }
        return wrapper;
    }

    static {
        ADDONS = new Registry();
        FUELS = new Registry();
        MATERIALS = new Registry();
        CONSUMABLES = new Registry();
        VEHICLES = new Registry();
        PARTS = new Registry();
        BLOCKS = new Registry();
        CLOTHES = new Registry();
        WIRES = new Registry();
        WIREDECOS = new Registry();
        CONTAINERS = new Registry();
        RAILGAUGES = new Registry();
        MULTIBLOCKS = new Registry();
        DECORATIONS = new Registry();
        SIGNS = new Registry();
        RECIPES = new Registry();
        SORTED_FUELS = new TreeMap();
        PARTICLES = new HashMap();
        ATTRIBUTES = new LinkedHashMap();
        PART_FUNCTIONS = new LinkedHashMap();
        BLOCK_FUNCTIONS = new LinkedHashMap();
        MODELS = new LinkedHashMap();
        MODEL_LOADERS = new ArrayList();
        CONTENT_BLOCKS = new HashMap();
        CONTENT_ITEMS = new HashMap();
        ITEMS = new HashMap();
    }
}

