/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.util.Resources21;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.packet.PacketListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class VehicleLiftEntity
extends class_2586
implements PacketListener,
InteractionHandler.InteractRefHolder {
    private InteractionHandler.InteractRef ref = new InteractionHandler.InteractRef(this);
    private VehicleData data;
    public double liftstate;
    private double lowest;
    private double highest;
    private double lslot;
    private double lwheel;
    private boolean onwheels;
    public int rot;

    public VehicleLiftEntity(class_2338 pPos, class_2680 pBlockState) {
        super(Resources21.LIFT_ENTITY, pPos, pBlockState);
    }

    public VehicleData getVehicleData() {
        return this.data;
    }

    public void method_11007(class_2487 com, class_7225.class_7874 prov) {
        super.method_11007(com, prov);
        if (this.data != null) {
            com.method_10566("VehicleData", (class_2520)this.data.write(TagCW.create()).local());
        }
        com.method_10549("LiftState", this.liftstate);
        com.method_10548("Rot", (float)this.rot);
    }

    public void method_11014(class_2487 com, class_7225.class_7874 prov) {
        super.method_11014(com, prov);
        this.rot = com.method_68083("Rot", 0);
        if (com.method_10545("VehicleData")) {
            this.data = FvtmResources.getVehicleData(com.method_10562("VehicleData"));
            this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(this.rot)), true);
        }
        this.liftstate = com.method_68563("LiftState", 0.0);
        this.updateState();
    }

    public class_2487 method_16887(class_7225.class_7874 prov) {
        class_2487 tag = new class_2487();
        this.method_11007(tag, prov);
        return tag;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void updateState() {
        double low;
        if (this.data == null) {
            this.liftstate = 0.0;
            return;
        }
        double ls = this.liftstate;
        this.lwheel = 16.0;
        this.lslot = 16.0;
        this.lowest = 16.0;
        this.highest = -16.0;
        for (LiftingPoint point : ((Vehicle)this.data.getType()).getLiftingPoints().values()) {
            if (this.highest < point.pos.y) {
                this.highest = point.pos.y;
            }
            if (!(this.lowest > point.pos.y)) continue;
            this.lowest = point.pos.y;
        }
        if (((Vehicle)this.data.getType()).getLiftingPoints().isEmpty()) {
            this.lowest = 0.0;
            this.highest = 0.0;
        }
        for (WheelSlot slot : this.data.getWheelSlots().values()) {
            if (!(this.lslot > slot.position.y)) continue;
            this.lslot = slot.position.y;
        }
        if (this.data.getWheelSlots().isEmpty()) {
            this.lslot = 0.0;
        }
        if (this.data.getWheelSlots().size() > 0 && this.data.getWheelPositions().size() > 0) {
            for (V3D vec : this.data.getWheelPositions().values()) {
                if (!(this.lwheel > vec.y)) continue;
                this.lwheel = vec.y;
            }
        } else {
            this.lwheel = this.lslot;
        }
        this.onwheels = this.data.getWheelPositions().size() >= ((Vehicle)this.data.getType()).getVehicleType().minWheels();
        this.liftstate = ls < 1.125 && !this.onwheels ? 1.25 : ls;
        double d = low = this.lslot > this.lowest ? this.lowest : this.lslot;
        if (this.onwheels || this.lwheel < low) {
            low = this.lwheel;
        }
        this.liftstate -= low;
        while (this.liftstate - low > 3.0) {
            this.liftstate -= 0.5;
        }
    }

    public double getState() {
        return this.liftstate + -this.lowest;
    }

    public void setVehicle(class_1799 stack) {
        if (this.data != null) {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, (class_1799)this.data.newItemStack().local()));
            this.data = null;
        }
        if (stack.method_7909() instanceof VehicleItem) {
            this.data = ((VehicleItem)stack.method_7909()).getData(UniStack.getStack((Object)stack));
        }
        this.method_5431();
        this.sendUpdate();
    }

    private void sendUpdate() {
        TagCW com = TagCW.create();
        com.set("pos", this.field_11867.method_10063());
        if (this.data != null) {
            com.set("data", this.data.write(TagCW.create()));
        }
        com.set("task", "update");
        FvtmLogger.marker(com);
        Packets.sendToAll(Packet_TagListener.class, "blockentity", com);
    }

    public void handle(TagCW packet, EntityW player) {
        if (this.field_11863.field_9236) {
            switch (packet.getString("task")) {
                case "update": {
                    if (packet.has("data")) {
                        this.data = FvtmResources.getVehicleData(packet.getCompound("data"));
                        this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(this.rot)), true);
                    } else {
                        this.data = null;
                        this.liftstate = 0.0;
                    }
                    this.updateState();
                    return;
                }
            }
        }
    }

    public V3D getVehicleDataPos() {
        return new V3D((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + this.liftstate + 0.3125, (double)this.field_11867.method_10260() + 0.5);
    }

    public V3I getV3I() {
        return new V3I(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
    }

    public InteractionHandler.InteractRef iref() {
        return this.ref.set(this.getV3I(), this.field_11867.method_10063(), this.getVehicleDataPos());
    }

    @Override
    public void markChanged() {
        this.method_5431();
    }
}

