/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.ItemWrapper;

public class Decoration
extends Content<Decoration>
implements WithItem,
ItemTextureable,
Textureable.TextureHolder,
Colorable.ColorHolder {
    protected byte max_stack;
    protected ItemWrapper item;
    protected String ctab;
    protected IDL itemtexloc;
    protected String modelid;
    protected Model model;
    protected ModelData modeldata = new ModelData();
    protected List<IDL> textures;
    protected Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    protected boolean no3ditem;
    protected boolean randomtex;

    @Override
    public Decoration parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Decoration");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.max_stack = (byte)map.getInteger("MaxItemStackSize", 64);
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("ColorChannels")) {
            for (Map.Entry entry : map.get("ColorChannels").asMap().entries()) {
                this.channels.put((String)entry.getKey(), new RGB(((JsonValue)entry.getValue()).string_value()));
            }
        }
        if (this.channels.isEmpty()) {
            this.channels.put("primary", RGB.WHITE.copy());
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        this.randomtex = map.getBoolean("RandomTexture", false);
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.DECORATION;
    }

    @Override
    public Class<?> getDataClass() {
        return DecorationData.class;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, DefaultModel.class);
    }

    @Override
    public RGB getDefaultColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public Map<String, RGB> getDefaultColorChannels() {
        return this.channels;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    public boolean useRandomTex() {
        return this.randomtex;
    }
}

