/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.part;

import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.util.Rot;
import net.fexcraft.mod.fvtm.util.SaveUtils;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class PartData
extends ContentData<Part, PartData>
implements Textureable.TextureUser {
    public static String DEF_SOURCE = "vehicle";
    protected TreeMap<String, PartFunction> functions = new TreeMap();
    protected Textureable texture;
    protected V3D currentpos = new V3D();
    protected Rot currentrot = new Rot();
    protected String rotpoint;
    protected String source = DEF_SOURCE;

    public PartData(Part type) {
        super(type);
        this.texture = new Textureable(type);
        for (PartFunction func : type.functions) {
            this.functions.put(func.getId(), func.copy(type));
        }
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Part", ((Part)this.type).getIDS());
        if (!this.source.equals(DEF_SOURCE)) {
            compound.set("Source", this.source);
        }
        compound.set("CurrentPos", SaveUtils.saveV3D(this.currentpos));
        this.currentrot.toTag("CurrentRot", compound);
        if (this.rotpoint != null && !this.rotpoint.equals("vehicle")) {
            compound.set("SwivelPoint", this.rotpoint);
        }
        this.texture.save(compound);
        TagLW flist = TagLW.create();
        for (PartFunction func : this.functions.values()) {
            TagCW com = TagCW.create();
            com.set("id", func.getId());
            if ((com = func.save(com)) == null) continue;
            flist.add(com);
        }
        compound.set("Functions", flist);
        return compound;
    }

    @Override
    public PartData read(TagCW compound) {
        if (compound == null || compound.direct() == null) {
            compound = TagCW.create();
        }
        this.currentpos = SaveUtils.loadV3D(compound.getList("CurrentPos"));
        this.currentrot = Rot.fromTag("CurrentRot", compound);
        this.source = compound.has("Source") ? compound.getString("Source") : DEF_SOURCE;
        this.rotpoint = compound.has("SwivelPoint") ? compound.getString("SwivelPoint") : null;
        this.texture.load(compound);
        if (compound.has("Functions")) {
            TagLW list = compound.getList("Functions");
            for (int i = 0; i < list.size(); ++i) {
                TagCW com = list.getCompound(i);
                Object func = this.getFunction(com.getString("id"));
                if (func == null) continue;
                ((PartFunction)func).load(com);
            }
        }
        return this;
    }

    @Override
    public PartData parse(JsonMap map) {
        this.currentpos = SaveUtils.loadV3D(map.getArray("CurrentPos", 0));
        this.currentrot = Rot.fromJson(map, "CurrentPos");
        this.source = map.getString("Source", DEF_SOURCE);
        return this;
    }

    @Override
    public JsonMap toJson() {
        JsonMap obj = new JsonMap();
        obj.add("Part", ((Part)this.type).getIDS());
        obj.add("CurrentPos", (JsonValue)SaveUtils.saveV3DJson(this.currentpos));
        obj.add("Source", this.source);
        if (!this.currentrot.isNull()) {
            obj.add("CurrentRot", (JsonValue)this.currentrot.toJson());
        }
        return obj;
    }

    public V3D getInstalledPos() {
        return this.currentpos;
    }

    public void setInstalled(String src, V3D pos, Rot rot) {
        if (pos != null) {
            this.currentpos = pos;
        }
        if (rot != null) {
            this.currentrot = rot;
        }
        this.source = src == null ? DEF_SOURCE : src;
    }

    public Rot getInstalledRot() {
        return this.currentrot;
    }

    public void setInstalledOnSwivelPoint(String newpoint) {
        this.rotpoint = newpoint;
    }

    public String getSwivelPointInstalledOn() {
        return this.rotpoint;
    }

    public boolean isInstalledOnSwivelPoint() {
        return this.rotpoint != null;
    }

    public boolean isInstalledOnSwivelPoint(String point) {
        return this.rotpoint == null ? point.equals("vehicle") : this.rotpoint.equals(point);
    }

    public Map<String, PartFunction> getFunctions() {
        return this.functions;
    }

    public <F extends PartFunction> F getFunction(String id) {
        return (F)this.functions.get(id);
    }

    public <F> F getFunction(Class<F> clazz, String id) {
        return (F)this.functions.get(id);
    }

    public <F> F getFunction(Class<F> clazz, String id, String alt) {
        if (!this.functions.containsKey(id)) {
            return (F)this.functions.get(alt);
        }
        return (F)this.functions.get(id);
    }

    public <F extends PartFunction> F getFunction(IDL idl) {
        return this.getFunction(idl.toString());
    }

    public boolean hasFunction(String string) {
        return this.getFunction(string) != null;
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }

    public String getSource() {
        return this.source;
    }
}

