/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.root;

import java.util.UUID;
import net.fexcraft.mod.fvtm.data.Saveable;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.MessageSender;

public class Lockable
implements Saveable {
    private String code;
    private boolean locked;
    public static final IDL DEFAULT_KEY = IDLManager.getIDLCached((String)"gep:key");

    public boolean isLocked() {
        return this.locked;
    }

    public String getCode() {
        return this.code;
    }

    public void setLocked(Boolean bool) {
        this.locked = bool == null ? !this.locked : bool;
    }

    public static String newCode() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    public static boolean isKey(ItemWrapper item) {
        return item.local() instanceof LockableItem;
    }

    public void toggle(MessageSender sender, StackWrapper stack) {
        boolean valid = stack.getItem().direct() instanceof LockableItem;
        if (!valid || ((LockableItem)stack.getItem().local()).getLockCode(stack) == null) {
            sender.send("&cThis is not a key.");
            return;
        }
        String icode = ((LockableItem)stack.getItem().local()).getLockCode(stack);
        if (icode.equals(this.getCode())) {
            this.setLocked(null);
            sender.bar(this.isLocked() ? "&cLocked." : "&aUnlocked.");
        } else {
            sender.bar("&cKey code does not match.");
        }
    }

    @Override
    public void save(TagCW com) {
        com.set("Locked", this.locked);
        if (this.code != null) {
            com.set("LockCode", this.code);
        }
    }

    @Override
    public void load(TagCW com) {
        this.locked = com.getBoolean("Locked");
        this.code = com.has("LockCode") ? com.getString("LockCode") : Lockable.newCode();
    }

    public static interface LockableItem {
        public String getLockCode(StackWrapper var1);
    }
}

