/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.impl.EntityWIE;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.SpawnPacket;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1804;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class RootVehicle
extends class_1297
implements SpawnPacket.PacketEntity {
    public VehicleInstance vehicle = new VehicleInstance(new EntityWIE(this), null);
    public class_3341 renderbox;
    public float rotZ = 0.0f;
    public float protZ = 0.0f;
    private int synctimer;
    public boolean should_sit = true;

    public RootVehicle(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void initVD(VehicleData data) {
        this.vehicle.init(data, null);
        this.init(null);
    }

    protected void init(TagCW com) {
        if (this.method_37908().field_9236) {
            int w = this.vehicle.data.getAttribute("hitbox_width").asInteger();
            int h = this.vehicle.data.getAttribute("hitbox_height").asInteger();
            this.renderbox = new class_3341(-w, -h, -w, w, h, w);
        }
    }

    protected void method_5749(class_2487 tag) {
        TagCW com = TagCW.wrap((Object)tag);
        this.method_36457(com.getFloat("RotationPitch"));
        this.method_36456(com.getFloat("RotationYaw"));
        this.protZ = this.rotZ = com.getFloat("RotationRoll");
        this.method_22862();
        this.vehicle.init(null, com);
        this.init(com);
    }

    protected void method_5652(class_2487 tag) {
        TagCW com = TagCW.wrap((Object)tag);
        this.vehicle.data.write(com);
        this.vehicle.point.savePivot(com);
    }

    @Override
    public void writeSpawnData(TagCW com) {
        this.vehicle.point.savePivot(com);
        if (this.vehicle.front != null) {
            com.set("TruckId", this.vehicle.front.entity.getId());
        }
        this.vehicle.data.write(com);
    }

    @Override
    public void readSpawnData(TagCW com) {
        try {
            this.vehicle.init(null, com);
            this.init(com);
            this.method_36456(this.vehicle.point.getPivot().deg_yaw());
            this.method_36457(this.vehicle.point.getPivot().deg_pitch());
            this.protZ = this.rotZ = this.vehicle.point.getPivot().deg_roll();
            this.method_22862();
        }
        catch (Exception e) {
            e.printStackTrace();
            FvtmLogger.log((Object)("Failed to read additional spawn data for vehicle entity with ID " + this.method_5628() + "!"));
        }
    }

    public void method_5768(class_3218 level) {
        if (this.vehicle != null) {
            this.vehicle.onRemove();
        }
        super.method_5768(level);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.method_31481() || hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        int res = this.vehicle.onInteract((Passenger)UniEntity.getEntity((Object)player), UniStack.getStack((Object)player.method_5998(hand)));
        return res == 1 ? class_1269.field_5812 : (res == 0 ? class_1269.field_5811 : class_1269.field_5814);
    }

    private boolean isFuelContainer(class_1792 item) {
        if (!(item instanceof MaterialItem)) {
            return false;
        }
        return ((MaterialItem)item).getContent().isFuelContainer();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_31481()) {
            return;
        }
        if (this.vehicle.data == null) {
            if (this.method_37908().field_9236 && this.synctimer < 1) {
                ClientPlayNetworking.send((class_8710)new SpawnPacket(this));
                this.synctimer = 10;
            }
            --this.synctimer;
            FvtmLogger.log((Object)("Vehicle '" + this.method_5628() + "' has no data, skipping update. " + this.method_37908().field_9236));
            return;
        }
        ++this.field_6012;
        if (this.field_6012 >= Integer.MAX_VALUE) {
            this.field_6012 = 0;
        }
        this.field_5982 = this.vehicle.point.getPivot().deg_yaw();
        this.field_6004 = this.vehicle.point.getPivot().deg_pitch();
        this.protZ = this.vehicle.point.getPivot().deg_roll();
        this.vehicle.onUpdate();
        if (!this.method_37908().field_9236 && this.field_6012 % Config.VEHICLE_SYNC_RATE == 0) {
            this.vehicle.sendUpdatePacket();
        }
    }

    public class_1657 getDriver() {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!seat.seat.driver || !seat.passengerIsPlayer()) continue;
            return (class_1657)seat.passenger().local();
        }
        return null;
    }

    public class_1309 method_5642() {
        return null;
    }

    public void method_5865(class_1297 pass, class_1297.class_4738 movefunc) {
        SeatInstance seat = this.getSeatOf(pass);
        if (seat != null) {
            this.updatePassenger(pass, seat);
        } else {
            pass.method_33574(this.method_19538());
        }
    }

    public void updatePassenger(class_1297 pass, SeatInstance seat) {
        if (seat.passenger_direct() != pass) {
            seat.passenger((EntityW)UniEntity.getCasted((Object)pass));
        }
        V3D pos = seat.getCurrentGlobalPosition();
        pass.method_5814(pos.x, pos.y - (pass instanceof class_1657 ? 0.7 : 0.0), pos.z);
    }

    public void method_5627(class_1297 pass) {
        super.method_5627(pass);
        SeatInstance seat = this.getSeatOf(pass);
        if (seat != null) {
            seat.passenger((EntityW)UniEntity.getCasted((Object)pass));
        }
    }

    public void method_5793(class_1297 pass) {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!pass.equals(seat.passenger_direct())) continue;
            seat.passenger(null);
        }
        if (!this.method_37908().field_9236) {
            ((Passenger)UniEntity.getCasted((Object)pass)).set(-1, -1);
        }
        super.method_5793(pass);
    }

    public void method_5772() {
        super.method_5772();
    }

    protected boolean method_5818(class_1297 passenger) {
        return true;
    }

    public SeatInstance getSeatOf(class_1297 entity) {
        Passenger pass = (Passenger)UniEntity.getCasted((Object)entity);
        if (pass == null || pass.seat() < 0 || this.vehicle.seats.isEmpty() || pass.seat() >= this.vehicle.seats.size()) {
            return null;
        }
        return this.vehicle.seats.get(pass.seat());
    }

    public boolean method_64397(class_3218 level, class_1282 source, float f) {
        if (source.method_5526() instanceof class_1657 && this.getDriver() == null) {
            EngineFunction engine;
            Passenger pass = (Passenger)UniEntity.getCasted((Object)source.method_5526());
            class_1657 player = (class_1657)source.method_5526();
            if (this.vehicle.data.getLock().isLocked()) {
                pass.send("interact.fvtm.vehicle.remove_locked");
                return false;
            }
            EngineFunction engineFunction = engine = this.vehicle.data.hasPart("engine") ? (EngineFunction)this.vehicle.data.getFunctionInPart("engine", "fvtm:engine") : null;
            if (engine != null) {
                engine.setState(false);
            }
            if (this.vehicle.type.isRailVehicle()) {
                this.vehicle.railent.remove();
            } else {
                VehicleInstance trailer = this.vehicle;
                while ((trailer = trailer.rear) != null) {
                    class_1297 rear = (class_1297)trailer.entity.local();
                    rear.method_5699(level, (class_1799)trailer.data.newItemStack().local(), 0.5f);
                    rear.method_5768(level);
                }
            }
            this.method_5699(level, (class_1799)this.vehicle.data.newItemStack().local(), 0.5f);
            this.method_5768(level);
            return true;
        }
        return true;
    }

    public class_1799 method_31480() {
        return (class_1799)this.vehicle.data.newItemStack().local();
    }

    public void method_5750(double x, double y, double z) {
    }

    public void method_5683(float y, int x) {
    }

    public void method_52532(int sm, double x, double y, double z, double yr, double xr) {
    }

    public void method_66246(class_243 vec3, float f, float g) {
    }

    public boolean processSeatInteract(int seatidx, class_3222 player, class_1268 hand) {
        if (this.method_37908().field_9236 || seatidx < 0 || seatidx >= this.vehicle.seats.size()) {
            return false;
        }
        class_1799 stack = player.method_5998(hand);
        SeatInstance seat = this.vehicle.seats.get(seatidx);
        Passenger pass = (Passenger)UniEntity.getCasted((Object)player);
        if (Lockable.isKey(FvtmRegistry.getItem(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString())) && !this.isFuelContainer(stack.method_7909())) {
            this.vehicle.data.getLock().toggle((MessageSender)pass, UniStack.getStack((Object)stack));
            this.vehicle.sendUpdate("lock_state");
            return true;
        }
        if (this.vehicle.data.getLock().isLocked()) {
            player.method_64398((class_2561)class_2561.method_43471((String)"interact.fvtm.vehicle.locked"));
            return true;
        }
        if (seat.interacttimer > 0) {
            return false;
        }
        if (stack.method_7909() instanceof class_1804) {
            if (seat.passenger() != null) {
                if (seat.passenger().isPlayer()) {
                    return false;
                }
                if (seat.passenger().isLiving()) {
                    class_1308 ent2 = (class_1308)seat.passenger().local();
                    ent2.method_18375();
                    ent2.method_60964((class_1297)player, true);
                    seat.interacttimer = (byte)(seat.interacttimer + 10);
                    return true;
                }
            }
            double range = 10.0;
            V3D pos = new V3D(this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350);
            class_238 aabb = new class_238(pos.x - range, pos.y - range, pos.z - range, pos.x + range, pos.y + range, pos.z + range);
            List nearby = this.method_37908().method_8333((class_1297)this, aabb, ent -> ent instanceof class_1308);
            for (class_1297 entity : nearby) {
                class_1308 mob = (class_1308)entity;
                Passenger ment = (Passenger)UniEntity.getCasted((Object)mob);
                if (!mob.method_60953() || mob.method_60952() != player) continue;
                if (!seat.seat.allow(ment)) {
                    player.method_64398((class_2561)class_2561.method_43470((String)("&eSeat does not accept this entity kind. (" + String.valueOf(entity.method_5477()) + ")")));
                    continue;
                }
                ment.set(this.method_5628(), seatidx);
                seat.elook.set_rotation(-entity.method_36454(), entity.method_36455(), 0.0f, true);
                mob.method_5932();
                entity.method_5804((class_1297)this);
                break;
            }
            seat.interacttimer = (byte)(seat.interacttimer + 10);
            return true;
        }
        if (seat.passenger() == null) {
            if (!seat.seat.allow(pass)) {
                player.method_64398((class_2561)class_2561.method_43470((String)"&eSeat does not accept players as passengers."));
                return false;
            }
            if (player.method_5765() && player.method_5854().equals((Object)this.vehicle)) {
                SeatInstance oseat = this.vehicle.getSeatOf(player);
                oseat.passenger(null);
                pass.set(this.method_5628(), seatidx);
                seat.passenger(pass);
            } else {
                player.method_18375();
                pass.set(this.method_5628(), seatidx);
                player.method_5804((class_1297)this);
            }
            seat.interacttimer = (byte)(seat.interacttimer + 10);
            return true;
        }
        return false;
    }

    public void onPacket(EntityW player, TagCW packet) {
    }
}

