/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.particle;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.sys.particle.ParticleType;

public class Particle {
    public ParticleType type;
    public int persistence;
    public int frequency;
    public V3D dir;
    public RGB color = RGB.GREEN;
    public RGB color_to;
    public float scale = 0.0625f;
    public float scale_to;
    public float speed;
    public float alpha = 1.0f;
    public float alpha_to;
    public final String id;
    public String next;
    public Polyhedron model;
    public static Polyhedron cubemodel = new Polyhedron();

    public Particle(String id) {
        this(id, ParticleType.CUBOID);
    }

    public Particle(String id, ParticleType type) {
        this.type = type;
        this.id = id;
        FvtmRegistry.PARTICLES.put(id, this);
    }

    public Particle(String id, JsonMap map) {
        this(id, ParticleType.valueOf(map.getString("type", ParticleType.CUBOID.name()).toUpperCase()));
        this.setTiming(map.getInteger("ticks", 200), map.getInteger("frequency", 10));
        this.dir = new V3D();
        if (map.has("direction")) {
            JsonArray array = map.getArray("direction");
            this.dir.x = array.get(0).float_value();
            this.dir.y = array.get(1).float_value();
            this.dir.z = array.get(2).float_value();
        }
        this.speed = map.getFloat("speed", 0.01f);
        this.setScale(map.getFloat("scale", 0.0625f), map.has("scale_to") ? map.getFloat("scale_to", 0.5f) : 0.0f);
        if (map.has("color")) {
            this.color = new RGB(map.getString("color", "#ffffff"));
        }
        if (map.has("color_to")) {
            this.color_to = new RGB(map.getString("color_to", "#000000"));
        }
        this.next = map.getString("next", null);
        switch (this.type) {
            case CUBOID: {
                this.model = cubemodel;
                break;
            }
            case FLAT: {
                break;
            }
            case MODEL: {
                break;
            }
            case SPHERE: {
                break;
            }
        }
        if (map.has("alpha")) {
            this.alpha = map.getFloat("alpha", this.alpha);
        }
        if (map.has("alpha_to")) {
            this.alpha_to = map.getFloat("alpha_to", 0.0f);
        }
    }

    public Particle setTiming(int persistence, int frequency) {
        this.persistence = persistence;
        this.frequency = frequency;
        return this;
    }

    public Particle setDirection(V3D vector) {
        this.dir = vector;
        return this;
    }

    public Particle setSpeed(float value) {
        this.speed = value;
        return this;
    }

    public Particle setModel(Polyhedron model) {
        this.model = model;
        return this;
    }

    public Particle setColor(RGB color, RGB end) {
        this.color = color;
        this.color_to = end;
        return this;
    }

    public Particle setScale(float scale, float end) {
        return this.setScale(scale, end, true);
    }

    public Particle setScale(float _scale, float end, boolean sth) {
        this.scale = _scale;
        this.scale_to = end;
        if (!sth) {
            this.scale *= 0.0625f;
            this.scale_to *= 0.0625f;
        }
        return this;
    }

    public Particle setTransparency(float trans, float trans_to) {
        this.alpha = trans;
        this.alpha_to = trans_to;
        return this;
    }

    public Particle setNext(String id) {
        this.next = id;
        return this;
    }

    static {
        cubemodel.newGen().set("x", (Object)Float.valueOf(-0.5f)).set("y", (Object)Float.valueOf(-0.5f)).set("z", (Object)Float.valueOf(-0.5f)).set("width", (Object)1).set("height", (Object)1).set("depth", (Object)1).make();
    }
}

