/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.FuelFiller;
import net.fexcraft.mod.fvtm.ui.FuelFillerUI;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class FuelFillerCon
extends ContainerInterface {
    protected FuelFiller.FuelFillerContainer tile;
    protected FuelFiller filler;
    protected int timer = 10;

    public FuelFillerCon(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
        this.tile = (FuelFiller.FuelFillerContainer)ply.entity.getWorld().getBlockEntity(pos);
        this.filler = this.tile.getFuelFiller();
        this.inventory = this.filler.items;
    }

    public void packet(TagCW com, boolean client) {
        if (com.has("sel")) {
            this.filler.selected = FvtmRegistry.getFuel(com.getString("sel"));
            this.filler.tank.clear();
            this.filler.converted = 0.0f;
            if (client) {
                ((FuelFillerUI)this.ui).updateSelectedText(true);
            } else {
                SEND_TO_CLIENT.accept(com, this.player);
            }
        }
        if (com.has("sync") && client) {
            this.filler.tank.amount(com.getString("t"), com.getInteger("s"));
            this.filler.converted = com.getInteger("c");
        }
    }

    public void update(Object localcon) {
        if (this.player.entity.isOnClient()) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = 10;
        TagCW com = TagCW.create();
        com.set("sync", true);
        com.set("s", this.filler.tank.amount());
        com.set("t", this.filler.tank.getFluid());
        com.set("c", this.filler.converted);
        SEND_TO_CLIENT.accept(com, this.player);
    }
}

