/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JColorChooser;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class ToolboxPainter
extends UserInterface {
    private ArrayList<String> channels = new ArrayList();
    public String selchan;
    public RGB current = new RGB();
    private File cachedcolors = null;

    public ToolboxPainter(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
    }

    public void init() {
        this.channels.addAll((Collection)this.container.get("channel_keys", new Object[0]));
        this.selchan = this.channels.get(0);
        this.setupSpectrum();
        this.setupShadePalette();
        this.updateColors();
        this.cachedcolors = new File(FvtmRegistry.CONFIG_DIR, "/fvtm/custom_palette.fvtm");
        if (!this.cachedcolors.exists()) {
            this.cachedcolors.getParentFile().mkdirs();
        }
        this.loadColorCache();
    }

    private void setupSpectrum() {
        UIButton spec = (UIButton)this.buttons.get("pal_hor");
        for (int i = 0; i < spec.palette[0].length; ++i) {
            int b;
            int g;
            int r;
            float c = (float)i * (1.0f / (float)spec.palette[0].length);
            if (c >= 0.0f && c <= 0.16666667f) {
                r = 255;
                g = (int)(1530.0f * c);
                b = 0;
            } else if (c > 0.16666667f && c <= 0.33333334f) {
                r = (int)(255.0f - 1530.0f * (c - 0.16666667f));
                g = 255;
                b = 0;
            } else if (c > 0.33333334f && c <= 0.5f) {
                r = 0;
                g = 255;
                b = (int)(1530.0f * (c - 0.33333334f));
            } else if (c > 0.5f && c <= 0.6666667f) {
                r = 0;
                g = (int)(255.0f - (c - 0.5f) * 1530.0f);
                b = 255;
            } else if (c > 0.6666667f && c <= 0.8333333f) {
                r = (int)((c - 0.6666667f) * 1530.0f);
                g = 0;
                b = 255;
            } else if (c > 0.8333333f && c <= 1.0f) {
                r = 255;
                g = 0;
                b = (int)(255.0f - (c - 0.8333333f) * 1530.0f);
            } else {
                r = 127;
                g = 127;
                b = 127;
            }
            spec.palette[0][i] = new RGB(r, g, b);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        switch (id) {
            case "prev": {
                int idx = this.channels.indexOf(this.selchan);
                this.selchan = idx == 0 ? this.channels.get(this.channels.size() - 1) : this.channels.get(idx - 1);
                this.current.packed = ((RGB)this.container.get((String)"color", (Object[])new Object[]{this.selchan})).packed;
                this.updateColors();
                break;
            }
            case "next": {
                int idx = this.channels.indexOf(this.selchan);
                this.selchan = idx + 1 >= this.channels.size() ? this.channels.get(0) : this.channels.get(idx + 1);
                this.current.packed = ((RGB)this.container.get((String)"color", (Object[])new Object[]{this.selchan})).packed;
                this.updateColors();
                break;
            }
            case "pal_hor": 
            case "pal_save": {
                int idx = (x - button.x) / button.palsize[0];
                if (idx < 0) {
                    idx = 0;
                }
                if (idx >= button.palette[0].length) {
                    idx = button.palette[0].length - 1;
                }
                RGB rgb = button.palette[0][idx];
                this.current.packed = rgb.packed;
                this.updateColors();
                break;
            }
            case "pal_shade": {
                int ix = (x - button.x) / button.palsize[0];
                int iy = (y - button.y) / button.palsize[1];
                if (ix < 0) {
                    ix = 0;
                }
                if (ix >= button.palette[0].length) {
                    ix = button.palette[0].length - 1;
                }
                if (iy < 0) {
                    iy = 0;
                }
                if (iy >= button.palette.length) {
                    iy = button.palette.length - 1;
                }
                RGB rgb = button.palette[iy][ix];
                this.current.packed = rgb.packed;
                this.updateColors(mb == 0);
                break;
            }
            case "hex": {
                try {
                    int i;
                    this.current.packed = i = Integer.parseInt(((UIField)this.fields.get("hex")).text().replace("#", ""), 16);
                    this.updateColors();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "rgb": {
                try {
                    String[] split = ((UIField)this.fields.get("rgb")).text().split(",");
                    int[] arr = new int[]{255, 255, 255};
                    for (int i = 0; i < split.length; ++i) {
                        arr[i] = Integer.parseInt(split[i].trim());
                        if (arr[i] < 0) {
                            arr[i] = 0;
                        }
                        if (arr[i] <= 255) continue;
                        arr[i] = 255;
                    }
                    this.current = new RGB(arr[0], arr[1], arr[2]);
                    this.updateColors();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "select": {
                TagCW com = TagCW.create();
                com.set("task", "apply");
                com.set("channel", this.selchan);
                com.set("color", this.current.packed);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "colorpicker": {
                try {
                    new Thread(){

                        @Override
                        public void run() {
                            Color color = JColorChooser.showDialog(null, "select color", new Color(ToolboxPainter.this.current.packed));
                            ToolboxPainter.this.current.packed = new RGB((int)color.getRGB()).packed;
                            ToolboxPainter.this.updateColors();
                        }
                    }.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "save": {
                this.saveColorCache();
                break;
            }
            case "help": {
                this.container.get("open_wiki", new Object[0]);
                break;
            }
        }
        return false;
    }

    private void updateColors() {
        this.updateColors(true);
    }

    private void updateColors(boolean shade) {
        ((UIButton)this.buttons.get((Object)"selected")).ecolor.packed = this.current.packed;
        ((UIText)this.texts.get("channel")).value(this.selchan);
        ((UIField)this.fields.get("hex")).text(Integer.toHexString(this.current.packed));
        byte[] arr = this.current.toByteArray();
        ((UIField)this.fields.get("rgb")).text(arr[0] + 128 + ", " + (arr[1] + 128) + ", " + (arr[2] + 128));
        if (shade) {
            this.setupShadePalette();
        }
    }

    private void setupShadePalette() {
        UIButton shade = (UIButton)this.buttons.get("pal_shade");
        byte[] arr = this.current.toByteArray();
        int[] err = new int[]{arr[0] + 128, arr[1] + 128, arr[2] + 128};
        for (int x = 0; x < shade.palette.length; ++x) {
            for (int z = 0; z < shade.palette[x].length; ++z) {
                int y = z * shade.palette.length + x;
                float e = 1.0f / (float)(shade.palette.length * shade.palette[x].length) * (float)y;
                float f = 1.0f / (float)shade.palette.length * (float)x;
                float h = 255 / shade.palette.length * z;
                int r = (int)Math.abs(e * (float)err[0] + (1.0f - f) * h);
                int g = (int)Math.abs(e * (float)err[1] + (1.0f - f) * h);
                int l = (int)Math.abs(e * (float)err[2] + (1.0f - f) * h);
                shade.palette[x][z] = new RGB(r, g, l);
            }
        }
    }

    private void loadColorCache() {
        try {
            byte[] bit;
            if (!this.cachedcolors.exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream(this.cachedcolors);
            UIButton button = (UIButton)this.buttons.get("pal_save");
            int r = 0;
            int i = 0;
            while ((r >= 0 || i >= button.palette[0].length) && (r = stream.read(bit = new byte[4])) >= 0) {
                button.palette[0][i++].packed = ByteBuffer.wrap(bit).getInt();
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveColorCache() {
        try {
            UIButton button = (UIButton)this.buttons.get("pal_save");
            for (int i = button.palette[0].length - 2; i >= 0; --i) {
                button.palette[0][i + 1].packed = button.palette[0][i].packed;
            }
            button.palette[0][0].packed = this.current.packed;
            FileOutputStream stream = new FileOutputStream(this.cachedcolors);
            for (RGB color : button.palette[0]) {
                stream.write(ByteBuffer.allocate(4).putInt(color.packed).array());
            }
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

