/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.ui.road.RoadToolCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RoadToolUI
extends UserInterface {
    protected RoadToolCon rtc;
    protected int[] size = new int[]{1, 0, 0, 0, 0, 0};

    public RoadToolUI(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.rtc = (RoadToolCon)con;
        if (!this.rtc.stack.directTag().has("RoadLayers")) {
            this.rtc.stack.updateTag(tag -> tag.set("RoadLayers", this.size));
        } else {
            this.size = this.rtc.stack.directTag().getIntArray("RoadLayers");
        }
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.rtc.custom_road) {
            ((UIText)this.texts.get("road_fill")).value("ui.fvtm.road_tool.road_fill_custom");
            ((UIText)this.texts.get("road_fill")).translate();
        } else if (this.rtc.inventory.empty(0)) {
            ((UIText)this.texts.get("road_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("road_fill")).translate();
        } else {
            ((UIText)this.texts.get("road_fill")).value(this.rtc.inventory.get(0).getName());
        }
        ((UIText)this.texts.get("road_width")).value("ui.fvtm.road_tool.road_fill_width");
        ((UIText)this.texts.get("road_width")).translate(new Object[]{this.size[0]});
        if (this.rtc.inventory.empty(1)) {
            ((UIText)this.texts.get("ground_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("ground_fill")).translate();
        } else {
            ((UIText)this.texts.get("ground_fill")).value(this.rtc.inventory.get(1).getName());
        }
        ((UIText)this.texts.get("ground_status")).value("ui.fvtm.road_tool.ground_fill_" + (this.size[1] > 0 ? "enabled" : "disabled"));
        ((UIText)this.texts.get("ground_status")).translate();
        if (this.rtc.inventory.empty(2)) {
            ((UIText)this.texts.get("left_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("left_fill")).translate();
        } else {
            ((UIText)this.texts.get("left_fill")).value(this.rtc.inventory.get(2).getName());
        }
        if (this.size[2] > 0) {
            ((UIText)this.texts.get("left_size")).value("ui.fvtm.road_tool.left_fill_size");
            ((UIText)this.texts.get("left_size")).translate(new Object[]{this.size[2]});
        } else {
            ((UIText)this.texts.get("left_size")).value("ui.fvtm.road_tool.left_fill_disabled");
            ((UIText)this.texts.get("left_size")).translate();
        }
        if (this.rtc.inventory.empty(3)) {
            ((UIText)this.texts.get("right_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("right_fill")).translate();
        } else {
            ((UIText)this.texts.get("right_fill")).value(this.rtc.inventory.get(3).getName());
        }
        if (this.size[3] > 0) {
            ((UIText)this.texts.get("right_size")).value("ui.fvtm.road_tool.right_fill_size");
            ((UIText)this.texts.get("right_size")).translate(new Object[]{this.size[3]});
        } else {
            ((UIText)this.texts.get("right_size")).value("ui.fvtm.road_tool.right_fill_disabled");
            ((UIText)this.texts.get("right_size")).translate();
        }
        if (this.rtc.custom_top) {
            ((UIText)this.texts.get("top_fill")).value("ui.fvtm.road_tool.top_fill_custom");
            ((UIText)this.texts.get("top_fill")).translate();
        } else if (this.rtc.inventory.empty(4)) {
            ((UIText)this.texts.get("top_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("top_fill")).translate();
        } else {
            ((UIText)this.texts.get("top_fill")).value(this.rtc.inventory.get(4).getName());
        }
        ((UIText)this.texts.get("top_status")).value("ui.fvtm.road_tool.top_fill_" + (this.size[4] > 0 ? "enabled" : "disabled"));
        ((UIText)this.texts.get("top_status")).translate();
        if (this.rtc.custom_lines) {
            ((UIText)this.texts.get("lines_fill")).value("ui.fvtm.road_tool.lines_fill_custom");
            ((UIText)this.texts.get("lines_fill")).translate();
        } else if (this.rtc.inventory.empty(5)) {
            ((UIText)this.texts.get("lines_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("lines_fill")).translate();
        } else {
            ((UIText)this.texts.get("lines_fill")).value(this.rtc.inventory.get(5).getName());
        }
        ((UIText)this.texts.get("lines_status")).value("ui.fvtm.road_tool.lines_fill_" + (this.size[5] > 0 ? "enabled" : "disabled"));
        ((UIText)this.texts.get("lines_status")).translate();
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "add_width": {
                this.size(0, 1);
                return true;
            }
            case "sub_width": {
                this.size(0, -1);
                return true;
            }
            case "enable_ground": {
                this.size(1, 1);
                return true;
            }
            case "disable_ground": {
                this.size(1, -1);
                return true;
            }
            case "add_left": {
                this.size(2, 1);
                return true;
            }
            case "sub_left": {
                this.size(2, -1);
                return true;
            }
            case "add_right": {
                this.size(3, 1);
                return true;
            }
            case "sub_right": {
                this.size(3, -1);
                return true;
            }
            case "enable_top": {
                this.size(4, 1);
                return true;
            }
            case "disable_top": {
                this.size(4, -1);
                return true;
            }
            case "enable_lines": {
                this.size(5, 1);
                return true;
            }
            case "disable_lines": {
                this.size(5, -1);
                return true;
            }
            case "edit_road": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 0);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "edit_top": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 4);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "edit_lines": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 5);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_road": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 0);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_top": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 4);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_lines": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 5);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
        }
        return false;
    }

    protected void size(int idx, int am) {
        switch (idx) {
            case 0: 
            case 2: 
            case 3: {
                if (this.size[idx] + am < 0 || this.size[idx] + am > 64) break;
                int n = idx;
                this.size[n] = this.size[n] + am;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                if (this.size[idx] + am < 0 || this.size[idx] + am >= 2) break;
                int n = idx;
                this.size[n] = this.size[n] + am;
            }
        }
        TagCW compound = TagCW.create();
        compound.set("sizes", this.size);
        compound.set("cargo", "save");
        ContainerInterface.SEND_TO_SERVER.accept(compound);
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (this.rtc.inventory.empty(0) && ((UISlot)this.slots.get("road")).hovered(this.gLeft, this.gTop, mx, my)) {
            for (int i = 0; i < 8; ++i) {
                list.add((String)ContainerInterface.TRANSLATOR.apply("ui.fvtm.road_tool.road_slot_info" + i));
            }
        }
    }
}

