/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.math.V3D;

public class MiniBB {
    private double x0;
    private double x1;
    private double y0;
    private double y1;
    private double z0;
    private double z1;
    public V3D center = new V3D();

    public MiniBB(V3D pos, double radius) {
        this.update(pos, radius);
    }

    public MiniBB(V3D one, V3D two) {
        this.update(one, two);
    }

    public MiniBB() {
    }

    public boolean contains(V3D vec) {
        if (vec.x >= this.x0 && vec.x <= this.x1 && vec.y >= this.y0 && vec.y <= this.y1) {
            return vec.z >= this.z0 && vec.z <= this.z1;
        }
        return false;
    }

    public MiniBB update(V3D pos, double radius) {
        this.x0 = pos.x - radius;
        this.x1 = pos.x + radius;
        this.y0 = pos.y - radius;
        this.y1 = pos.y + radius;
        this.z0 = pos.z - radius;
        this.z1 = pos.z + radius;
        this.center = pos;
        return this;
    }

    public MiniBB update(V3D one, V3D two) {
        this.x0 = Math.min(one.x, two.x);
        this.x1 = Math.max(one.x, two.x);
        this.y0 = Math.min(one.y, two.y);
        this.y1 = Math.max(one.y, two.y);
        this.z0 = Math.min(one.z, two.z);
        this.z1 = Math.max(one.z, two.z);
        this.center = new V3D((this.x0 + this.x1) * 0.5, (this.y0 + this.y1) * 0.5, (this.z0 + this.z1) * 0.5);
        return this;
    }

    public MiniBB update(V3D one, V3D two, float addition) {
        this.update(one, two);
        this.x0 -= (double)addition;
        this.x1 += (double)addition;
        this.y0 -= (double)addition;
        this.y1 += (double)addition;
        this.z0 -= (double)addition;
        this.z1 += (double)addition;
        return this;
    }
}

