/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block.generated;

import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.block.generated.DBSW_4ROT_TE;
import net.fexcraft.mod.fvtm.block.generated.F2SW_4ROT_TE;
import net.fexcraft.mod.fvtm.block.generated.F3SW_4ROT_TE;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface JunctionTrackingTileEntity {
    public static void updateJunction(EntityPlayer player, TileEntity tile_entity, ItemStack held) {
        if (!(tile_entity instanceof JunctionTrackingTileEntity)) {
            return;
        }
        JunctionTrackingTileEntity tile = (JunctionTrackingTileEntity)tile_entity;
        if (held.func_77942_o() && held.func_77978_p().func_74764_b("fvtm:junction")) {
            QV3D vector = new QV3D(TagCW.wrap((Object)held.func_77978_p()), "fvtm:junction");
            Junction junc = null;
            RailSystem sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)tile_entity.func_145831_w()));
            if (sys != null) {
                junc = sys.getJunction(vector.pos, false);
            }
            if (junc == null) {
                Print.bar((EntityPlayer)player, (String)"&eJunction at cached location in Item not found.");
                return;
            }
            if (!tile.isSignal()) {
                Block block = tile_entity.func_145831_w().func_180495_p(tile_entity.func_174877_v()).func_177230_c();
                boolean wrong = false;
                switch (junc.type) {
                    case DOUBLE: {
                        wrong = !(block instanceof DBSW_4ROT_TE);
                        break;
                    }
                    case FORK_2: {
                        wrong = !(block instanceof F2SW_4ROT_TE);
                        break;
                    }
                    case FORK_3: {
                        wrong = !(block instanceof F3SW_4ROT_TE);
                        break;
                    }
                }
                if (wrong) {
                    Print.chat((ICommandSender)player, (String)"&eInvalid switch type for this junction.");
                    return;
                }
            }
            tile.setJunction(vector);
            held.func_77978_p().func_82580_o("fvtm:junction");
            Print.bar((EntityPlayer)player, (String)("&b" + (tile.isSignal() ? "Signal" : "Switch") + " junction set. &7[" + tile.getJuncPos() + "]"));
        } else if (tile.isSignal()) {
            tile.toggleDirection();
            Print.bar((EntityPlayer)player, (String)("&bSignal entry direction set to &7" + (Object)((Object)tile.getDirection()) + "&b."));
        }
    }

    default public void linkJunction(World world, BlockPos pos, QV3D vec) {
        if (world == null) {
            return;
        }
        RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
        if (system == null) {
            return;
        }
        Junction junc = system.getJunction(vec.pos);
        if (junc != null) {
            junc.addLinkedTileEntity(WrapperHolder.mutPos((Object)pos));
        }
    }

    public QV3D getJuncPos();

    public void setJunction(QV3D var1);

    public Junction getJunction();

    default public EntryDirection getDirection() {
        return EntryDirection.FORWARD;
    }

    default public void toggleDirection() {
    }

    default public boolean isSignal() {
        return false;
    }

    default public void updateSignalState() {
    }

    default public void updateSwitchState() {
    }
}

