/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block.generated;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.mc.api.packet.IPacket;
import net.fexcraft.lib.mc.network.packet.PacketTileEntityUpdate;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.generated.BlockBase;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.block.MB_Access;
import net.fexcraft.mod.fvtm.data.block.MB_Interact;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.block.MultiBlockCache;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.item.MultiBlockItem;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class MultiblockTileEntity
extends BlockTileEntity {
    public List<MB_Interact> triggers;
    protected MultiblockTileEntity reference;
    protected MultiBlockData mdata;
    protected BlockPos core;
    protected boolean iscore;
    private Map<EnumFacing, List<MB_Access.CapabilityContainer>> capabilities;

    public MultiblockTileEntity(BlockBase type) {
        super(type);
    }

    public MultiblockTileEntity() {
    }

    public MultiblockTileEntity setCore(BlockPos pos, ItemStack stack) {
        BlockPos core = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("PlacedPos"));
        if (!pos.equals((Object)core)) {
            this.core = core;
        } else {
            this.iscore = true;
            this.mdata = ((MultiBlockItem)stack.func_77973_b()).getData(TagCW.wrap((Object)stack.func_77978_p()));
        }
        this.func_70296_d();
        return this;
    }

    public BlockPos getCore() {
        return this.iscore ? this.field_174879_c : this.core;
    }

    public boolean isCore() {
        return this.iscore;
    }

    public MultiBlockData getMultiBlockData() {
        return this.iscore ? this.mdata : this.getMultiBlockDataFromCore();
    }

    private MultiBlockData getMultiBlockDataFromCore() {
        if (this.reference != null) {
            return this.reference.getMultiBlockData();
        }
        if (this.core == null) {
            return null;
        }
        MultiblockTileEntity tile = (MultiblockTileEntity)this.field_145850_b.func_175625_s(this.core);
        this.reference = tile == null ? null : tile;
        return this.reference == null ? null : this.reference.getMultiBlockData();
    }

    public void setup() {
        if (this.mdata == null) {
            return;
        }
        ((MultiBlockCache)this.field_145850_b.getCapability(Capabilities.MULTIBLOCKS, null)).registerMultiBlock(this.field_174879_c, EnumFacing.func_82600_a((int)this.func_145832_p()).func_176734_d(), this.mdata);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.data == null || this.mdata == null) {
            return;
        }
        ((MultiBlockCache)this.field_145850_b.getCapability(Capabilities.MULTIBLOCKS, null)).unregisterMultiBlock(this.field_174879_c, EnumFacing.func_82600_a((int)this.func_145832_p()).func_176734_d(), this.mdata);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("MultiBlockCore")) {
            this.core = BlockPos.func_177969_a((long)compound.func_74763_f("MultiBlockCore"));
        }
        if (compound.func_74764_b("MultiBlock")) {
            if (this.mdata != null) {
                this.mdata.read(compound.func_74775_l("MultiBlock"));
            } else {
                this.mdata = FvtmResources.getMultiBlockData(compound.func_74775_l("MultiBlock"));
            }
        }
        if (this.iscore = this.core == null) {
            this.reference = this;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.core != null) {
            compound.func_74772_a("MultiBlockCore", this.core.func_177986_g());
        }
        if (this.mdata != null) {
            compound.func_74782_a("MultiBlock", (NBTBase)this.mdata.write(null).local());
        }
        return compound;
    }

    private void loadCapabilities() {
        MultiBlockData data = this.getMultiBlockData();
        if (data == null) {
            return;
        }
        if (this.reference == null) {
            return;
        }
        this.capabilities = new HashMap<EnumFacing, List<MB_Access.CapabilityContainer>>();
        this.getCapabilities(data, EnumFacing.func_82600_a((int)this.reference.func_145832_p()), this.field_174879_c, this.isCore() ? this.field_174879_c : this.getCore(), this.capabilities);
    }

    public void getCapabilities(MultiBlockData data, EnumFacing facing, BlockPos pos, BlockPos core, Map<EnumFacing, List<MB_Access.CapabilityContainer>> capabilities) {
        pos = core.func_177973_b((Vec3i)pos);
        pos = pos.func_177981_b(-pos.func_177956_o() * 2);
        pos = pos.func_190942_a(MultiblockTileEntity.getRotation(facing, true));
        V3I rpos = new V3I(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        ((MultiBlock)data.getType()).getAccess().forEach(access -> {
            if (access.getPos().equals((Object)rpos)) {
                this.fillCaps((MB_Access)access, data, null, facing, capabilities);
            }
        });
    }

    @Deprecated
    public static Rotation getRotation(EnumFacing facing, boolean counter) {
        switch (facing) {
            case EAST: {
                return counter ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return counter ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public void fillCaps(MB_Access access, MultiBlockData data, EnumFacing facing, EnumFacing rotateby, Map<EnumFacing, List<MB_Access.CapabilityContainer>> capabilities) {
        if (facing == null) {
            if (access.getSide() == null) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    this.fillCaps(access, data, face, rotateby, capabilities);
                }
            } else {
                this.fillCaps(access, data, (EnumFacing)WrapperHolder.getLocalSide((CubeSide)access.getSide()), rotateby, capabilities);
            }
            return;
        }
        if (!capabilities.containsKey(facing = (EnumFacing)MultiBlock.rotate(facing, (Object)rotateby).local())) {
            capabilities.put(facing, new ArrayList());
        }
        InvHandler handler = data.getInventories().get(access.getTarget());
        Capability cap = null;
        if (handler.type.isFluid()) {
            cap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        } else if (handler.type.isItem()) {
            cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        } else if (!handler.type.isVariable()) {
            return;
        }
        capabilities.get(facing).add(new MB_Access.CapabilityContainer(access.getTarget(), cap, handler));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.capabilities == null) {
            this.loadCapabilities();
        }
        if (this.capabilities != null && this.capabilities.containsKey(facing)) {
            for (MB_Access.CapabilityContainer con : this.capabilities.get(facing)) {
                if (con.cap != capability) continue;
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.capabilities == null) {
            this.loadCapabilities();
        }
        if (this.capabilities != null && this.capabilities.containsKey(facing)) {
            for (MB_Access.CapabilityContainer con : this.capabilities.get(facing)) {
                if (con.cap != capability) continue;
                return (T)con.handler.getCapability();
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void processClientPacket(PacketTileEntityUpdate pkt) {
        if (pkt.nbt.func_74764_b("target") && pkt.nbt.func_74779_i("target").equals("script")) {
            return;
        }
        super.processClientPacket(pkt);
    }

    public void processServerPacket(PacketTileEntityUpdate pkt) {
        if (pkt.nbt.func_74764_b("target") && pkt.nbt.func_74779_i("target").equals("script")) {
            return;
        }
        super.processServerPacket((IPacket)pkt);
    }

    public List<MB_Access.CapabilityContainer> getCapabilities(EnumFacing side) {
        if (this.capabilities == null) {
            this.loadCapabilities();
        }
        return this.capabilities.get(side);
    }
}

