/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.HashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.inv.StackWrapper;

public class Fuel
extends Content<Fuel> {
    public HashMap<String, Float> conversion = new HashMap();
    public String primary;
    public String secondary;
    public float quality;

    @Override
    public Fuel parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Material");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.primary = map.getString("PrimaryGroup", "petrol");
        this.secondary = map.getString("SecondaryGroup", "super95");
        this.quality = map.getFloat("Quality", 0.95f);
        if (map.has("Conversion")) {
            for (Map.Entry entry : map.getMap("Conversion").entries()) {
                this.conversion.put((String)entry.getKey(), Float.valueOf(((JsonValue)entry.getValue()).float_value()));
            }
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.FUEL;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    public String getPrimaryGroup() {
        return this.primary;
    }

    public String getSecondaryGroup() {
        return this.secondary;
    }

    public boolean isSourceFluid(String fluid_id) {
        return this.conversion.containsKey(fluid_id);
    }

    public float getConversionRate(String flid) {
        if (!this.conversion.containsKey(flid)) {
            return 1.0f;
        }
        return this.conversion.get(flid).floatValue();
    }

    public static boolean isFuelItem(StackWrapper stack) {
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        return mat != null && mat.isFuelContainer();
    }

    public static Fuel getStoredType(StackWrapper stack) {
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        if (mat == null || !mat.isFuelContainer()) {
            return null;
        }
        if (mat.getFuelType() != null) {
            return mat.getFuelType();
        }
        if (stack.hasTag()) {
            return FvtmRegistry.getFuel(stack.directTag().getString("StoredFuelType"));
        }
        return null;
    }

    public static void setStoredType(StackWrapper stack, Fuel fuel) {
        stack.updateTag(tag -> tag.set("StoredFuelType", fuel.getIDS()));
    }

    public static int getStoredAmount(StackWrapper stack) {
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        if (mat == null || !mat.isFuelContainer() || !stack.hasTag()) {
            return 0;
        }
        return stack.directTag().getInteger("StoredFuelAmount");
    }

    public static String getStoredName(StackWrapper stack) {
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        if (mat == null || !mat.isFuelContainer()) {
            return "Nothing.";
        }
        if (mat.getFuelType() != null) {
            return mat.getFuelType().getName();
        }
        if (stack.hasTag()) {
            return FvtmRegistry.getFuelName(stack.directTag().getString("StoredFuelType"));
        }
        return "none";
    }

    public static void extract(StackWrapper stack, int amount) {
        stack.updateTag(tag -> {
            tag.set("StoredFuelAmount", tag.getInteger("StoredFuelAmount") - amount);
            if (tag.getInteger("StoredFuelAmount") < 0) {
                tag.set("StoredFuelAmount", 0);
            }
        });
    }

    public static void insert(StackWrapper stack, int amount) {
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        stack.updateTag(tag -> {
            tag.set("StoredFuelAmount", tag.getInteger("StoredFuelAmount") + amount);
            if (tag.getInteger("StoredFuelAmount") > mat.getFuelCapacity()) {
                tag.set("StoredFuelAmount", mat.getFuelCapacity());
            }
        });
    }
}

