/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class RailGauge
extends Content<RailGauge>
implements WithItem,
ItemTextureable {
    public static final float DEFWIDTH = 1.875f;
    protected float width;
    protected float height;
    protected float blockwidth;
    protected float blockheight;
    protected List<String> compatible;
    protected IDL rail_texture;
    protected IDL ties_texture;
    protected IDL model_texture;
    protected String modelid;
    protected String ctab;
    protected RailGaugeModel model;
    protected ModelData modeldata;
    protected ArrayList<Preset> presets;
    protected IDL itemtexloc;

    @Override
    public RailGauge parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Material");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.width = map.getFloat("Width", 1.875f);
        this.height = map.getFloat("Height", 0.25f);
        this.blockwidth = map.getFloat("BlockSpace", 2.0f);
        this.blockheight = map.getFloat("BlockHeight", 0.0f);
        String blks = EnvInfo.is112() ? "blocks" : "block";
        this.rail_texture = IDLManager.getIDLNamed((String)map.getString("RailTexture", "minecraft:textures/" + blks + "/iron_block.png"));
        this.ties_texture = IDLManager.getIDLNamed((String)map.getString("TiesTexture", "minecraft:textures/" + blks + "/anvil_base.png"));
        this.model_texture = IDLManager.getIDLNamed((String)map.getString("ModelTexture", "fvtm:textures/" + blks + "/null.png"));
        this.compatible = ContentConfigUtil.getStringList(map, "Compatible");
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        if (map.has("Presets")) {
            this.presets = new ArrayList();
            ((List)map.get((String)"Presets").asArray().value).forEach(val -> {
                try {
                    JsonMap mep = val.asMap();
                    JsonArray path = mep.getArray("path");
                    Preset pre = new Preset();
                    pre.path = new QV3D[path.size()];
                    for (int i = 0; i < pre.path.length; ++i) {
                        JsonArray temp = path.get(i).asArray();
                        double x = temp.get(0).float_value();
                        double y = temp.get(1).float_value();
                        double z = temp.get(2).float_value();
                        pre.path[i] = new QV3D(x, y, z);
                    }
                    pre.name = mep.get("name").string_value().toLowerCase();
                    pre.segmentation = mep.getInteger("segmentation", pre.segmentation);
                    this.presets.add(pre);
                }
                catch (Exception e) {
                    FvtmLogger.log((Object)("Failed to load a RailGauge Preset for '" + this.id.colon() + "'!"));
                    FvtmLogger.log((Object)("JSON: " + JsonHandler.toString((JsonValue)val, (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT)));
                    e.printStackTrace();
                    Static.halt();
                }
            });
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.RAILGAUGE;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public List<String> getCompatible() {
        return this.compatible;
    }

    @Override
    public RailGaugeModel getModel() {
        return this.model;
    }

    @Override
    public void loadModel() {
        this.model = (RailGaugeModel)FvtmResources.getModel(this.modelid, this.modeldata, RailGaugeModel.class);
    }

    public IDL getRailTexture() {
        return this.rail_texture;
    }

    public IDL getTiesTexture() {
        return this.ties_texture;
    }

    public IDL getModelTexture() {
        return this.model_texture;
    }

    public float getBlockWidth() {
        return this.blockwidth;
    }

    public float getBlockHeight() {
        return this.blockheight;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    public ArrayList<Preset> getPresets() {
        return this.presets;
    }

    public static class Preset {
        public QV3D[] path;
        public String name;
        public int segmentation = 4;
    }
}

