/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.StackWrapper;

public class Recipe
extends Content<Recipe> {
    public boolean fcl;
    public String category;
    public StackWrapper output;
    public ArrayList<FclRecipe.Component> fclcomps = new ArrayList();

    @Override
    public Recipe parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Recipe");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.category = map.getString("Category", "recipe." + this.pack.id.colon());
        String type = map.getString("Type", "fcl").toLowerCase();
        this.fcl = type.equals("fcl:crafting");
        this.output = this.parseStack(null, map.getMap("Result"));
        boolean v12 = EnvInfo.is112();
        boolean v20 = EnvInfo.is120();
        for (Map.Entry entry : map.get("Components").asMap().entries()) {
            String ctype;
            JsonMap val = ((JsonValue)entry.getValue()).asMap();
            switch (ctype = val.getString("type", "item")) {
                case "item": {
                    StackWrapper item;
                    if (val.has("1.12") && !v12 || (item = this.parseStack((String)entry.getKey(), val)).empty()) break;
                    this.fclcomps.add(new FclRecipe.Component(item));
                    break;
                }
                case "ore": {
                    if (!v12) break;
                    this.fclcomps.add(new FclRecipe.Component((String)entry.getKey(), val.getInteger("amount", 1)));
                    break;
                }
                case "tag": {
                    if (v12) break;
                    String key = (String)entry.getKey();
                    if (v20 && key.startsWith("c:")) {
                        key = key.replace("c:", "forge:");
                    } else if (!v20 && key.startsWith("forge:")) {
                        key = key.replace("forge:", "c:");
                    }
                    this.fclcomps.add(new FclRecipe.Component(key, val.getInteger("amount", 1)));
                    break;
                }
            }
        }
        return this;
    }

    private StackWrapper parseStack(String key, JsonMap result) {
        StackWrapper stack = FvtmResources.newStack(IDLManager.getIDLCached((String)(key == null ? result.getString("id", "minecraft:stone") : key)));
        stack.count(result.getInteger("amount", 1));
        if (result.has("damage")) {
            stack.damage(result.getInteger("damage", 0));
        }
        return stack;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.RECIPE;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }
}

