/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.MessageSender;

public class AttributeUtil {
    public static void processToggle(VehicleInstance vehicle, TagCW com, Passenger from) {
        boolean bool = com.getBoolean("bool");
        String attrid = com.getString("attr");
        Attribute<?> attr = vehicle.data.getAttribute(attrid);
        if (attr == null) {
            from.send("interact.fvtm.vehicle.attribute.not_found", new Object[]{attrid});
            return;
        }
        if (!attr.editable) {
            from.send("interact.fvtm.vehicle.attribute.not_editable");
            return;
        }
        if (vehicle.getSeatOf(from) == null && !attr.external) {
            from.send("interact.fvtm.vehicle.attribute.not_external");
            return;
        }
        Object oldval = attr.value();
        AttributeUtil.toggleAttr((MessageSender)from, attr, bool, com, false, null);
        Object syncval = attr.value();
        vehicle.sendUpdate("toggle_attr", com);
        vehicle.data.getEventHolder().run(EventType.ATTRIBUTE_UPDATE, vehicle, from, attr);
        if (!attr.sync) {
            return;
        }
        if (!vehicle.type.isRailVehicle()) {
            if (vehicle.front != null) {
                return;
            }
            VehicleInstance trailer = vehicle.rear;
            while (trailer != null) {
                attr = trailer.data.getAttribute(attrid);
                if (attr != null) {
                    com = TagCW.create();
                    AttributeUtil.toggleAttr(FvtmLogger.NONE, attr, bool, com, true, syncval);
                    trailer.sendUpdate("toggle_attr", com);
                }
                trailer = trailer.rear;
            }
        }
    }

    private static void toggleAttr(MessageSender from, Attribute<?> attr, boolean bool, TagCW com, boolean check, Object syncval) {
        if (check && attr.sync) {
            attr.set(syncval);
            return;
        }
        if (attr.valuetype.isTristate()) {
            if (attr.valuetype.isBoolean() || !com.has("reset")) {
                attr.set(bool);
                com.set("bool", attr.asBoolean());
            } else {
                attr.set(null);
                com.set("reset", true);
            }
        } else if (attr.valuetype.isNumber()) {
            attr.set(Float.valueOf(attr.valuetype.isInteger() ? (float)com.getInteger("value") : com.getFloat("value")));
        } else {
            from.send("interact.fvtm.vehicle.attribute.not_supported");
        }
    }

    public static void processToggleClient(VehicleInstance vehicle, TagCW com, Passenger from) {
        boolean bool = com.getBoolean("bool");
        String attrid = com.getString("attr");
        Attribute<?> attr = vehicle.data.getAttribute(attrid);
        if (attr.valuetype.isTristate()) {
            if (attr.valuetype.isBoolean() || !com.has("reset")) {
                attr.set(bool);
            } else {
                attr.set(null);
            }
        } else if (attr.valuetype.isNumber()) {
            attr.set(Float.valueOf(attr.valuetype.isInteger() ? (float)com.getInteger("value") : com.getFloat("value")));
        } else {
            from.send("interact.fvtm.vehicle.attribute.not_supported");
        }
    }
}

