/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.crafting.RecipeRegistry;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTickableTE;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockScript;
import net.fexcraft.mod.fvtm.data.block.MB_Interact;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class CraftBlockScript
implements BlockScript {
    public static LinkedHashMap<String, Recipe> RECIPE_REGISTRY = new LinkedHashMap();
    public static LinkedHashMap<String, ArrayList<Recipe>> SORTED_REGISTRY = new LinkedHashMap();
    private static LinkedHashMap<String, Ingredient> ITEMGROUPS = new LinkedHashMap();
    protected String blockid;
    protected Recipe selected;
    protected Recipe autosel;
    protected int cooldown;
    protected int processed;

    @Override
    public void read(MultiBlockData data, TagCW tag) {
        this.selected = tag.has("selected") ? RECIPE_REGISTRY.get(tag.getString("selected")) : null;
        this.autosel = tag.has("auto_selected") ? RECIPE_REGISTRY.get(tag.getString("auto_selected")) : null;
        this.cooldown = tag.has("cooldown") ? tag.getInteger("cooldown") : 0;
        this.processed = tag.has("processed") ? tag.getInteger("processed") : 0;
    }

    @Override
    public TagCW write(MultiBlockData data, TagCW compound) {
        if (this.selected != null) {
            compound.set("selected", this.selected.id);
        }
        if (this.autosel != null) {
            compound.set("auto_selected", this.autosel.id);
        }
        compound.set("cooldown", this.cooldown);
        compound.set("processed", this.processed);
        return compound;
    }

    @Override
    public void onUpdate(MultiblockTickableTE tile) {
        if (tile.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.ready(tile)) {
            this.prepare(tile);
            return;
        }
        this.running(tile);
        if (this.cooldown > 0) {
            this.cooldown -= this.cooldown_speed();
            return;
        }
        if (this.selected != null) {
            this.tryCrafting(tile, this.selected);
            return;
        }
        if (this.autoRecipeChooser() && (this.autosel == null || !this.autosel.canCraft(this, tile.getMultiBlockData(), false))) {
            this.autosel = null;
            this.searchForRecipe(tile.getMultiBlockData());
        }
        if (this.autosel != null) {
            this.tryCrafting(tile, this.autosel);
            return;
        }
        this.addCooldown();
    }

    protected void tryCrafting(MultiblockTickableTE tile, Recipe recipe) {
        if (!recipe.canCraft(this, tile.getMultiBlockData(), true)) {
            return;
        }
        if (!this.instant()) {
            int question;
            int n = question = recipe.crafttime == 0 ? this.process_time() : recipe.crafttime;
            if (this.processed < question) {
                this.processed += this.process_speed();
                return;
            }
        }
        recipe.craft(this, tile.getMultiBlockData());
        this.processed = 0;
    }

    protected void searchForRecipe(MultiBlockData multidata) {
        ArrayList<Recipe> recipes;
        if (this.blockid == null) {
            this.blockid = ((MultiBlock)multidata.getType()).getIDS();
        }
        if ((recipes = SORTED_REGISTRY.get(this.blockid)) == null || recipes.isEmpty()) {
            return;
        }
        for (Recipe recipe : recipes) {
            if (!recipe.canCraft(this, multidata, false)) continue;
            this.autosel = recipe;
        }
    }

    protected void addCooldown() {
        this.cooldown += this.cooldown();
    }

    protected boolean isCoolingDown() {
        return this.cooldown > 0;
    }

    @Override
    public boolean onTrigger(MultiBlockData data, MB_Interact trigger, EntityPlayer player, EnumHand hand, BlockPos core, BlockPos pos, EnumFacing side, V3D hit) {
        switch (trigger.getTarget()) {
            case "open_gui": {
                player.openGui((Object)FVTM.getInstance(), 952, player.field_70170_p, core.func_177958_n(), core.func_177956_o(), core.func_177952_p());
                return true;
            }
            case "select_recipe": {
                player.openGui((Object)FVTM.getInstance(), 953, player.field_70170_p, core.func_177958_n(), core.func_177956_o(), core.func_177952_p());
                return true;
            }
        }
        return false;
    }

    public abstract List<Object[]> getUIElements(BlockData var1, MultiBlockData var2);

    public String getCurrentRecipe() {
        return this.selected == null ? (this.autosel == null ? "none" : this.autosel.id) : this.selected.id;
    }

    public abstract boolean autoRecipeChooser();

    public abstract int cooldown();

    public abstract boolean instant();

    public abstract boolean ready(MultiblockTickableTE var1);

    public abstract void prepare(MultiblockTickableTE var1);

    public abstract void running(MultiblockTickableTE var1);

    public abstract int process_speed();

    public abstract int process_time();

    public abstract int cooldown_speed();

    public abstract boolean update_client();

    public abstract boolean consume(MultiBlockData var1, String var2, int var3, boolean var4);

    public int getCooldown() {
        return this.cooldown;
    }

    public int getProcessed() {
        return this.processed;
    }

    public int getProcessTime() {
        if (this.selected == null && this.autosel == null) {
            return 0;
        }
        Recipe recipe = this.selected == null ? this.autosel : this.selected;
        return recipe.crafttime == 0 ? this.process_time() : recipe.crafttime;
    }

    public void setProcessed(int value) {
        this.processed = value;
    }

    public void setCooldown(int value) {
        this.cooldown = value;
    }

    public static String getInvId(MultiBlockData data, InvType type, String invname, String fix) {
        if (data.getInventories().containsKey(invname)) {
            return invname;
        }
        ArrayList<String> coll = new ArrayList<String>();
        for (Map.Entry<String, InvHandler> entry : data.getInventories().entrySet()) {
            if (entry.getKey().equals(fix)) {
                return entry.getKey();
            }
            if (entry.getValue().type != type) continue;
            coll.add(entry.getKey());
        }
        return coll.size() != 1 ? null : (String)coll.get(0);
    }

    public static void parseRecipes(Addon addon, String filename, InputStream stream) {
        block13: {
            try {
                Scanner scanner = new Scanner(stream);
                String line = null;
                boolean override = false;
                RecipeParser parser = null;
                while (scanner.hasNextLine()) {
                    line = scanner.nextLine().trim();
                    if (line.equals("#override")) {
                        boolean bl = override = !override;
                    }
                    if (line.startsWith("#")) {
                        String[] split;
                        if (parser != null) {
                            parser.finish(addon);
                        }
                        if ((split = line.substring(1).split("@")).length < 2) continue;
                        String blkid = split[0].trim();
                        String rcpid = split[1].trim();
                        if (blkid.equals("fcl:bpt") || blkid.equals("fcl:blueprinttable")) {
                            parser = new FCLBPTParser().start(blkid, rcpid);
                        } else if (blkid.equals("itemgroup")) {
                            if (!override && ITEMGROUPS.containsKey(rcpid)) {
                                Print.log((Object)String.format("Duplicate ItemGroup ID detected from addon '%s' with id '%s' from file '%s'!", addon.getIDS(), rcpid, filename));
                                continue;
                            }
                            parser = new ItemGroupParser().start(blkid, rcpid);
                        } else {
                            if (!override && RECIPE_REGISTRY.containsKey(rcpid)) {
                                Print.log((Object)String.format("Duplicate Recipe ID detected from addon '%s' with id '%s' from file '%s'!", addon.getIDS(), rcpid, filename));
                                continue;
                            }
                            parser = new RecipeParserImpl().start(blkid, rcpid);
                        }
                    }
                    if (line.startsWith("//") || parser == null) continue;
                    parser.read(line);
                }
                if (parser != null) {
                    parser.finish(addon);
                }
                scanner.close();
            }
            catch (Exception e) {
                if (!Static.dev()) break block13;
                e.printStackTrace();
                Static.stop();
            }
        }
    }

    private static final ItemStack parseStack(String data) {
        int amount = 0;
        String[] arr = data.split(" ");
        if (arr[0].contains("*")) {
            String[] am = arr[0].split("\\*");
            arr[0] = am[0];
            amount = Integer.parseInt(am[1]);
        }
        if (amount < 1) {
            amount = 1;
        }
        return CraftBlockScript.parseStack(arr, amount);
    }

    private static final ItemStack parseStack(String[] args, int count) {
        ItemStack stack = null;
        if (args.length == 1) {
            stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(args[0])), count);
        } else {
            stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(args[0])), count);
            boolean tag = args[1].startsWith("{");
            if (!tag) {
                stack.func_77964_b(Integer.parseInt(args[1]));
            }
            if (tag || args.length > 2) {
                try {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)args[tag ? 1 : 2]));
                }
                catch (NBTException e) {
                    Print.log((Object)"Error while parsing tag for recipe ingredient.");
                    e.printStackTrace();
                }
            }
        }
        if (stack.func_190926_b()) {
            Print.log((Object)("Item for recipe not found: " + args[0]));
        }
        return stack;
    }

    public void resetRecipe() {
        if (this.selected == null && this.autosel == null) {
            return;
        }
        this.autosel = null;
        this.selected = null;
        this.processed = 0;
        this.addCooldown();
    }

    public void setSelectedRecipe(MultiblockTileEntity tile, String string) {
        if (this.blockid == null) {
            this.blockid = ((MultiBlock)tile.getMultiBlockData().getType()).getIDS();
        }
        this.addCooldown();
        for (Recipe recipe : SORTED_REGISTRY.get(this.blockid)) {
            if (!recipe.id().equals(string)) continue;
            this.selected = recipe;
            return;
        }
        this.selected = null;
    }

    public Recipe getSelected() {
        return this.selected;
    }

    protected static class RecipeParserImpl
    implements RecipeParser {
        private Recipe recipe;
        private boolean input;
        private InputWrapper in;
        private OutputWrapper out;
        private String inv;

        protected RecipeParserImpl() {
        }

        @Override
        public RecipeParser start(String blkid, String rcpid) {
            this.recipe = new Recipe(blkid, rcpid);
            return this;
        }

        @Override
        public void read(String line) {
            if (line.startsWith("@in")) {
                this.input = true;
                this.inv = line.substring(3).trim();
                if (this.inv.length() == 0) {
                    this.inv = null;
                }
                this.in = null;
                return;
            }
            if (line.startsWith("@out")) {
                this.input = false;
                this.inv = line.substring(4).trim();
                if (this.inv.length() == 0) {
                    this.inv = null;
                }
                this.out = null;
                return;
            }
            if (line.equals("overflow") && this.out != null) {
                this.out.overflow = true;
                return;
            }
            if (line.startsWith("time")) {
                this.recipe.crafttime = Integer.parseInt(line.substring(5));
                return;
            }
            if (line.startsWith("item")) {
                if (this.input) {
                    this.in = new InputWrapper(this.inv, line.substring(4).trim(), InputWrapper.InputType.ITEM);
                    this.recipe.input.add(this.in);
                } else {
                    this.out = new OutputWrapper(this.inv, line.substring(4).trim(), true);
                    this.recipe.output.add(this.out);
                }
                return;
            }
            if (line.startsWith("+item") && this.in != null && this.in.getInputType() == InputWrapper.InputType.ITEM) {
                this.in.addIngredientItem(line.substring(5).trim());
                return;
            }
            if (line.startsWith("group")) {
                String[] arr = line.substring(5).split("\\*");
                String id = arr[0].trim();
                if (!ITEMGROUPS.containsKey(id)) {
                    return;
                }
                InputWrapper inw = new InputWrapper(this.inv);
                inw.ingredient = (Ingredient)ITEMGROUPS.get(id);
                inw.amount = arr.length > 1 ? Integer.parseInt(arr[1].trim()) : 1;
                this.recipe.input.add(inw);
                return;
            }
            if (line.startsWith("fluid")) {
                if (this.input) {
                    this.recipe.input.add(new InputWrapper(this.inv, line.substring(5).trim(), InputWrapper.InputType.FLUID));
                } else {
                    this.out = new OutputWrapper(this.inv, line.substring(5).trim(), false);
                    this.recipe.output.add(this.out);
                }
                return;
            }
            if (line.startsWith("oredict") && this.input) {
                this.recipe.input.add(new InputWrapper(this.inv, line.substring(7).trim(), InputWrapper.InputType.OREDICT));
                return;
            }
            if (line.startsWith("consume")) {
                String[] str = line.split(" ");
                this.recipe.consume.put(str[1], Integer.parseInt(str[2]));
                return;
            }
        }

        @Override
        public void finish(Addon addon) {
            if (this.recipe.input.isEmpty() && this.recipe.consume.isEmpty()) {
                Print.debug((Object)("Recipe '" + this.recipe.id + "' for '" + this.recipe.targetmachine + "' from '" + addon.getIDS() + "' has no input/consumption, skipping!"));
                return;
            }
            RECIPE_REGISTRY.put(this.recipe.id, this.recipe);
            if (!SORTED_REGISTRY.containsKey(this.recipe.targetmachine)) {
                SORTED_REGISTRY.put(this.recipe.targetmachine, new ArrayList());
            }
            SORTED_REGISTRY.get(this.recipe.targetmachine).add(this.recipe);
            Print.debug((Object)("Added Recipe '" + this.recipe.id + "' to '" + this.recipe.targetmachine + "' from '" + addon.getIDS() + "'!"));
        }
    }

    protected static class ItemGroupParser
    implements RecipeParser {
        private ArrayList<ItemStack> stacks = new ArrayList();
        private String id;

        protected ItemGroupParser() {
        }

        @Override
        public RecipeParser start(String unused, String rcpid) {
            this.id = rcpid;
            return this;
        }

        @Override
        public void read(String line) {
            if (line.startsWith("item")) {
                this.stacks.add(CraftBlockScript.parseStack(line.substring(4).trim()));
            }
        }

        @Override
        public void finish(Addon addon) {
            ITEMGROUPS.put(this.id, Ingredient.func_193369_a((ItemStack[])this.stacks.toArray(new ItemStack[0])));
        }
    }

    protected static class FCLBPTParser
    implements RecipeParser {
        private String category;
        private boolean in;
        private ArrayList<ItemStack> stacks = new ArrayList();
        private ItemStack out;

        protected FCLBPTParser() {
        }

        @Override
        public RecipeParser start(String id, String rcpid) {
            this.category = rcpid;
            return this;
        }

        @Override
        public void read(String line) {
            if (line.startsWith("@in")) {
                this.in = true;
                return;
            }
            if (line.startsWith("@out")) {
                this.in = false;
                return;
            }
            if (line.startsWith("item")) {
                if (this.in) {
                    this.stacks.add(CraftBlockScript.parseStack(line.substring(4).trim()));
                } else {
                    this.out = CraftBlockScript.parseStack(line.substring(4).trim());
                }
                return;
            }
        }

        @Override
        public void finish(Addon addon) {
            RecipeRegistry.addBluePrintRecipe((String)(this.category.length() == 0 ? addon.getID().path() + ".recipes" : this.category), (ItemStack)this.out, (ItemStack[])this.stacks.toArray(new ItemStack[0]));
        }
    }

    protected static interface RecipeParser {
        public static final String KEY_IN = "@in";
        public static final String KEY_OUT = "@out";

        public RecipeParser start(String var1, String var2);

        public void read(String var1);

        public void finish(Addon var1);
    }

    public static class OutputWrapper {
        public ItemStack stack;
        public FluidStack fluid;
        public boolean overflow;
        public String inventory;

        public OutputWrapper(String inv, String data, boolean item) {
            this.inventory = inv;
            int amount = 0;
            String[] arr = data.split(" ");
            if (arr[0].contains("*")) {
                String[] am = arr[0].split("\\*");
                arr[0] = am[0];
                amount = Integer.parseInt(am[1]);
            }
            if (amount < 1) {
                amount = 1;
            }
            if (item) {
                this.stack = CraftBlockScript.parseStack(arr, amount);
            } else {
                this.fluid = new FluidStack(FluidRegistry.getFluid((String)arr[0]), amount);
            }
        }

        public InvType getInventoryType() {
            return this.fluid != null ? InvType.FLUID : InvType.ITEM;
        }

        public int amount() {
            return this.fluid == null ? this.stack.func_190916_E() : this.fluid.amount;
        }
    }

    public static class InputWrapper {
        protected static HashMap<String, NonNullList<ItemStack>> oredict = new HashMap();
        public Ingredient ingredient;
        public FluidStack fluid;
        public String inventory;
        public String oreid;
        public int amount;

        public InputWrapper(String inv) {
            this.inventory = inv;
        }

        public InputWrapper(String inv, String data, InputType type) {
            this.inventory = inv;
            String[] arr = data.split(" ");
            if (arr[0].contains("*")) {
                String[] am = arr[0].split("\\*");
                arr[0] = am[0];
                this.amount = Integer.parseInt(am[1]);
            }
            if (this.amount < 1) {
                this.amount = 1;
            }
            if (type == InputType.ITEM) {
                this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CraftBlockScript.parseStack(arr, this.amount)});
            } else if (type == InputType.FLUID) {
                this.fluid = new FluidStack(FluidRegistry.getFluid((String)arr[0]), this.amount);
            } else {
                if (!oredict.containsKey(arr[0])) {
                    oredict.put(arr[0], (NonNullList<ItemStack>)OreDictionary.getOres((String)arr[0], (boolean)true));
                }
                if (oredict.get(arr[0]).size() < 1) {
                    Print.log((Object)("OreDict for '" + arr[0] + "' is empty!"));
                } else {
                    this.oreid = arr[0];
                }
            }
        }

        protected void addIngredientItem(String data) {
            this.ingredient = this.toIngrArray(CraftBlockScript.parseStack(data.split(" "), this.amount));
        }

        private Ingredient toIngrArray(ItemStack stack) {
            if (this.ingredient == null) {
                return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            }
            ItemStack[] stacks = new ItemStack[this.ingredient.func_193365_a().length + 1];
            for (int i = 0; i < stacks.length - 1; ++i) {
                stacks[i] = this.ingredient.func_193365_a()[i];
            }
            stacks[stacks.length - 1] = stack;
            return Ingredient.func_193369_a((ItemStack[])stacks);
        }

        public boolean valid(ItemStack stack) {
            if (this.ingredient != null) {
                return this.ingredient.apply(stack);
            }
            if (this.oreid != null) {
                return OreDictionary.containsMatch((boolean)false, oredict.get(this.oreid), (ItemStack[])new ItemStack[]{stack});
            }
            return false;
        }

        public InputType getInputType() {
            return this.fluid != null ? InputType.FLUID : (this.ingredient == null ? InputType.OREDICT : InputType.ITEM);
        }

        public static enum InputType {
            ITEM,
            FLUID,
            OREDICT;


            public InvType toInventory() {
                return this == FLUID ? InvType.FLUID : InvType.ITEM;
            }
        }
    }

    public static class Recipe {
        protected ArrayList<InputWrapper> input = new ArrayList();
        protected ArrayList<OutputWrapper> output = new ArrayList();
        protected HashMap<String, Integer> consume = new HashMap();
        protected String targetmachine;
        protected String id;
        protected int crafttime;

        public Recipe(String blkid, String rcpid) {
            this.targetmachine = blkid;
            this.id = rcpid;
        }

        public void craft(CraftBlockScript script, MultiBlockData data) {
            IItemHandler handler;
            String inventory;
            Enum local;
            for (Map.Entry<String, Integer> entry : this.consume.entrySet()) {
                script.consume(data, entry.getKey(), entry.getValue(), false);
            }
            block1: for (InputWrapper inputWrapper : this.input) {
                local = inputWrapper.getInputType();
                inventory = CraftBlockScript.getInvId(data, ((InputWrapper.InputType)local).toInventory(), inputWrapper.inventory, "input");
                if (((InputWrapper.InputType)local).toInventory().isFluid()) {
                    ((FluidTank)data.getInventory(inventory).getTank()).drain(inputWrapper.fluid, true);
                    continue;
                }
                handler = (IItemHandler)data.getInventory(inventory).getStackHandler();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (!inputWrapper.valid(stack) || stack.func_190916_E() < inputWrapper.amount) continue;
                    handler.extractItem(i, inputWrapper.amount, false);
                    continue block1;
                }
            }
            for (OutputWrapper outputWrapper : this.output) {
                local = outputWrapper.getInventoryType();
                inventory = CraftBlockScript.getInvId(data, (InvType)local, outputWrapper.inventory, "output");
                if (((InvType)local).isFluid()) {
                    ((FluidTank)data.getInventory(inventory).getTank()).fill(outputWrapper.fluid, true);
                    continue;
                }
                handler = (IItemHandler)data.getInventory(inventory).getStackHandler();
                ItemStack left = outputWrapper.stack.func_77946_l();
                for (int i = 0; i < handler.getSlots() && !(left = handler.insertItem(i, left, false)).func_190926_b(); ++i) {
                }
            }
            script.addCooldown();
        }

        public boolean canCraft(CraftBlockScript script, MultiBlockData data, boolean addcooldown) {
            boolean fits = true;
            ArrayList<Integer> ints = new ArrayList<Integer>();
            for (OutputWrapper entry : this.output) {
                InvType invType = entry.getInventoryType();
                String invid = CraftBlockScript.getInvId(data, invType, entry.inventory, "output");
                if (invid == null) {
                    fits = false;
                    break;
                }
                if (data.getInventories().get((Object)invid).type != invType) {
                    fits = false;
                    break;
                }
                if (entry.overflow) continue;
                if (invType.isFluid()) {
                    if (((FluidTank)data.getInventory(invid).getTank()).fill(entry.fluid, false) >= entry.fluid.amount) continue;
                    fits = false;
                    break;
                }
                boolean found = false;
                IItemHandler handler = (IItemHandler)data.getInventory(invid).getStackHandler();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (ints.contains(i) || !handler.insertItem(i, entry.stack, true).func_190926_b()) continue;
                    ints.add(i);
                    found = true;
                    break;
                }
                if (found) continue;
                fits = false;
                break;
            }
            if (!fits) {
                if (addcooldown) {
                    script.addCooldown();
                }
                return false;
            }
            boolean passed = true;
            ints.clear();
            for (InputWrapper inputWrapper : this.input) {
                InputWrapper.InputType local = inputWrapper.getInputType();
                String invid = CraftBlockScript.getInvId(data, local.toInventory(), inputWrapper.inventory, "input");
                if (data.getInventories().get((Object)invid).type != local.toInventory()) {
                    passed = false;
                    break;
                }
                if (local.toInventory().isFluid()) {
                    FluidStack drained = ((FluidTank)data.getInventory(invid).getTank()).drain(inputWrapper.fluid, false);
                    if (drained != null && drained.amount >= inputWrapper.fluid.amount) continue;
                    passed = false;
                    break;
                }
                boolean found = false;
                IItemHandler handler = (IItemHandler)data.getInventory(invid).getStackHandler();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack;
                    if (ints.contains(i) || !inputWrapper.valid(stack = handler.getStackInSlot(i)) || stack.func_190916_E() < inputWrapper.amount) continue;
                    ints.add(i);
                    found = true;
                    break;
                }
                if (found) continue;
                passed = false;
                break;
            }
            if (!passed) {
                if (addcooldown) {
                    script.addCooldown();
                }
                return false;
            }
            for (Map.Entry entry : this.consume.entrySet()) {
                if (script.consume(data, (String)entry.getKey(), (Integer)entry.getValue(), true)) continue;
                return false;
            }
            return true;
        }

        public String id() {
            return this.id;
        }

        public List<InputWrapper> getInputs() {
            return this.input;
        }

        public List<OutputWrapper> getOutput() {
            return this.output;
        }

        public Map<String, Integer> getConsume() {
            return this.consume;
        }
    }
}

