/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.container;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.container.ContainerType;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.inv.InvHandlerInit;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class Container
extends Content<Container>
implements Textureable.TextureHolder,
Colorable.ColorHolder,
WithItem,
ItemTextureable {
    protected TreeMap<String, RGB> channels = new TreeMap();
    protected List<IDL> textures;
    protected Model model;
    protected ModelData modeldata;
    protected IDL keytype;
    protected InvHandler invtype;
    protected ContainerType type;
    protected String modelid;
    protected String ctab;
    protected IDL itemtexloc;
    protected boolean no3ditem;

    @Override
    public Container parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Material");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.type = ContainerType.valueOf(map.getString("ContainerType", "MEDIUM").toUpperCase());
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("ColorChannels")) {
            for (Map.Entry entry : map.get("ColorChannels").asMap().entries()) {
                this.channels.put((String)entry.getKey(), new RGB(((JsonValue)entry.getValue()).string_value()));
            }
        }
        if (this.channels.isEmpty()) {
            this.channels.put("primary", RGB.WHITE.copy());
            this.channels.put("secondary", RGB.WHITE.copy());
        }
        this.keytype = map.has("KeyType") ? IDLManager.getIDLCached((String)map.getString("KeyType", null)) : null;
        this.invtype = new InvHandlerInit(InvType.parse(map.getString("InventoryType", "item")));
        this.invtype.setCapacity(map.getInteger("InventorySize", this.invtype.type.isItem() ? 8 : 16000));
        if (this.invtype.type.isFluid() && map.has("FluidType")) {
            this.invtype.setArg(map.get("FluidType").string_value());
        }
        if (this.invtype.type.isItem() && map.has("ContentFilter")) {
            this.invtype.setArg(map.get("ContentFilter").string_value());
        }
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.CONTAINER;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    @Override
    public Class<?> getDataClass() {
        return ContainerData.class;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, DefaultModel.class);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public ContainerType getContainerType() {
        return this.type;
    }

    public InvType getInventoryType() {
        return this.invtype.type;
    }

    public int getCapacity() {
        return this.invtype.capacity();
    }

    public String getFluidType() {
        return this.invtype.getFluid();
    }

    @Override
    public RGB getDefaultColorChannel(String channel) {
        return this.channels.get(channel);
    }

    public TreeMap<String, RGB> getDefaultColorChannels() {
        return this.channels;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    public IDL getKeyType() {
        return this.keytype;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public boolean noCustomItemModel() {
        return this.no3ditem;
    }
}

