/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.container;

import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.container.ContainerType;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleEntity;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.util.AnotherUtil;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ContainerSlot {
    private ContainerData[] containers;
    public ContainerType onlytype;
    public String rotpoint;
    public V3D position;
    public float rotation;
    public byte length;
    public String id;
    private float[] renderoffset;

    public ContainerSlot() {
    }

    public ContainerSlot(String id, byte length, V3D pos, float rotation, @Nullable ContainerType lock, String rotpoint) {
        this.length = length;
        this.containers = new ContainerData[this.length];
        this.onlytype = lock;
        this.id = id;
        this.position = pos;
        this.rotation = rotation;
        this.rotpoint = rotpoint;
    }

    public NBTTagCompound write(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (this.onlytype != null) {
            compound.func_74778_a("Type", this.onlytype.name());
        }
        compound.func_74774_a("Length", this.length);
        compound.func_74778_a("Name", this.id);
        compound.func_74780_a("PositionX", this.position.x);
        compound.func_74780_a("PositionY", this.position.y);
        compound.func_74780_a("PositionZ", this.position.z);
        compound.func_74776_a("RotationY", this.rotation);
        if (this.rotpoint != null) {
            compound.func_74778_a("SwivelPoint", this.rotpoint);
        }
        for (int i = 0; i < this.containers.length; i = (int)((byte)(i + 1))) {
            if (this.containers[i] == null) continue;
            compound.func_74782_a("Slot" + i, (NBTBase)this.containers[i].write(null).local());
        }
        return compound;
    }

    public ContainerSlot read(NBTTagCompound compound) {
        if (!compound.func_74764_b("Length")) {
            try {
                throw new Exception("Container slot could not be loaded, compound is missing length data.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.id = compound.func_74779_i("Name");
        this.onlytype = null;
        if (compound.func_74764_b("Type")) {
            this.onlytype = ContainerType.valueOf(compound.func_74779_i("Type"));
        }
        this.position = new V3D(compound.func_74769_h("PositionX"), compound.func_74769_h("PositionY"), compound.func_74769_h("PositionZ"));
        this.rotation = compound.func_74760_g("RotationY");
        this.rotpoint = compound.func_74764_b("SwivelPoint") ? compound.func_74779_i("SwivelPoint") : null;
        this.length = compound.func_74771_c("Length");
        this.containers = new ContainerData[this.length];
        for (int i = 0; i < this.containers.length; i = (int)((byte)(i + 1))) {
            if (!compound.func_74764_b("Slot" + i)) continue;
            this.containers[i] = FvtmResources.getContainerData(compound.func_74775_l("Slot" + i));
        }
        this.renderoffset = null;
        return this;
    }

    public void clear() {
        this.containers = new ContainerData[this.length];
    }

    public String toString() {
        return "ContainerSlot[" + this.id + ", " + this.length + ", " + this.rotation + "];";
    }

    public boolean[] getFillStateArray() {
        boolean[] bools = new boolean[this.length];
        for (int i = 0; i < this.containers.length; ++i) {
            if (this.containers[i] == null) continue;
            int l = this.containers[i].getContainerType().length();
            if (l > 1) {
                for (int j = 0; j < l && j + i <= bools.length; ++j) {
                    bools[j + i] = true;
                }
                continue;
            }
            bools[i] = true;
        }
        return bools;
    }

    public ContainerData[] getContainers() {
        return this.containers;
    }

    public void setContainer(int index, ContainerData con) {
        this.containers[index] = con;
        this.renderoffset = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(Entity entity, double y, double p, double r) {
        if (this.renderoffset == null) {
            this.loadRenderOffset();
        }
        GL11.glPushMatrix();
        if (entity instanceof VehicleEntity) {
            y += 180.0;
        }
        GL11.glRotated((double)y, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)p, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)r, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)this.position.x, (double)this.position.y, (double)this.position.z);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.rotpoint != null && entity != null) {
            VehicleEntity ent = (VehicleEntity)entity;
            PartData data = ent.getVehicleData().getPart(this.id);
            AnotherUtil.translateAndRotatePartOnSwivelPoint(ent.getVehicleData(), data, Minecraft.func_71410_x().func_184121_ak());
        }
        for (int i = 0; i < this.containers.length; ++i) {
            if (this.containers[i] == null) continue;
            if (this.renderoffset[i] != 0.0f) {
                GL11.glTranslatef((float)this.renderoffset[i], (float)0.0f, (float)0.0f);
            }
            TexUtil.bindTexture(this.containers[i].getTexture().getTexture());
            ((Container)this.containers[i].getType()).getModel().render(DefaultModel.RENDERDATA.set(this.containers[i], null).rc((RenderCache)entity.getCapability(Capabilities.RENDERCACHE, null)));
            if (this.renderoffset[i] == 0.0f) continue;
            GL11.glTranslatef((float)(-this.renderoffset[i]), (float)0.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDebug(Entity entity, double y, double p, double r, ContainerType type) {
        if (type.length() > this.length) {
            return;
        }
        GL11.glPushMatrix();
        if (entity instanceof VehicleEntity) {
            y += 180.0;
        }
        GL11.glRotated((double)y, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)p, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)r, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)this.position.x, (double)this.position.y, (double)this.position.z);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.rotpoint != null && entity != null) {
            VehicleEntity ent = (VehicleEntity)entity;
            PartData data = ent.getVehicleData().getPart(this.id);
            AnotherUtil.translateAndRotatePartOnSwivelPoint(ent.getVehicleData(), data, Minecraft.func_71410_x().func_184121_ak());
        }
        boolean bool = false;
        for (int i = 0; i < this.length; i += type.length()) {
            float off = (float)i + (float)type.length() / 2.0f - (float)this.length / 2.0f;
            GL11.glTranslatef((float)off, (float)(bool ? 0.0625f : 0.0f), (float)0.0f);
            RGB.glColorReset();
            DebugModels.CONTAINER[type.ordinal()].render();
            GL11.glTranslatef((float)(-off), (float)(bool ? -0.0625f : 0.0f), (float)0.0f);
            bool = !bool;
        }
        RGB.glColorReset();
        GL11.glPopMatrix();
    }

    private void loadRenderOffset() {
        this.renderoffset = new float[this.length];
        for (int i = 0; i < this.containers.length; ++i) {
            if (this.containers[i] == null) continue;
            this.renderoffset[i] = (float)i + (float)this.containers[i].getContainerType().length() / 2.0f - (float)this.length / 2.0f;
        }
    }

    public int reSort() {
        int index = 0;
        ContainerData[] newdat = new ContainerData[this.length];
        for (ContainerData data : this.getContainers()) {
            if (data == null) continue;
            newdat[index] = data;
            index += data.getContainerType().length();
        }
        for (int i = 0; i < newdat.length; ++i) {
            this.setContainer(i, newdat[i]);
        }
        return index;
    }
}

