/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import java.util.ArrayList;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.inv.StackEntry;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.EntityW;

public class FvtmInvStacks
extends FvtmInv {
    protected ArrayList<StackEntry> stacks = new ArrayList();
    public int capacity;

    public FvtmInvStacks() {
        super(InvType.STACK);
    }

    public FvtmInvStacks init(JsonMap map) {
        this.init0(map);
        this.capacity = map.getInteger("capacity", 27);
        return this;
    }

    @Override
    public TagCW save(TagCW compound, String ctag) {
        TagLW list = TagLW.create();
        for (StackEntry entry : this.stacks) {
            TagCW com = TagCW.create();
            entry.stack.save(com);
            com.set("fvtm:stack_amount", entry.amount);
            list.add(com);
        }
        if (list.size() > 0) {
            compound.set(ctag == null ? "Items" : ctag, list);
        }
        return compound;
    }

    @Override
    public void load(TagCW compound, String ctag) {
        this.stacks.clear();
        TagLW list = compound.getList(ctag == null ? "Items" : ctag);
        if (list.empty()) {
            return;
        }
        for (TagCW com : list) {
            this.stacks.add(new StackEntry(com));
        }
    }

    @Override
    public void clearAt(EntityW entity) {
        for (StackEntry entry : this.stacks) {
            int am = entry.amount;
            while (am - entry.stack.maxsize() > 0) {
                entity.drop(entry.stack, 0.5f);
                am -= entry.stack.maxsize();
            }
        }
        this.stacks.clear();
    }

    public FvtmInvStacks copy() {
        FvtmInvStacks inv = new FvtmInvStacks();
        this.copy(inv);
        inv.capacity = this.capacity;
        return inv;
    }
}

