/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import net.fexcraft.mod.fvtm.data.inv.InvHandlerItem;
import net.fexcraft.mod.fvtm.data.inv.StackEntry;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.item.ContainerItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class ItemStackHandler
implements IItemHandler {
    protected InvHandlerItem handler;
    protected int min;

    public ItemStackHandler(InvHandlerItem invhandler, int min) {
        this.handler = invhandler;
        this.min = min;
    }

    private boolean isValid(ItemStack stack) {
        return this.handler.filter == null ? true : this.handler.filter.isValid(stack);
    }

    public static boolean isContainerPart(ItemStack stack) {
        PartData data;
        return stack.func_77973_b() instanceof PartItem && ((data = (PartData)((PartItem)stack.func_77973_b()).getDataFromTag(stack.func_77978_p())).hasFunction("fvtm:inventory") || data.hasFunction("fvtm:container"));
    }

    public int getSlots() {
        return this.handler.stacks.size() < this.min ? this.min : this.handler.stacks.size();
    }

    public ItemStack getStackInSlot(int idx) {
        if (idx < 0 || idx >= this.handler.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        StackEntry entry = this.handler.stacks.get(idx);
        ItemStack stack = (ItemStack)entry.stack.copy().local();
        stack.func_190920_e(entry.overmax() ? entry.amount : entry.max());
        return stack;
    }

    public ItemStack insertItem(int unused, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b() instanceof VehicleItem || stack.func_77973_b() instanceof ContainerItem || ItemStackHandler.isContainerPart(stack) || !this.isValid(stack)) {
            return stack;
        }
        StackEntry entry = this.handler.getEntryFor(UniStack.getStack((Object)stack));
        if (entry == null) {
            if (this.handler.full()) {
                return stack;
            }
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            entry = new StackEntry(TagCW.wrap((Object)stack.func_77955_b(new NBTTagCompound())));
            entry.amount = stack.func_190916_E();
            entry.stack.count(1);
            this.handler.stacks.add(entry);
            return ItemStack.field_190927_a;
        }
        int tfs = entry.tillfullstack();
        if (tfs >= stack.func_190916_E()) {
            if (!simulate) {
                entry.amount += stack.func_190916_E();
            }
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            entry.amount += tfs;
        }
        if (tfs > 0) {
            stack = stack.func_77946_l();
            stack.func_190918_g(tfs);
        }
        if (this.handler.full()) {
            return stack;
        }
        if (!simulate && stack.func_190916_E() > 0) {
            entry.amount += stack.func_190916_E();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int idx, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        if (idx < 0 || idx >= this.handler.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        StackEntry entry = this.handler.stacks.get(idx);
        int exam = entry.max() < amount ? entry.max() : amount;
        ItemStack stack = (ItemStack)entry.genstack(exam).local();
        if (!simulate) {
            entry.amount -= exam;
            if (entry.amount <= 0) {
                entry.amount = 0;
                this.handler.stacks.remove(entry);
            }
        }
        return stack;
    }

    public int getSlotLimit(int idx) {
        if (idx < 0 || idx >= this.handler.stacks.size()) {
            return 0;
        }
        return this.handler.stacks.get(idx).max();
    }
}

