/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Sound;
import net.fexcraft.mod.fvtm.data.root.Soundable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.data.vehicle.CatalogPreset;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.SimplePhysData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.VehicleModel;
import net.fexcraft.mod.fvtm.sys.event.EventHolder;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class Vehicle
extends Content<Vehicle>
implements Textureable.TextureHolder,
Colorable.ColorHolder,
Soundable.SoundHolder,
WithItem,
ItemTextureable {
    protected Map<String, Attribute<?>> attributes = new LinkedHashMap();
    protected Map<String, WheelSlot> wheelpos = new LinkedHashMap<String, WheelSlot>();
    protected Map<String, V3D> connectors = new LinkedHashMap<String, V3D>();
    protected Map<String, FvtmInv> definvs = new LinkedHashMap<String, FvtmInv>();
    protected Model model;
    protected ModelData modeldata;
    protected List<IDL> textures;
    protected List<String> categories;
    protected Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    protected String modelid;
    protected String ctab;
    protected SimplePhysData sphdata;
    protected boolean trailer;
    protected boolean tracked;
    protected Map<String, IDL> installed;
    protected Map<String, Sound> sounds = new LinkedHashMap<String, Sound>();
    protected Map<String, SwivelPoint> swivelpoints = new LinkedHashMap<String, SwivelPoint>();
    protected float coupler_range = 1.0f;
    protected Map<String, LiftingPoint> liftingpoints = new HashMap<String, LiftingPoint>();
    protected Map<String, LiftingPoint[]> gliftingpoints = new HashMap<String, LiftingPoint[]>();
    protected List<InteractZone> interact_zones = new ArrayList<InteractZone>();
    protected List<CatalogPreset> catalog = new ArrayList<CatalogPreset>();
    protected List<Seat> defseats = new ArrayList<Seat>();
    protected EventHolder holder = new EventHolder(this);
    protected IDL keytype;
    protected int maxkeys;
    protected int impactlevel;
    protected PartSlots partslots;
    protected IDL itemtexloc;
    protected boolean no3ditem;
    protected VehicleType type;

    @Override
    public Vehicle parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Vehicle");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.type = VehicleType.valueOf(map.getString("VehicleType", "LAND").toUpperCase());
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("ColorChannels")) {
            for (Map.Entry entry : map.get("ColorChannels").asMap().entries()) {
                this.channels.put((String)entry.getKey(), new RGB(((JsonValue)entry.getValue()).string_value()));
            }
        }
        if (this.channels.isEmpty()) {
            this.channels.put("primary", RGB.WHITE.copy());
            this.channels.put("secondary", RGB.WHITE.copy());
        }
        ArrayList arrayList = this.categories = map.has("Categories") ? map.getArray("Categories").toStringList() : new ArrayList();
        if (map.has("Category")) {
            String cat = map.get("Category").string_value();
            if (cat.contains(",")) {
                String[] cats;
                for (String str : cats = cat.split(",")) {
                    this.categories.add(str.trim());
                }
            } else {
                this.categories.add(cat);
            }
        }
        this.maxkeys = map.getInteger("MaxKeys", 5);
        this.impactlevel = map.getInteger("ImpactWrench", 0);
        IDL iDL = this.keytype = map.has("KeyType") ? IDLManager.getIDLCached((String)map.getString("KeyType", null)) : null;
        if (map.has("Attributes") && map.get("Attributes").isMap()) {
            for (Map.Entry entry : map.getMap("Attributes").entries()) {
                Attribute<?> attr = Attribute.parse((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap());
                if (attr == null) continue;
                this.attributes.put(attr.id, attr);
            }
        }
        ArrayList<Attribute<?>> attrs = this.type.getDefaultAttributesForType(this.trailer);
        for (Attribute<?> attr : attrs) {
            if (!this.attributes.containsKey(attr.id)) {
                this.attributes.put(attr.id, attr);
                continue;
            }
            Attribute<?> attri = this.attributes.get(attr.id);
            attri.limit(attr.min, attr.max);
            attri.group(attr.group);
            attri.sync(attr.sync);
            attri.icons.putAll(attr.icons);
        }
        if (map.has("WheelPositions") && map.get("WheelPositions").isMap()) {
            for (Map.Entry entry : map.get("WheelPositions").asMap().entries()) {
                this.wheelpos.put((String)entry.getKey(), new WheelSlot(((JsonValue)entry.getValue()).asMap()));
            }
        }
        this.sphdata = new SimplePhysData(map.getMap("SimplePhysics"));
        this.trailer = map.getBoolean("Trailer", false) || map.getBoolean("Wagon", false);
        this.tracked = map.getBoolean("Tracked", false) || map.getBoolean("Catenary", false);
        this.coupler_range = map.getFloat("CouplerRange", this.coupler_range);
        if (map.has("InstalledParts")) {
            this.installed = new LinkedHashMap<String, IDL>();
            for (Map.Entry entry : map.getMap("InstalledParts").entries()) {
                this.installed.put((String)entry.getKey(), IDLManager.getIDLCached((String)((JsonValue)entry.getValue()).string_value()));
            }
        }
        if (map.has("SwivelPoints") && map.get("SwivelPoints").isMap()) {
            for (Map.Entry entry : map.getMap("SwivelPoints").entries()) {
                SwivelPoint point = new SwivelPoint((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap());
                this.swivelpoints.put((String)entry.getKey(), point);
            }
        }
        if (map.has("Sounds")) {
            for (Map.Entry entry : map.getMap("Sounds").entries()) {
                if (((JsonValue)entry.getValue()).isMap()) {
                    JsonMap val = ((JsonValue)entry.getValue()).asMap();
                    this.sounds.put((String)entry.getKey(), new Sound(IDLManager.getIDLCached((String)val.getString("sound", "minecraft:block.lever.click")), val.getFloat("volume", 1.0f), val.getFloat("pitch", 1.0f)));
                    continue;
                }
                this.sounds.put((String)entry.getKey(), new Sound(IDLManager.getIDLCached((String)((JsonValue)entry.getValue()).string_value()), 1.0f, 1.0f));
            }
        }
        if (map.has("LiftingPoints")) {
            for (Map.Entry entry : map.getMap("LiftingPoints").entries()) {
                if (((JsonValue)entry.getValue()).isArray()) {
                    this.liftingpoints.put((String)entry.getKey(), new LiftingPoint((String)entry.getKey(), ((JsonValue)entry.getValue()).asArray()));
                    continue;
                }
                this.liftingpoints.put((String)entry.getKey(), new LiftingPoint((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap()));
            }
        } else {
            this.liftingpoints.put("ph0", new LiftingPoint("ph0", new V3D(0.0, 0.0, -20.0), null, 0.0f));
            this.liftingpoints.put("ph1", new LiftingPoint("ph1", new V3D(0.0, 0.0, 20.0), null, 0.0f));
        }
        for (LiftingPoint point : this.liftingpoints.values()) {
            if (this.gliftingpoints.containsKey(point.id) || this.gliftingpoints.containsKey(point.second)) continue;
            LiftingPoint[] arr = new LiftingPoint[point.isSingular() ? 1 : 2];
            arr[0] = point;
            if (arr.length > 1) {
                arr[1] = this.liftingpoints.get(point.second);
            }
            this.gliftingpoints.put(point.id, arr);
        }
        this.partslots = new PartSlots(map.has("PartSlots") && map.get("PartSlots").isMap() ? map.getMap("PartSlots") : new JsonMap());
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        if (map.has("Catalog")) {
            for (Map.Entry catlog : map.getMap("Catalog").entries()) {
                try {
                    this.catalog.add(new CatalogPreset(this, (String)catlog.getKey(), ((JsonValue)catlog.getValue()).asMap()));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "vehicle catalog entry loading of " + this.id.colon());
                }
            }
        }
        if (map.has("InteractZones")) {
            for (Map.Entry entry : map.getMap("InteractZones").entries()) {
                this.interact_zones.add(new InteractZone((String)entry.getKey(), (JsonValue)entry.getValue()));
            }
        }
        if (this.interact_zones.isEmpty()) {
            this.interact_zones.add(new InteractZone("default", V3D.NULL, 4.0f, "vehicle"));
        }
        if (map.has("Events")) {
            for (JsonValue val : (List)map.getArray((String)"Events").value) {
                EventListener lis = null;
                try {
                    lis = EventListener.parse(val);
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "vehicle event parsing");
                }
                if (lis == null) continue;
                this.holder.insert(lis);
            }
        }
        if (map.has("DefaultSeats")) {
            for (Map.Entry entry : map.getMap("DefaultSeats").entries()) {
                this.defseats.add(new Seat((String)entry.getKey(), ((JsonValue)entry.getValue()).asMap()));
            }
        }
        if (map.has("Connectors")) {
            for (Map.Entry entry : map.getMap("Connectors").entries()) {
                try {
                    this.connectors.put((String)entry.getKey(), ContentConfigUtil.getVector(((JsonValue)entry.getValue()).asArray(), 0));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "vehicle connector parsing");
                }
            }
        }
        if (map.has("Inventories")) {
            for (Map.Entry entry : map.getMap("Inventories").entries()) {
                try {
                    JsonMap mep = ((JsonValue)entry.getValue()).asMap();
                    InvType type = InvType.parse(mep.getString("type", "item"));
                    this.definvs.put((String)entry.getKey(), (FvtmInv)type.newInv().init(mep));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "vehicle inventory parsing");
                }
            }
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.VEHICLE;
    }

    @Override
    public Class<?> getDataClass() {
        return VehicleData.class;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public boolean noCustomItemModel() {
        return this.no3ditem;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, VehicleModel.class);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    @Override
    public RGB getDefaultColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public Map<String, RGB> getDefaultColorChannels() {
        return this.channels;
    }

    @Override
    public Map<String, Sound> getSounds() {
        return this.sounds;
    }

    public <A extends Attribute<?>> A getDefaultAttribute(String id) {
        return (A)this.attributes.get(id);
    }

    public <C, A extends Attribute<C>> A getDefaultAttributeCasted(String id) {
        return (A)this.attributes.get(id);
    }

    public Map<String, Attribute<?>> getDefaultAttributes() {
        return this.attributes;
    }

    public Map<String, WheelSlot> getWheelPositions() {
        return this.wheelpos;
    }

    public SimplePhysData getSphData() {
        return this.sphdata;
    }

    public boolean isTrailer() {
        return this.trailer;
    }

    public boolean isWagon() {
        return this.trailer;
    }

    public Map<String, IDL> getInstalled() {
        return this.installed;
    }

    public float getCouplerRange() {
        return this.coupler_range;
    }

    public Map<String, SwivelPoint> getDefaultSwivelPoints() {
        return this.swivelpoints;
    }

    public Map<String, LiftingPoint> getLiftingPoints() {
        return this.liftingpoints;
    }

    public Map<String, LiftingPoint[]> getGroupedLiftingPoints() {
        return this.gliftingpoints;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public IDL getKeyType() {
        return this.keytype;
    }

    public PartSlots getPartSlots() {
        return this.partslots;
    }

    public int getMaxKeys() {
        return this.maxkeys;
    }

    public VehicleType getVehicleType() {
        return this.type;
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public List<CatalogPreset> getCatalog() {
        return this.catalog;
    }

    public CatalogPreset getCatalogEntry(String rec) {
        for (CatalogPreset preset : this.catalog) {
            if (!preset.id.equals(rec)) continue;
            return preset;
        }
        return null;
    }

    public List<InteractZone> getDefaultInteractZones() {
        return this.interact_zones;
    }

    public int getImpactWrenchLevel() {
        return this.impactlevel;
    }

    public EventHolder getEvents() {
        return this.holder;
    }

    public List<Seat> getDefaultSeats() {
        return this.defseats;
    }

    public Map<String, V3D> getDefaultConnectors() {
        return this.connectors;
    }

    public Map<String, FvtmInv> getDefaultInventories() {
        return this.definvs;
    }
}

