/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.item.DecorationItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class DecorationEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public ArrayList<DecorationData> decos = new ArrayList();
    private boolean locked;
    private int size = 4;

    public DecorationEntity(World world) {
        super(world);
        this.field_70138_W = 0.0f;
        this.func_70105_a((float)this.size * 0.0625f, (float)this.size * 0.0625f);
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            buffer.writeBoolean(this.locked);
            buffer.writeInt(this.size);
            buffer.writeInt(this.decos.size());
            for (DecorationData deco : this.decos) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)deco.write(TagCW.create()).local()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            this.locked = buffer.readBoolean();
            this.size = buffer.readInt();
            this.decos.clear();
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                DecorationData data = FvtmResources.getDecorationData(TagCW.wrap((Object)ByteBufUtils.readTag((ByteBuf)buffer)));
                if (data == null) continue;
                this.decos.add(data);
            }
            this.checksize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.size = compound.func_74762_e("size");
        this.decos.clear();
        if (compound.func_74764_b("decorations")) {
            NBTTagList list = (NBTTagList)compound.func_74781_a("decorations");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.decos.add(FvtmResources.getDecorationData(list.func_150305_b(i)));
            }
        }
        this.checksize();
    }

    private void checksize() {
        for (DecorationData data : this.decos) {
            if (data.size <= this.size) continue;
            this.size = data.size;
            this.func_70105_a((float)this.size * 0.0625f, (float)this.size * 0.0625f);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("size", this.size);
        NBTTagList list = new NBTTagList();
        for (DecorationData deco : this.decos) {
            list.func_74742_a((NBTBase)deco.write(TagCW.create()).local());
        }
        if (list.func_74745_c() > 0) {
            compound.func_74782_a("decorations", (NBTBase)list);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_180430_e(float k, float l) {
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70128_L || this.field_70170_p.field_72995_K || hand == EnumHand.OFF_HAND) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof MaterialItem && ((MaterialItem)stack.func_77973_b()).getContent().isVehicleKey()) {
            this.locked = !this.locked;
            Print.chat((ICommandSender)player, (String)"Toggled lock status.");
            return true;
        }
        if (this.locked) {
            Print.chat((ICommandSender)player, (String)"Decoration is locked.");
            return true;
        }
        if (stack.func_190926_b() || stack.func_77973_b() instanceof DecorationItem) {
            DecorationData data;
            if (stack.func_77973_b() instanceof DecorationItem && (data = ((DecorationItem)stack.func_77973_b()).getData(UniStack.getStack((Object)stack))) != null) {
                this.decos.add(data);
                this.updateClient();
            }
            player.openGui((Object)FVTM.getInstance(), 713, this.field_70170_p, this.func_145782_y(), 0, 0);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource.field_76373_n.equals("player")) {
            if (this.locked) {
                Print.chat((ICommandSender)damagesource.func_76364_f(), (String)"Deco is locked.");
                return true;
            }
            for (DecorationData deco : this.decos) {
                this.func_70099_a((ItemStack)deco.getNewStack().local(), 0.5f);
            }
            this.func_70106_y();
        }
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return (ItemStack)this.decos.get(0).getNewStack().local();
    }

    public void updateClient() {
        TagCW com = TagCW.create();
        this.func_70014_b((NBTTagCompound)com.local());
        com.set("entid", this.func_145782_y());
        Packets.sendToAll(Packet_TagListener.class, "deco", TagCW.wrap((Object)com));
    }
}

