/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.fexcraft.mod.fvtm.item.RoadToolItem;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class RoadMarker
extends Entity
implements IEntityAdditionalSpawnData {
    public QV3D position;
    public UUID queueid;

    public RoadMarker(World world) {
        super(world);
        this.field_70138_W = 0.0f;
        this.func_70105_a(0.24f, 0.5f);
    }

    public RoadMarker(World world, UUID id) {
        this(world);
        this.queueid = id;
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            if (this.queueid == null) {
                buffer.writeLong(0L);
                buffer.writeLong(0L);
            } else {
                buffer.writeLong(this.queueid.getMostSignificantBits());
                buffer.writeLong(this.queueid.getLeastSignificantBits());
            }
            buffer.writeDouble(this.position.vec.x);
            buffer.writeDouble(this.position.vec.y);
            buffer.writeDouble(this.position.vec.z);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            long m = buffer.readLong();
            long l = buffer.readLong();
            this.queueid = m == 0L && l == 0L ? null : new UUID(m, l);
            this.position = new QV3D(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("uuid0")) {
            this.queueid = new UUID(compound.func_74763_f("uuid0"), compound.func_74763_f("uuid1"));
        }
        if (compound.func_74764_b("position")) {
            this.position = new QV3D(TagCW.wrap((Object)compound), "position");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.queueid != null) {
            compound.func_74772_a("uuid0", this.queueid.getMostSignificantBits());
            compound.func_74772_a("uuid1", this.queueid.getLeastSignificantBits());
        }
        if (this.position != null) {
            this.position.write(TagCW.wrap((Object)compound), "position");
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_180430_e(float k, float l) {
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.queueid == null || !RoadPlacingUtil.QUEUE.containsKey(this.queueid)) {
            this.func_70106_y();
        }
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K || hand == EnumHand.OFF_HAND) {
            return true;
        }
        UUID current = RoadPlacingUtil.CURRENT.get(player.func_146103_bH().getId());
        if (current == null || this.queueid == null) {
            return true;
        }
        if (this.queueid.equals(current)) {
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(current);
            if (road == null) {
                return true;
            }
            Passenger pass = (Passenger)UniEntity.getEntity((Object)player);
            if (player.func_184614_ca().func_77973_b() instanceof RoadToolItem) {
                road.create(pass, this.position, pass.getHeldItem(true));
            } else {
                road.select(pass, this.position);
            }
            return true;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource.field_76373_n.equals("player") && this.queueid != null && this.queueid.equals(this.queueid)) {
            EntityPlayer player = (EntityPlayer)damagesource.func_76346_g();
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(this.queueid);
            if (road != null) {
                road.remove((Passenger)UniEntity.getEntity((Object)player), this.position);
            }
            this.func_70106_y();
        }
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(Items.field_151114_aO);
    }
}

