/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.block;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class BarrelBlockFunction
extends BlockFunction {
    private int stored;
    private int capacity;
    private String content_cat;
    private String stored_id;
    private ArrayList<String> compatible = new ArrayList();

    @Override
    public BlockFunction parse(JsonValue val) {
        if (val == null) {
            return this;
        }
        JsonMap map = val.asMap();
        this.capacity = map.getInteger("capacity", 1000);
        this.content_cat = map.getString("category", "barrel");
        if (map.has("compatible")) {
            JsonArray array = map.get("compatible").asArray();
            for (JsonValue elm : (List)array.value) {
                this.compatible.add(elm.string_value());
            }
        }
        return this;
    }

    @Override
    public BlockFunction load(TagCW com) {
        if (com.has(this.id())) {
            TagCW nbt = com.getCompound(this.id());
            this.stored = nbt.getInteger("stored");
            this.stored_id = nbt.getString("stored_id");
        }
        return this;
    }

    @Override
    public TagCW save(TagCW com) {
        TagCW nbt = TagCW.create();
        nbt.set("stored", this.stored);
        if (this.stored_id != null) {
            nbt.set("stored_id", this.stored_id);
        }
        nbt.set("capacity", this.capacity);
        com.set(this.id(), nbt);
        return com;
    }

    @Override
    public String id() {
        return "fvtm:barrel";
    }

    @Override
    public BlockFunction copy(Block block) {
        return new BarrelBlockFunction().set(this.capacity, this.content_cat, this.compatible);
    }

    public BlockFunction set(int c, String cc, ArrayList<String> ccc) {
        this.capacity = c;
        this.content_cat = cc;
        this.compatible.addAll(ccc);
        return this;
    }

    @Override
    public boolean onClick(WorldW world, V3I pos, V3D hit, StateWrapper state, CubeSide side, Passenger player, boolean main) {
        return main;
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, BlockData data, List<String> list, boolean adv) {
        list.add(Formatter.format((String)("&eContent Category: &7" + this.content_cat)));
        for (String str : this.compatible) {
            list.add(Formatter.format((String)("&e- &7" + str)));
        }
        list.add(Formatter.format((String)("&eStored: &7" + this.stored + "/" + this.capacity)));
        list.add(Formatter.format((String)("&e of &7" + (this.stored_id == null || this.stored_id.length() == 0 ? "nothing" : this.stored_id))));
    }
}

