/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class TransmissionFunction
extends PartFunction.StaticFunction {
    private ArrayList<Float> ratios = new ArrayList();
    private float u_low;
    private float u_mid;
    private float u_high;
    private float d_low;
    private float d_mid;
    private float d_high;
    private int fgears;
    private int rgears;
    private int shift_speed;
    private float efficiency;
    private boolean automatic;

    @Override
    public PartFunction init(Part part, FJson json) {
        JsonArray rats;
        JsonMap map = json.isMap() ? json.asMap() : new JsonMap();
        JsonArray jsonArray = rats = map.has("gear_ratios") ? map.getArray("gear_ratios") : null;
        if (rats == null) {
            this.ratios.add(Float.valueOf(-3.0f));
            this.ratios.add(Float.valueOf(0.0f));
            this.ratios.add(Float.valueOf(3.0f));
            this.ratios.add(Float.valueOf(2.0f));
            this.ratios.add(Float.valueOf(1.0f));
            this.ratios.add(Float.valueOf(0.5f));
        } else {
            for (JsonValue elm : (List)rats.value) {
                this.ratios.add(Float.valueOf(elm.float_value()));
            }
        }
        if (!this.ratios.contains(Float.valueOf(0.0f))) {
            this.ratios.add(Float.valueOf(0.0f));
        }
        Iterator<Object> iterator = this.ratios.iterator();
        while (iterator.hasNext()) {
            float f = ((Float)iterator.next()).floatValue();
            if (f > 0.0f) {
                ++this.fgears;
            }
            if (!(f < 0.0f)) continue;
            ++this.rgears;
        }
        this.automatic = map.getBoolean("automatic", false);
        JsonArray jsonArray2 = rats = map.has("throttle_ratios_up") ? map.getArray("throttle_ratios_up") : null;
        if (rats == null) {
            this.u_low = 0.35f;
            this.u_mid = 0.5f;
            this.u_high = 0.75f;
        } else {
            this.u_low = rats.get(0).float_value();
            this.u_mid = rats.get(1).float_value();
            this.u_high = rats.get(2).float_value();
        }
        JsonArray jsonArray3 = rats = map.has("throttle_ratios_down") ? map.getArray("throttle_ratios_down") : null;
        if (rats == null) {
            this.d_low = 0.25f;
            this.d_mid = 0.4f;
            this.d_high = 0.6f;
        } else {
            this.d_low = rats.get(0).float_value();
            this.d_mid = rats.get(1).float_value();
            this.d_high = rats.get(2).float_value();
        }
        this.efficiency = map.getFloat("efficiency", 0.7f);
        this.shift_speed = map.getInteger("shift_speed", 40);
        return this;
    }

    @Override
    public String getId() {
        return "fvtm:transmission";
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        tooltip.add(Formatter.format((String)("&9Gears: &7" + this.fgears + " / N / " + (this.rgears == 1 ? "R" : Integer.valueOf(this.rgears)))));
        tooltip.add(Formatter.format((String)("&9Range: &7" + this.ratios.get(this.rgears + 1) + "-" + this.ratios.get(this.ratios.size() - 1) + " / R" + (this.rgears == 1 ? Float.valueOf(-this.ratios.get(0).floatValue()) : -this.ratios.get(0).floatValue() + "-" + -this.ratios.get(this.rgears - 1).floatValue()))));
        tooltip.add(Formatter.format((String)("&9Type: &7" + (this.automatic ? "automatic" : "manual"))));
    }

    public ArrayList<Float> getRatios() {
        return this.ratios;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isManual() {
        return !this.automatic;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public int getFGearAmount() {
        return this.fgears;
    }

    public int getRGearAmount() {
        return this.rgears;
    }

    public float getRatio(int gear) {
        if (this.rgears + gear < 0) {
            gear = -this.rgears;
        }
        if (this.rgears + gear >= this.ratios.size()) {
            gear = this.ratios.size() - 1 - this.rgears;
        }
        return this.ratios.get(this.rgears + gear).floatValue();
    }

    public int processAutoShift(int gear, int rpm, int rpm_max, double throttle) {
        boolean rev;
        if (gear == 0) {
            return 0;
        }
        if (throttle < (double)0.001f) {
            return gear < -1 ? gear + 1 : (gear > 1 ? gear - 1 : gear);
        }
        float max = (float)rpm_max * (throttle < 0.3 ? this.u_low : (throttle < 0.7 ? this.u_mid : this.u_high));
        float min = (float)rpm_max * (throttle < 0.3 ? this.d_low : (throttle < 0.7 ? this.d_mid : this.d_high));
        boolean bl = rev = gear < 0;
        if (rev) {
            gear = -gear;
        }
        if ((float)rpm < min) {
            gear = gear <= 1 ? 1 : gear - 1;
        } else if ((float)rpm > max) {
            int gears = rev ? this.rgears : this.fgears;
            gear = gear >= gears ? gears : gear + 1;
        }
        return rev ? -gear : gear;
    }

    public int getShiftSpeed() {
        return this.shift_speed;
    }
}

