/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.data.block.CraftBlockScript;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.gui.block.GBCElm;
import net.fexcraft.mod.fvtm.gui.block.GBlockCraftContainer;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import scala.actors.threadpool.Arrays;

public class GBlockCraft
extends GenericGui<GBlockCraftContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/block_craftscript.png");
    private List<Object[]> relms;
    private List<String> tips = new ArrayList<String>();
    private AreaMap<List<String>> hoverables = new AreaMap();
    public Elm[] elements = new Elm[0];
    private int footerdepth;
    private int maxelm = 12;
    private int off = 16;
    private boolean has_status;
    private boolean has_progress;
    private boolean has_choose;
    private boolean has_reset;
    private boolean has_recipe;

    public GBlockCraft(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new GBlockCraftContainer(player, world, x, y, z), player);
        this.defbackground = true;
        this.deftexrect = false;
        ((GBlockCraftContainer)this.container).gui = this;
        this.field_146999_f = 256;
        int pass = 0;
        boolean half = false;
        this.relms = ((GBlockCraftContainer)this.container).script.getUIElements(((GBlockCraftContainer)this.container).tile.data, ((GBlockCraftContainer)this.container).data);
        this.elements = new Elm[this.relms.size()];
        for (int i = 0; i < this.elements.length; ++i) {
            GBCElm elm;
            this.elements[i] = new Elm();
            Object[] objs = this.relms.get(i);
            this.elements[i].elm = elm = (GBCElm)((Object)objs[0]);
            this.elements[i].off = this.off;
            if (elm.full || half) {
                this.off += elm.h;
                half = false;
                if (pass < this.maxelm) {
                    ++pass;
                    continue;
                }
                if (pass >= this.maxelm + 2) continue;
                pass = this.maxelm + 2;
                continue;
            }
            half = true;
        }
        if (half) {
            this.off += this.elements[this.elements.length - 1].elm.h;
        }
        this.field_147000_g = 39 + this.off;
        this.footerdepth = this.off;
    }

    protected void init() {
        this.texts.put("top", new GenericGui.BasicText(this.field_147003_i + 7, this.field_147009_r + 6, 244, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "loading....").hoverable(true));
        this.texts.put("page", new GenericGui.BasicText(this.field_147003_i + 175, this.field_147009_r + this.off + 6, 40, Integer.valueOf(MapColor.field_151646_E.field_76291_p), "-/-").hoverable(true));
        this.buttons.put("prev", new GenericGui.BasicButton("prev", this.field_147003_i + 219, this.field_147009_r + this.off + 2, 219, 122, 14, 14, true){

            public boolean onclick(int x, int y, int b) {
                GBlockCraft.this.updatePage(-1);
                return true;
            }
        });
        this.buttons.put("next", new GenericGui.BasicButton("next", this.field_147003_i + 235, this.field_147009_r + this.off + 2, 235, 122, 14, 14, true){

            public boolean onclick(int x, int y, int b) {
                GBlockCraft.this.updatePage(1);
                return true;
            }
        });
        ((GenericGui.BasicText)this.texts.get((Object)"top")).string = ((MultiBlock)((GBlockCraftContainer)this.container).tile.getMultiBlockData().getType()).getName();
        this.initElements();
    }

    private void initElements() {
        this.texts.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("e_"));
        this.buttons.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("e_"));
        block23: for (int i = 0; i < this.elements.length; ++i) {
            Object[] objs = this.relms.get(i);
            GBCElm elm = (GBCElm)((Object)objs[0]);
            String arg = objs.length > 1 ? objs[1].toString() : "";
            switch (this.elements[i].elm) {
                case SPACER: {
                    continue block23;
                }
                case ITEMVIEW: {
                    int oy = this.elements[i].off + 2;
                    for (int j = 0; j < 6; ++j) {
                        int k = j * 18;
                        this.hoverables.put(new Area(this.field_147003_i + 130 + k, this.field_147003_i + 130 + 16 + k, this.field_147009_r + oy, this.field_147009_r + oy + 16), new ArrayList());
                    }
                    this.elements[i].run = () -> {
                        if (((GBlockCraftContainer)this.container).current != null && !((GBlockCraftContainer)this.container).current.equals("none")) {
                            CraftBlockScript.Recipe recipe = CraftBlockScript.RECIPE_REGISTRY.get(((GBlockCraftContainer)this.container).current);
                            RenderHelper.func_74520_c();
                            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            for (int j = 0; j < 6; ++j) {
                                List<String> a = this.hoverables.get(this.field_147003_i + 130 + j * 18, this.field_147009_r + oy);
                                a.clear();
                                if (recipe.getOutput().size() <= j || !recipe.getOutput().get(j).getInventoryType().isItem()) continue;
                                this.field_146296_j.func_180450_b(recipe.getOutput().get((int)j).stack, this.field_147003_i + 130 + j * 18, this.field_147009_r + oy);
                                recipe.getOutput().get((int)j).stack.func_77973_b().func_77624_a(recipe.getOutput().get((int)j).stack, this.player.field_70170_p, a, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                            }
                            RenderHelper.func_74518_a();
                            TexUtil.bindTexture(texture);
                        }
                    };
                    continue block23;
                }
                case ELM_FULL_CLEAR: 
                case ELM_LEFT_CLEAR: 
                case ELM_RIGHT_CLEAR: 
                case ELM_FULL_TEXT: 
                case ELM_LEFT_TEXT: 
                case ELM_RIGHT_TEXT: {
                    if (arg == null || arg.length() == 0) continue block23;
                    int w = elm.full ? 238 : 116;
                    String id = null;
                    if (arg.startsWith("#") && arg.endsWith("#")) {
                        switch (arg) {
                            case "#status#": {
                                this.has_status = true;
                                id = "status";
                                break;
                            }
                            case "#recipe#": {
                                this.has_recipe = true;
                                id = "recipe";
                            }
                        }
                    } else if (arg.startsWith("@")) {
                        // empty if block
                    }
                    this.texts.put(id == null ? "e_" + i : id, new GenericGui.BasicText(this.field_147003_i + (elm.x > 0 ? elm.x + 3 : 9), this.field_147009_r + 3 + this.elements[i].off, w, Integer.valueOf(MapColor.field_151666_j.field_76291_p), arg).autoscale().hoverable(true));
                    if (id != null) continue block23;
                    ((GenericGui.BasicText)this.texts.get("e_" + i)).translate();
                    continue block23;
                }
                case ELM_LEFT_BUTTON: 
                case ELM_RIGHT_BUTTON: {
                    int w = elm.full ? 238 : 116;
                    arg = objs.length > 2 ? objs[2].toString() : "";
                    String id = null;
                    final Runnable[] run = new Runnable[]{null};
                    if (arg.startsWith("#") && arg.endsWith("#")) {
                        switch (arg) {
                            case "#choose#": {
                                this.has_choose = true;
                                id = "choose";
                                run[0] = () -> {
                                    NBTTagCompound compound = new NBTTagCompound();
                                    compound.func_74778_a("cargo", "open_chooser");
                                    ((GBlockCraftContainer)this.container).send(Side.SERVER, compound);
                                };
                                break;
                            }
                            case "#reset#": {
                                this.has_reset = true;
                                id = "reset";
                                run[0] = () -> {
                                    NBTTagCompound compound = new NBTTagCompound();
                                    compound.func_74778_a("cargo", ((GBlockCraftContainer)this.container).tickable ? "reset_recipe" : "craft_recipe");
                                    ((GBlockCraftContainer)this.container).send(Side.SERVER, compound);
                                };
                            }
                        }
                    } else if (arg.startsWith("@")) {
                        // empty if block
                    }
                    this.texts.put(id == null ? "e_" + i : id, new GenericGui.BasicText(this.field_147003_i + (elm.x > 0 ? elm.x + 4 : 10), this.field_147009_r + 3 + this.elements[i].off, w, Integer.valueOf(MapColor.field_151666_j.field_76291_p), objs[1].toString()).autoscale().translate().hoverable(true));
                    if (id == null) {
                        id = "e_" + i;
                    }
                    int x = elm.x > 0 ? elm.x + 1 : 7;
                    int y = 1 + this.elements[i].off;
                    this.buttons.put(id, new GenericGui.BasicButton(id, this.field_147003_i + x, this.field_147009_r + y, elm.x + (elm.x > 0 ? 1 : 7), elm.y + 1, 120, 12, true){

                        public boolean onclick(int x, int y, int b) {
                            if (run[0] != null) {
                                run[0].run();
                            }
                            return true;
                        }
                    });
                    continue block23;
                }
                case ELM_LEFT_PROGRESS: 
                case ELM_RIGHT_PROGRESS: {
                    if (arg == null || arg.length() == 0) continue block23;
                    RGB color = objs.length > 3 ? (objs[3] instanceof RGB ? (RGB)objs[3] : new RGB((String)objs[3])) : RGB.GREEN;
                    int ex = elm.x > 0 ? elm.x + 11 : 17;
                    int ey = 2 + this.elements[i].off;
                    this.hoverables.put(new Area(this.field_147003_i + ex, this.field_147003_i + ex + 100, this.field_147009_r + ey, this.field_147009_r + ey + 10), Arrays.asList((Object[])new String[]{""}));
                    if (arg.equals("#progress#")) {
                        this.elements[i].run = () -> {
                            int proc;
                            int n = proc = ((GBlockCraftContainer)this.container).script.getCooldown() > 0 || ((GBlockCraftContainer)this.container).script.getProcessed() <= 0 || ((GBlockCraftContainer)this.container).crafttime == 0 ? 0 : ((GBlockCraftContainer)this.container).script.getProcessed() * 100 / ((GBlockCraftContainer)this.container).crafttime;
                            if (proc > 0) {
                                if (proc > 107) {
                                    proc = 108;
                                }
                                color.glColorApply();
                                this.func_73729_b(this.field_147003_i + ex, this.field_147009_r + ey, ex, elm.y + 2, proc, 10);
                                RGB.glColorReset();
                            }
                            this.hoverables.get(this.field_147003_i + ex, this.field_147009_r + ey).set(0, proc + "%");
                        };
                        continue block23;
                    }
                    boolean auto = objs[2] instanceof String && objs[2].toString().equalsIgnoreCase("auto");
                    InvHandler inv = ((GBlockCraftContainer)this.container).data.getInventory((String)objs[1]);
                    int max = auto ? inv.capacity() : ((Integer)objs[2]).intValue();
                    this.elements[i].run = () -> {
                        int proc;
                        int val = inv.getVarValue();
                        int n = proc = max == 0 || val == 0 ? 0 : val * 100 / max;
                        if (proc > 0) {
                            if (proc > 107) {
                                proc = 108;
                            }
                            color.glColorApply();
                            this.func_73729_b(this.field_147003_i + ex, this.field_147009_r + ey, ex, elm.y + 2, proc, 10);
                            RGB.glColorReset();
                        }
                        this.hoverables.get(this.field_147003_i + ex, this.field_147009_r + ey).set(0, val + " / " + max);
                    };
                }
            }
        }
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        if (this.has_recipe) {
            ((GenericGui.BasicText)this.texts.get((Object)"recipe")).string = ((GBlockCraftContainer)this.container).current;
        }
        if (this.has_status) {
            ((GenericGui.BasicText)this.texts.get((Object)"status")).string = ((GBlockCraftContainer)this.container).tickable ? (((GBlockCraftContainer)this.container).script.getCooldown() > 0 ? "Cooldown/Paused (" + ((GBlockCraftContainer)this.container).script.getCooldown() + ")" : (((GBlockCraftContainer)this.container).current == null || ((GBlockCraftContainer)this.container).current.equals("none") ? "Idle" : "Working/Processing.")) : (((GBlockCraftContainer)this.container).ntstatus == null ? "" : (((GBlockCraftContainer)this.container).ntstatus.equals(GBlockCraftContainer.success) ? ((GBlockCraftContainer)this.container).crafted + "x " + ((GBlockCraftContainer)this.container).ntstatus : ((GBlockCraftContainer)this.container).ntstatus));
        }
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        this.drawElm(GBCElm.HEAD, 0);
        for (Elm elm : this.elements) {
            this.drawElm(elm.elm, elm.off);
            if (elm.run == null) continue;
            elm.run.run();
        }
        this.drawElm(GBCElm.FOOTER, this.elements.length == 0 ? 16 : this.footerdepth);
    }

    private void drawElm(GBCElm elm, int yoff) {
        this.func_73729_b(this.field_147003_i + elm.x, this.field_147009_r + yoff, elm.x, elm.y, elm.full ? 256 : 128, elm.h);
    }

    protected void scrollwheel(int am, int x, int y) {
        this.updatePage(am > 0 ? -1 : 1);
    }

    private void updatePage(int i) {
        ((GBlockCraftContainer)this.container).page += i;
        if (((GBlockCraftContainer)this.container).page < 0) {
            ((GBlockCraftContainer)this.container).page = 0;
        }
        ((GenericGui.BasicText)this.texts.get((Object)"page")).string = ((GBlockCraftContainer)this.container).page + 1 + "/pg";
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cargo", "page");
        compound.func_74768_a("page", ((GBlockCraftContainer)this.container).page);
        ((GBlockCraftContainer)this.container).send(Side.SERVER, compound);
    }

    public void drawlast(float ticks, int x, int y) {
        this.tips.clear();
        for (Map.Entry text : this.texts.entrySet()) {
            if (!((GenericGui.BasicText)text.getValue()).hovered) continue;
            this.tips.add(((GenericGui.BasicText)text.getValue()).string);
        }
        for (Map.Entry hov : this.hoverables.entrySet()) {
            if (x < ((Area)hov.getKey()).x || x > ((Area)hov.getKey()).xe || y < ((Area)hov.getKey()).y || y > ((Area)hov.getKey()).ye) continue;
            this.tips.addAll((Collection)hov.getValue());
        }
        if (this.tips.size() > 0) {
            this.drawHoveringText(this.tips, x, y, this.field_146289_q);
        }
    }

    private static class AreaMap<T>
    extends HashMap<Area, T> {
        private AreaMap() {
        }

        public Map.Entry<Area, T> get(int x, int xe, int y, int ye) {
            for (Map.Entry entry : this.entrySet()) {
                Area a = (Area)entry.getKey();
                if (a.x != x || a.xe != xe || a.y != y || a.ye != ye) continue;
                return entry;
            }
            return null;
        }

        public T get(int x, int y) {
            for (Map.Entry entry : this.entrySet()) {
                Area a = (Area)entry.getKey();
                if (a.x != x || a.y != y) continue;
                return (T)entry.getValue();
            }
            return null;
        }
    }

    private static class Area {
        public int x;
        public int xe;
        public int y;
        public int ye;

        public Area(int a, int ae, int b, int be) {
            this.x = a;
            this.xe = ae;
            this.y = b;
            this.ye = be;
        }
    }

    public static class Elm {
        protected GBCElm elm;
        protected Runnable run;
        protected int off;
    }
}

