/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.container;

import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerInvContainer
extends GenericContainer {
    protected GenericGui<ContainerInvContainer> gui;
    protected long fluid_date;
    protected IInventory fluid_io;
    protected FluidTank tank;
    protected int slots;
    protected ContainerEntity tile;

    public ContainerInvContainer(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        this.tile = (ContainerEntity)world.func_175625_s(new BlockPos(x, y, z));
        this.populateSlots();
    }

    protected void populateSlots() {
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        this.slots = 0;
        InvType type = this.tile.getInventoryType();
        if (type.isFluid()) {
            this.fluid_io = (IInventory)UniInventory.create((int)2).stacksize(1).cast();
            this.slots = 2;
            this.func_75146_a(new Slot(this.fluid_io, 0, 116, 50));
            this.func_75146_a(new Slot(this.fluid_io, 1, 152, 50));
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 74 + row * 18));
                }
            }
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, col, 8 + col * 18, 130));
            }
            this.tank = (FluidTank)this.tile.getContainerData().getInventory().getTank();
        }
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (!packet.func_74764_b("cargo")) {
            return;
        }
        if (!side.isServer() && packet.func_74779_i("cargo").equals("update_fluid_tank")) {
            this.tile.getContainerData().getInventory().load((TagCW)new TagCWI(packet), "state");
            if (packet.func_74764_b("stack_0")) {
                this.fluid_io.func_70299_a(0, new ItemStack(packet.func_74775_l("stack_0")));
            }
            if (packet.func_74764_b("stack_1")) {
                this.fluid_io.func_70299_a(1, new ItemStack(packet.func_74775_l("stack_1")));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.slots ? !this.func_75135_a(itemstack1, this.slots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.slots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.fluid_io != null) {
            this.fluid_io.func_174886_c(player);
        }
        this.tile.func_70296_d();
    }

    public void func_75142_b() {
        if (this.fluid_io != null && this.tile.getContainerData().getInventory().getTank() != null && this.fluid_date + 50L <= Time.getDate()) {
            IFluidHandlerItem item;
            this.fluid_date = Time.getDate();
            boolean anychange = false;
            ItemStack stack = this.fluid_io.func_70301_a(0);
            if (!stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties().length > 0 && item.getTankProperties()[0].getContents() != null && item.getTankProperties()[0].getContents().amount > 0) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.tile.getContainerData().getInventory().getTank()), (int)1000, (EntityPlayer)this.player, (boolean)true);
                if (result.success) {
                    anychange = true;
                    stack = result.getResult() == null ? ItemStack.field_190927_a : result.getResult();
                    this.fluid_io.func_70299_a(0, stack);
                }
            }
            if (((FluidTank)this.tile.getContainerData().getInventory().getTank()).getFluidAmount() > 0 && !(stack = this.fluid_io.func_70301_a(1)).func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.tile.getContainerData().getInventory().getTank()), (int)1000, (EntityPlayer)this.player, (boolean)true);
                if (result.success) {
                    anychange = true;
                    stack = result.getResult() == null ? ItemStack.field_190927_a : result.getResult();
                    this.fluid_io.func_70299_a(1, stack);
                }
            }
            if (!this.player.field_70170_p.field_72995_K && anychange) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("cargo", "update_fluid_tank");
                this.tile.getContainerData().getInventory().save((TagCW)new TagCWI(compound), "state");
                compound.func_74782_a("stack_0", (NBTBase)this.fluid_io.func_70301_a(0).func_77955_b(new NBTTagCompound()));
                compound.func_74782_a("stack_1", (NBTBase)this.fluid_io.func_70301_a(1).func_77955_b(new NBTTagCompound()));
                this.send(Side.CLIENT, compound);
            }
        }
        super.func_75142_b();
    }
}

