/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.gui.other.VehicleAndPartInfoContainer;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.util.I19U;
import net.fexcraft.mod.uni.IDL;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class VehicleAndPartInfo
extends GenericGui<VehicleAndPartInfoContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/vehicle_part_info.png");
    private static final String CAT_PRE = "# ";
    private static final String SUB_PRE = "  ";
    private boolean vehmode = true;
    private List<Addon> vehpacks;
    private List<Addon> partpacks;
    private List<Vehicle> vehicles;
    private List<Part> parts;
    private List<String> etexts = new ArrayList<String>();
    private List<String> itexts = new ArrayList<String>();
    private List<String> tips = new ArrayList<String>();
    private int pack_idx = 0;
    private int sel_idx = 0;
    private int scroll;
    private Addon addon;
    private Vehicle veh;
    private Part part;
    private VehMode vmode = VehMode.REQUIRED;
    private PartMode pmode = PartMode.CATEGORIES;
    private String selcat;
    private ItemStack stack = ItemStack.field_190927_a;

    public VehicleAndPartInfo(EntityPlayer player) {
        super(texture, (GenericContainer)new VehicleAndPartInfoContainer(player), player);
        this.field_146999_f = 248;
        this.field_147000_g = 215;
    }

    public void init() {
        int i;
        this.texts.put("title", new GenericGui.BasicText(this.field_147003_i + 35, this.field_147009_r + 9, 204, Integer.valueOf(0xCDCDCD), "gui.fvtm.vpinfo.title_" + (this.vehmode ? "veh" : "part")).translate().autoscale());
        this.texts.put("pack", new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 23, 204, null, "...").translate().autoscale().hoverable(true));
        this.texts.put("selected", new GenericGui.BasicText(this.field_147003_i + 29, this.field_147009_r + 38, 186, null, "...").translate().autoscale().hoverable(true));
        this.texts.put("selid", new GenericGui.BasicText(this.field_147003_i + 29, this.field_147009_r + 46, 186, null, "...").translate().scale(0.75f).hoverable(true));
        this.texts.put("mode", new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 61, 204, null, "...").translate().autoscale());
        for (i = 0; i < 9; ++i) {
            this.texts.put("line" + i, new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 75 + i * 14, 204, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "...").translate().autoscale().hoverable(true));
        }
        this.texts.put("scroll", new GenericGui.BasicText(this.field_147003_i + 151, this.field_147009_r + 200, 68, null, "0/0").translate().autoscale());
        this.buttons.put("vehmode", new GenericGui.BasicButton("vehmode", this.field_147003_i + 7, this.field_147009_r + 7, 7, 7, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                VehicleAndPartInfo.this.switchmode(true);
                return true;
            }
        });
        this.buttons.put("partmode", new GenericGui.BasicButton("partmode", this.field_147003_i + 20, this.field_147009_r + 7, 7, 20, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                VehicleAndPartInfo.this.switchmode(false);
                return true;
            }
        });
        this.buttons.put("pack_prev", new GenericGui.BasicButton("p_p", this.field_147003_i + 216, this.field_147009_r + 21, 216, 21, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (--VehicleAndPartInfo.this.pack_idx < 0) {
                    VehicleAndPartInfo.this.pack_idx = (VehicleAndPartInfo.this.vehmode ? VehicleAndPartInfo.this.vehpacks : VehicleAndPartInfo.this.partpacks).size() - 1;
                }
                VehicleAndPartInfo.this.refcontentlist();
                return true;
            }
        });
        this.buttons.put("pack_next", new GenericGui.BasicButton("p_n", this.field_147003_i + 229, this.field_147009_r + 21, 229, 21, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (++VehicleAndPartInfo.this.pack_idx >= (VehicleAndPartInfo.this.vehmode ? VehicleAndPartInfo.this.vehpacks : VehicleAndPartInfo.this.partpacks).size()) {
                    VehicleAndPartInfo.this.pack_idx = 0;
                }
                VehicleAndPartInfo.this.refcontentlist();
                return true;
            }
        });
        this.buttons.put("sel_prev", new GenericGui.BasicButton("s_p", this.field_147003_i + 216, this.field_147009_r + 41, 216, 41, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (--VehicleAndPartInfo.this.sel_idx < 0) {
                    VehicleAndPartInfo.this.sel_idx = (VehicleAndPartInfo.this.vehmode ? VehicleAndPartInfo.this.vehicles : VehicleAndPartInfo.this.parts).size() - 1;
                }
                VehicleAndPartInfo.this.refmode();
                return true;
            }
        });
        this.buttons.put("sel_next", new GenericGui.BasicButton("s_n", this.field_147003_i + 229, this.field_147009_r + 41, 229, 41, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (++VehicleAndPartInfo.this.sel_idx >= (VehicleAndPartInfo.this.vehmode ? VehicleAndPartInfo.this.vehicles : VehicleAndPartInfo.this.parts).size()) {
                    VehicleAndPartInfo.this.sel_idx = 0;
                }
                VehicleAndPartInfo.this.refmode();
                return true;
            }
        });
        this.buttons.put("mode_prev", new GenericGui.BasicButton("m_p", this.field_147003_i + 216, this.field_147009_r + 59, 216, 59, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (VehicleAndPartInfo.this.vehmode) {
                    if (VehicleAndPartInfo.this.vmode.ordinal() - 1 < 0) {
                        VehicleAndPartInfo.this.vmode = VehMode.COMPATIBLE_ALL;
                    } else {
                        VehicleAndPartInfo.this.vmode = VehMode.values()[VehicleAndPartInfo.this.vmode.ordinal() - 1];
                    }
                } else if (VehicleAndPartInfo.this.pmode.ordinal() - 1 < 0) {
                    VehicleAndPartInfo.this.pmode = PartMode.COMPATIBLE;
                } else {
                    VehicleAndPartInfo.this.pmode = PartMode.values()[VehicleAndPartInfo.this.pmode.ordinal() - 1];
                }
                VehicleAndPartInfo.this.refmode();
                return true;
            }
        });
        this.buttons.put("mode_next", new GenericGui.BasicButton("m_n", this.field_147003_i + 229, this.field_147009_r + 59, 229, 59, 12, 12, true){

            public boolean onclick(int x, int y, int m) {
                if (VehicleAndPartInfo.this.vehmode) {
                    if (VehicleAndPartInfo.this.vmode.ordinal() + 1 >= VehMode.values().length - 1) {
                        VehicleAndPartInfo.this.vmode = VehMode.REQUIRED;
                    } else {
                        VehicleAndPartInfo.this.vmode = VehMode.values()[VehicleAndPartInfo.this.vmode.ordinal() + 1];
                    }
                } else if (VehicleAndPartInfo.this.pmode.ordinal() + 1 >= PartMode.values().length) {
                    VehicleAndPartInfo.this.pmode = PartMode.CATEGORIES;
                } else {
                    VehicleAndPartInfo.this.pmode = PartMode.values()[VehicleAndPartInfo.this.pmode.ordinal() + 1];
                }
                VehicleAndPartInfo.this.refmode();
                return true;
            }
        });
        for (i = 0; i < 9; ++i) {
            final int j = i;
            this.buttons.put("entry" + i, new GenericGui.BasicButton("e" + i, this.field_147003_i + 229, this.field_147009_r + 73 + i * 14, 229, 216, 12, 12, true){

                public boolean onclick(int x, int y, int m) {
                    block11: {
                        block10: {
                            if (!VehicleAndPartInfo.this.vehmode) break block10;
                            switch (VehicleAndPartInfo.this.vmode) {
                                case REQUIRED: {
                                    VehicleAndPartInfo.this.vmode = VehMode.COMPATIBLE_SPECIFIC;
                                    VehicleAndPartInfo.this.selcat = (String)VehicleAndPartInfo.this.etexts.get(j + VehicleAndPartInfo.this.scroll);
                                    VehicleAndPartInfo.this.refmode();
                                    break block11;
                                }
                                case PRE_INSTALLED: {
                                    Part pert = FvtmRegistry.PARTS.get((String)VehicleAndPartInfo.this.itexts.get(j + VehicleAndPartInfo.this.scroll));
                                    VehicleAndPartInfo.this.switchmode(false);
                                    VehicleAndPartInfo.this.pack_idx = VehicleAndPartInfo.this.partpacks.indexOf(pert.getAddon());
                                    VehicleAndPartInfo.this.refcontentlist();
                                    VehicleAndPartInfo.this.sel_idx = VehicleAndPartInfo.this.parts.indexOf(pert);
                                    VehicleAndPartInfo.this.refmode();
                                    break block11;
                                }
                                case COMPATIBLE_ALL: {
                                    String cat = (String)VehicleAndPartInfo.this.etexts.get(j + VehicleAndPartInfo.this.scroll);
                                    if (cat.startsWith(VehicleAndPartInfo.CAT_PRE)) {
                                        VehicleAndPartInfo.this.vmode = VehMode.COMPATIBLE_SPECIFIC;
                                        VehicleAndPartInfo.this.selcat = (String)VehicleAndPartInfo.this.itexts.get(j + VehicleAndPartInfo.this.scroll);
                                        VehicleAndPartInfo.this.refmode();
                                    } else {
                                        Part part = FvtmRegistry.PARTS.get((String)VehicleAndPartInfo.this.itexts.get(j + VehicleAndPartInfo.this.scroll));
                                        VehicleAndPartInfo.this.switchmode(false);
                                        VehicleAndPartInfo.this.pack_idx = VehicleAndPartInfo.this.partpacks.indexOf(part.getAddon());
                                        VehicleAndPartInfo.this.refcontentlist();
                                        VehicleAndPartInfo.this.sel_idx = VehicleAndPartInfo.this.parts.indexOf(part);
                                        VehicleAndPartInfo.this.refmode();
                                    }
                                    break block11;
                                }
                                case COMPATIBLE_SPECIFIC: {
                                    Part part = FvtmRegistry.PARTS.get((String)VehicleAndPartInfo.this.itexts.get(j + VehicleAndPartInfo.this.scroll));
                                    VehicleAndPartInfo.this.switchmode(false);
                                    VehicleAndPartInfo.this.pack_idx = VehicleAndPartInfo.this.partpacks.indexOf(part.getAddon());
                                    VehicleAndPartInfo.this.refcontentlist();
                                    VehicleAndPartInfo.this.sel_idx = VehicleAndPartInfo.this.parts.indexOf(part);
                                    VehicleAndPartInfo.this.refmode();
                                    break block11;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        if (VehicleAndPartInfo.this.pmode == PartMode.COMPATIBLE && !((String)VehicleAndPartInfo.this.etexts.get(j + VehicleAndPartInfo.this.scroll)).startsWith(VehicleAndPartInfo.CAT_PRE)) {
                            Vehicle veh = FvtmRegistry.VEHICLES.get((String)VehicleAndPartInfo.this.itexts.get(j + VehicleAndPartInfo.this.scroll));
                            VehicleAndPartInfo.this.switchmode(true);
                            VehicleAndPartInfo.this.pack_idx = VehicleAndPartInfo.this.vehpacks.indexOf(veh.getAddon());
                            VehicleAndPartInfo.this.refcontentlist();
                            VehicleAndPartInfo.this.sel_idx = VehicleAndPartInfo.this.vehicles.indexOf(veh);
                            VehicleAndPartInfo.this.refmode();
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        this.buttons.put("scroll_up", new GenericGui.BasicButton("s_u", this.field_147003_i + 222, this.field_147009_r + 199, 222, 199, 9, 9, true){

            public boolean onclick(int x, int y, int m) {
                if (--VehicleAndPartInfo.this.scroll < 0) {
                    VehicleAndPartInfo.this.scroll = 0;
                }
                VehicleAndPartInfo.this.refscroll();
                return true;
            }
        });
        this.buttons.put("scroll_dw", new GenericGui.BasicButton("s_d", this.field_147003_i + 232, this.field_147009_r + 199, 232, 199, 9, 9, true){

            public boolean onclick(int x, int y, int m) {
                if (++VehicleAndPartInfo.this.scroll + 9 >= VehicleAndPartInfo.this.etexts.size()) {
                    VehicleAndPartInfo.this.scroll = VehicleAndPartInfo.this.etexts.size() - 9;
                }
                VehicleAndPartInfo.this.refscroll();
                return true;
            }
        });
        this.buttons.put("item_hover", new GenericGui.BasicButton("i_h", this.field_147003_i + 8, this.field_147009_r + 36, 8, 36, 16, 16, true));
        this.collectpacks();
        if (this.vehpacks.isEmpty()) {
            Print.chat((ICommandSender)this.player, (String)I19U.trsc("gui.fvtm.vpinfo.no_vehicles", new Object[0]));
            this.player.func_71053_j();
        }
        if (this.partpacks.isEmpty()) {
            Print.chat((ICommandSender)this.player, (String)I19U.trsc("gui.fvtm.vpinfo.no_parts", new Object[0]));
            this.player.func_71053_j();
        }
        this.refcontentlist();
    }

    private void collectpacks() {
        this.vehpacks = new ArrayList<Addon>();
        for (Vehicle veh : FvtmRegistry.VEHICLES) {
            if (this.vehpacks.contains(veh.getAddon())) continue;
            this.vehpacks.add(veh.getAddon());
        }
        this.partpacks = new ArrayList<Addon>();
        for (Part part : FvtmRegistry.PARTS) {
            if (this.partpacks.contains(part.getAddon())) continue;
            this.partpacks.add(part.getAddon());
        }
    }

    protected void switchmode(boolean to) {
        this.vehmode = to;
        ((GenericGui.BasicText)this.texts.get((Object)"title")).string = "gui.fvtm.vpinfo.title_" + (this.vehmode ? "veh" : "part");
        ((GenericGui.BasicText)this.texts.get("title")).translate();
        this.refcontentlist();
    }

    protected void refcontentlist() {
        if (this.vehicles != null) {
            this.vehicles.clear();
        }
        if (this.parts != null) {
            this.parts.clear();
        }
        this.addon = (this.vehmode ? this.vehpacks : this.partpacks).get(this.pack_idx);
        if (this.vehmode) {
            this.vehicles = FvtmRegistry.VEHICLES.stream().filter(veh -> veh.getAddon() == this.addon).collect(Collectors.toList());
            this.sel_idx = 0;
            this.veh = this.vehicles.get(0);
        } else {
            this.parts = FvtmRegistry.PARTS.stream().filter(part -> part.getAddon() == this.addon).collect(Collectors.toList());
            this.sel_idx = 0;
            this.part = this.parts.get(0);
        }
        this.refmode();
    }

    protected void refmode() {
        if (this.vehmode) {
            this.veh = this.vehicles.get(this.sel_idx);
            this.stack = (ItemStack)this.veh.getNewStack().local();
        } else {
            this.part = this.parts.get(this.sel_idx);
            this.stack = (ItemStack)this.part.getNewStack().local();
        }
        ((GenericGui.BasicText)this.texts.get((Object)"mode")).string = "gui.fvtm.vpinfo.mode." + (this.vehmode ? this.vmode : this.pmode).name().toLowerCase();
        if (this.selcat == null || !this.vehmode || this.vmode != VehMode.COMPATIBLE_SPECIFIC) {
            ((GenericGui.BasicText)this.texts.get("mode")).translate();
        } else {
            ((GenericGui.BasicText)this.texts.get("mode")).translate(new Object[]{this.selcat});
        }
        this.etexts.clear();
        this.itexts.clear();
        if (this.vehmode) {
            switch (this.vmode) {
                case REQUIRED: {
                    break;
                }
                case PRE_INSTALLED: {
                    if (this.veh.getInstalled() == null) break;
                    this.veh.getInstalled().entrySet().forEach(entry -> {
                        this.etexts.add((String)entry.getKey());
                        this.itexts.add(((IDL)entry.getValue()).toString());
                    });
                    break;
                }
                case COMPATIBLE_ALL: {
                    this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.wait", new Object[0]));
                    this.field_146297_k.func_152344_a(() -> {
                        VehicleData vdata = new VehicleData(this.veh);
                        ArrayList cats = new ArrayList();
                        HashMap<String, ArrayList<String>> emap = new HashMap<String, ArrayList<String>>();
                        HashMap<String, ArrayList<String>> imap = new HashMap<String, ArrayList<String>>();
                        PartInstallHandler handler = null;
                        boolean slot = false;
                        for (Part part : FvtmRegistry.PARTS) {
                            slot = part.getInstallHandler() instanceof DefaultPartInstallHandler;
                            PartData data = new PartData(part);
                            cats.clear();
                            if (slot) {
                                for (String str : cats) {
                                    if (!vdata.hasPartSlot(str)) continue;
                                    this.fillmap(emap, imap, str, part.getName(), part.getID());
                                }
                                continue;
                            }
                            handler = part.getInstallHandler();
                            for (String str : cats) {
                                if (!handler.validInstall(null, data, str, vdata, false)) continue;
                                this.fillmap(emap, imap, str, part.getName(), part.getID());
                            }
                        }
                        this.etexts.clear();
                        this.itexts.clear();
                        emap.entrySet().forEach(entry -> {
                            this.etexts.add(CAT_PRE + (String)entry.getKey());
                            ((ArrayList)entry.getValue()).forEach(elm -> this.etexts.add(SUB_PRE + elm));
                        });
                        imap.entrySet().forEach(entry -> {
                            this.itexts.add((String)entry.getKey());
                            ((ArrayList)entry.getValue()).forEach(elm -> this.itexts.add((String)elm));
                        });
                        if (this.etexts.isEmpty()) {
                            this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.none", new Object[0]));
                        }
                    });
                    break;
                }
                case COMPATIBLE_SPECIFIC: {
                    this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.wait", new Object[0]));
                    this.field_146297_k.func_152344_a(() -> {
                        VehicleData vdata = new VehicleData(this.veh);
                        ArrayList<String> elist = new ArrayList<String>();
                        ArrayList<String> ilist = new ArrayList<String>();
                        PartInstallHandler handler = null;
                        boolean slot = false;
                        for (Part part : FvtmRegistry.PARTS) {
                            slot = part.getInstallHandler() instanceof DefaultPartInstallHandler;
                            PartData data = new PartData(part);
                            if (slot) {
                                if (!vdata.hasPartSlot(this.selcat)) continue;
                                elist.add(part.getName());
                                ilist.add(part.getIDS());
                                continue;
                            }
                            handler = part.getInstallHandler();
                            if (!handler.validInstall(null, data, this.selcat, vdata, false)) continue;
                            elist.add(part.getName());
                            ilist.add(part.getIDS());
                        }
                        this.etexts.clear();
                        this.itexts.clear();
                        elist.forEach(elm -> this.etexts.add((String)elm));
                        ilist.forEach(elm -> this.itexts.add((String)elm));
                        if (this.etexts.isEmpty()) {
                            this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.none", new Object[0]));
                        }
                    });
                    break;
                }
                default: {
                    this.etexts.add("error.unknown.mode");
                    break;
                }
            }
        } else {
            switch (this.pmode) {
                case CATEGORIES: {
                    this.etexts.addAll(this.part.getCategories());
                    break;
                }
                case COMPATIBLE: {
                    this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.wait", new Object[0]));
                    this.field_146297_k.func_152344_a(() -> {
                        PartData data = new PartData(this.part);
                        boolean slot = this.part.getInstallHandler() instanceof DefaultPartInstallHandler;
                        HashMap<String, ArrayList<String>> emap = new HashMap<String, ArrayList<String>>();
                        HashMap<String, ArrayList<String>> imap = new HashMap<String, ArrayList<String>>();
                        PartInstallHandler handler = null;
                        for (Vehicle veh : FvtmRegistry.VEHICLES) {
                            VehicleData vdata = new VehicleData(veh);
                            if (slot) {
                                for (String cat : this.part.getCategories()) {
                                    if (!vdata.hasPartSlot(cat)) continue;
                                    this.fillmap(emap, imap, cat, veh.getName(), veh.getID());
                                }
                                continue;
                            }
                            handler = this.part.getInstallHandler();
                            for (String cat : this.part.getCategories()) {
                                if (!handler.validInstall(null, data, this.selcat, vdata, false)) continue;
                                this.fillmap(emap, imap, cat, veh.getName(), veh.getID());
                            }
                        }
                        this.etexts.clear();
                        this.itexts.clear();
                        emap.entrySet().forEach(entry -> {
                            this.etexts.add(CAT_PRE + (String)entry.getKey());
                            ((ArrayList)entry.getValue()).forEach(elm -> this.etexts.add(SUB_PRE + elm));
                        });
                        imap.entrySet().forEach(entry -> {
                            this.itexts.add((String)entry.getKey());
                            ((ArrayList)entry.getValue()).forEach(elm -> this.itexts.add((String)elm));
                        });
                        if (this.etexts.isEmpty()) {
                            this.etexts.add(I19U.trsc("gui.fvtm.vpinfo.line.none", new Object[0]));
                        }
                    });
                    break;
                }
                default: {
                    this.etexts.add("error.unknown.mode");
                }
            }
        }
        this.scroll = 0;
        this.refscroll();
    }

    private void fillmap(HashMap<String, ArrayList<String>> emap, HashMap<String, ArrayList<String>> imap, String cat, String name, IDL regname) {
        if (!emap.containsKey(cat)) {
            emap.put(cat, new ArrayList());
        }
        emap.get(cat).add(name);
        if (!imap.containsKey(cat)) {
            imap.put(cat, new ArrayList());
        }
        imap.get(cat).add(regname.colon());
    }

    private void fillcats(ArrayList<String> cats, ArrayList<String> list0, List<String> list1) {
        for (String str : list0) {
            if (cats.contains(str)) continue;
            cats.add(str);
        }
        for (String str : list1) {
            if (cats.contains(str)) continue;
            cats.add(str);
        }
    }

    private void refscroll() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        for (int i = 0; i < 9; ++i) {
            boolean vis;
            int j = this.scroll + i;
            boolean bl = vis = j < this.etexts.size();
            if (vis && !this.vehmode) {
                vis = this.pmode == PartMode.CATEGORIES ? false : !this.etexts.get(j).startsWith(CAT_PRE);
            }
            ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"entry").append((int)i).toString())).visible = j < this.etexts.size() && (this.vehmode || this.pmode != PartMode.CATEGORIES);
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"line").append((int)i).toString())).string = j >= this.etexts.size() ? "" : this.etexts.get(j);
        }
        ((GenericGui.BasicText)this.texts.get((Object)"scroll")).string = this.scroll + "/" + (this.etexts.size() < 9 ? 0 : this.etexts.size() - 9);
    }

    public void predraw(float ticks, int x, int y) {
        ((GenericGui.BasicText)this.texts.get((Object)"pack")).string = this.addon.getName();
        ((GenericGui.BasicText)this.texts.get((Object)"selected")).string = this.vehmode ? this.veh.getName() : this.part.getName();
        ((GenericGui.BasicText)this.texts.get((Object)"selid")).string = this.vehmode ? this.veh.getIDS() : this.part.getIDS();
    }

    public void drawlast(float ticks, int x, int y) {
        if (this.stack == null) {
            return;
        }
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146296_j.func_180450_b(this.stack, this.field_147003_i + 8, this.field_147009_r + 36);
        RenderHelper.func_74518_a();
        this.tips.clear();
        for (Map.Entry text : this.texts.entrySet()) {
            boolean imode;
            if (!((GenericGui.BasicText)text.getValue()).hovered) continue;
            boolean bl = imode = this.vehmode ? this.vmode.hasinfotip() : this.pmode.hasinfotip();
            if (imode && ((String)text.getKey()).startsWith("line")) {
                int i = Integer.parseInt(((String)text.getKey()).substring(4));
                if (((GenericGui.BasicText)text.getValue()).string.startsWith(SUB_PRE)) {
                    this.tips.add(((GenericGui.BasicText)text.getValue()).string.substring(2));
                }
                if (i >= this.itexts.size()) continue;
                this.tips.add(this.itexts.get(i + this.scroll));
                continue;
            }
            this.tips.add(((GenericGui.BasicText)text.getValue()).string);
        }
        if (((GenericGui.BasicButton)this.buttons.get((Object)"item_hover")).hovered) {
            this.tips.addAll(this.stack.func_82840_a(this.player, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
        }
        if (this.tips.size() > 0) {
            this.drawHoveringText(this.tips, x, y, this.field_146289_q);
        }
    }

    protected void scrollwheel(int am, int x, int y) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll + 9 >= this.etexts.size()) {
            this.scroll = this.etexts.size() - 9;
        }
        this.refscroll();
    }

    public static enum PartMode {
        CATEGORIES,
        COMPATIBLE;


        boolean hasinfotip() {
            return this == COMPATIBLE;
        }
    }

    public static enum VehMode {
        REQUIRED,
        PRE_INSTALLED,
        COMPATIBLE_ALL,
        COMPATIBLE_SPECIFIC;


        boolean hasinfotip() {
            return this != REQUIRED;
        }
    }
}

