/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.wire;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.gui.wire.WireRelayContainer;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class WireEditor
extends GenericGui<WireRelayContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/wire_editor.png");
    private static GenericGui.BasicButton[] b = new GenericGui.BasicButton[9];
    private static GenericGui.BasicText[] t = new GenericGui.BasicText[9];
    private ArrayList<String> tooltip = new ArrayList();
    private static int scroll;

    public WireEditor(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new WireRelayContainer(player, world, x, y, z, false), player);
        ((WireRelayContainer)this.container).gui = this;
        this.defbackground = false;
        this.deftexrect = false;
        this.field_146999_f = 144;
        this.field_147000_g = 189;
    }

    protected void init() {
        this.texts.put("title", new GenericGui.BasicText(4, 4, 95, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "Wire Editor"));
        this.buttons.put("help", new GenericGui.BasicButton("help", 105, 2, 105, 2, 12, 12, true));
        this.buttons.put("copy", new GenericGui.BasicButton("copy", 118, 2, 118, 2, 12, 12, true));
        this.buttons.put("up", new GenericGui.BasicButton("up", 131, 40, 131, 40, 7, 12, true));
        this.buttons.put("dw", new GenericGui.BasicButton("dw", 131, 152, 131, 152, 7, 12, true));
        this.buttons.put("reset", new GenericGui.BasicButton("reset", 123, 21, 123, 21, 7, 12, true));
        this.buttons.put("change", new GenericGui.BasicButton("change", 131, 21, 131, 21, 7, 12, true));
        for (int i = 0; i < b.length; ++i) {
            WireEditor.b[i] = new GenericGui.BasicButton("b" + i, 2, 40 + i * 14, 2, 40, 128, 12, true);
            this.buttons.put("b" + i, WireEditor.b[i]);
            WireEditor.t[i] = new GenericGui.BasicText(4, 42 + i * 14, 124, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "...").autoscale();
            this.texts.put("t" + i, WireEditor.t[i]);
        }
        this.texts.put("current", new GenericGui.BasicText(4, 23, 116, Integer.valueOf(MapColor.field_151666_j.field_76291_p), ((WireRelayContainer)this.container).currdeconame()).autoscale());
        this.texts.put("slack", new GenericGui.BasicText(4, 168, 54, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "Slack"));
        this.fields.put("slack", new GenericGui.TextField(0, this.field_146289_q, 60, 167, 60, 10));
        ((GenericGui.TextField)this.fields.get("slack")).func_146180_a(((WireRelayContainer)this.container).wire.slack + "");
        this.buttons.put("slack", new GenericGui.BasicButton("slack", 122, 167, 122, 167, 7, 10, true));
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        ((GenericGui.BasicText)this.texts.get((Object)"current")).string = ((WireRelayContainer)this.container).currdeconame();
        for (int i = 0; i < b.length; ++i) {
            int j = i + scroll;
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"t").append((int)i).toString())).string = !((WireRelayContainer)this.container).models.containsKey(WireRelayContainer.CURRDECO) || j >= ((WireRelayContainer)this.container).models.get(WireRelayContainer.CURRDECO).size() ? "" : ((WireRelayContainer)this.container).models.get(WireRelayContainer.CURRDECO).get(j).getIDS();
        }
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawlast(float pticks, int mouseX, int mouseY) {
        this.tooltip.clear();
        if (((GenericGui.BasicButton)this.buttons.get("reset")).hovered(mouseX, mouseY)) {
            this.tooltip.add(Formatter.format((String)"&eRemove current Wire-Deco."));
        }
        if (((GenericGui.BasicButton)this.buttons.get("change")).hovered(mouseX, mouseY)) {
            this.tooltip.add(Formatter.format((String)"&eChange Deco Type"));
            this.tooltip.add(Formatter.format((String)("&7Current deco type: &6" + WireRelayContainer.CURRDECO)));
        }
        if (((GenericGui.BasicButton)this.buttons.get("up")).hovered(mouseX, mouseY)) {
            this.tooltip.add(Formatter.format((String)"&7Scroll up."));
        }
        if (((GenericGui.BasicButton)this.buttons.get("dw")).hovered(mouseX, mouseY)) {
            this.tooltip.add(Formatter.format((String)"&7Scroll down."));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!b[i].hovered(mouseX, mouseY)) continue;
            this.tooltip.add(Formatter.format((String)"&eClick to apply."));
        }
        if (this.tooltip.size() > 0) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("copy")) {
            ((GenericGui.BasicText)this.texts.get((Object)"title")).string = "Position Copied to clipboard!";
            StringSelection selection = new StringSelection(((WireRelayContainer)this.container).wire.key.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            return true;
        }
        if (button.name.equals("help")) {
            WireEditor parent = this;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://fexcraft.net/wiki/mod/fvtm/wire", 31102009, true, (GuiScreen)parent){
                final /* synthetic */ GuiScreen val$parent;
                {
                    this.val$parent = guiScreen;
                    super(x0, x1, x2, x3);
                }

                public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                    this.val$parent.func_73863_a(-1, -1, partialTicks);
                    super.func_73863_a(mouseX, mouseY, partialTicks);
                }
            });
            return true;
        }
        if (button.name.equals("up")) {
            if (--scroll < 0) {
                scroll = 0;
            }
            return true;
        }
        if (button.name.equals("dw")) {
            ++scroll;
            return true;
        }
        if (button.name.equals("change")) {
            scroll = 0;
            ((WireRelayContainer)this.container).nextdeco();
            return true;
        }
        if (button.name.equals("reset")) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "reset_deco");
            compound.func_74778_a("type", WireRelayContainer.CURRDECO);
            compound.func_74782_a("wire", (NBTBase)((WireRelayContainer)this.container).wire.key.save(TagCW.create()).local());
            compound.func_74757_a("opp", ((WireRelayContainer)this.container).opp);
            ((WireRelayContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        if (button.name.startsWith("b")) {
            int index = Integer.parseInt(button.name.substring(1));
            if (index >= ((WireRelayContainer)this.container).models.size() || ((WireRelayContainer)this.container).models.size() == 0) {
                return true;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "select_deco");
            compound.func_74778_a("type", WireRelayContainer.CURRDECO);
            compound.func_74778_a("selected", ((WireRelayContainer)this.container).models.get(WireRelayContainer.CURRDECO).get(index + scroll).getIDS());
            compound.func_74782_a("wire", (NBTBase)((WireRelayContainer)this.container).wire.key.save(TagCW.create()).local());
            compound.func_74757_a("opp", ((WireRelayContainer)this.container).opp);
            ((WireRelayContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        if (button.name.equals("slack")) {
            float value = Float.parseFloat(((GenericGui.TextField)this.fields.get("slack")).func_146179_b());
            if (value > 2.0f) {
                value = 2.0f;
            }
            if (value < 0.0f) {
                value = 0.0f;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "set_slack");
            compound.func_74776_a("slack", value);
            compound.func_74782_a("wire", (NBTBase)((WireRelayContainer)this.container).wire.key.save(TagCW.create()).local());
            ((WireRelayContainer)this.container).send(Side.SERVER, compound);
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        if ((scroll += am > 0 ? 1 : -1) < 0) {
            scroll = 0;
        }
    }
}

