/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.wire;

import java.util.ArrayList;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.gui.wire.WireRelayContainer;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.minecraft.block.material.MapColor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class WireRelayChooser
extends GenericGui<WireRelayContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/wire_relays.png");
    private static GenericGui.BasicButton[] b0 = new GenericGui.BasicButton[8];
    private static GenericGui.BasicButton[] b1 = new GenericGui.BasicButton[8];
    private static GenericGui.BasicText[] t = new GenericGui.BasicText[8];
    private ArrayList<String> tooltip = new ArrayList();
    private static int scroll;
    private static boolean filter;
    private boolean filtered;
    private static ArrayList<String> conns;

    public WireRelayChooser(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new WireRelayContainer(player, world, x, y, z, true), player);
        ((WireRelayContainer)this.container).gui = this;
        this.defbackground = true;
        this.deftexrect = true;
        this.field_146999_f = 200;
        this.field_147000_g = 138;
    }

    protected void init() {
        this.buttons.put("filter", new GenericGui.BasicButton("filter", this.field_147003_i + 168, this.field_147009_r + 6, 168, 6, 8, 8, true));
        this.buttons.put("prev", new GenericGui.BasicButton("prev", this.field_147003_i + 177, this.field_147009_r + 6, 177, 6, 8, 8, true));
        this.buttons.put("next", new GenericGui.BasicButton("next", this.field_147003_i + 186, this.field_147009_r + 6, 186, 6, 8, 8, true));
        this.texts.put("title", new GenericGui.BasicText(this.field_147003_i + 7, this.field_147009_r + 6, 162, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "Wire Relay Management"));
        for (int i = 0; i < 8; ++i) {
            WireRelayChooser.b0[i] = new GenericGui.BasicButton("idx0" + i, this.field_147003_i + 167, this.field_147009_r + 17 + i * 14, 244, 244, 12, 12, true);
            this.buttons.put("idx0" + i, WireRelayChooser.b0[i]);
            WireRelayChooser.b1[i] = new GenericGui.BasicButton("idx1" + i, this.field_147003_i + 181, this.field_147009_r + 17 + i * 14, 244, 244, 12, 12, true);
            this.buttons.put("idx1" + i, WireRelayChooser.b1[i]);
            WireRelayChooser.t[i] = new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 19 + i * 14, 154, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "...");
            this.texts.put("idx" + i, WireRelayChooser.t[i]);
        }
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        if (!this.filtered) {
            this.filter();
        }
    }

    private void filter() {
        conns.clear();
        ArrayList<String> list = null;
        WireRelay relay = null;
        if (filter) {
            for (String str : ((WireRelayContainer)this.container).conns) {
                list = ((WireRelayContainer)this.container).data.types.get(str);
                if (!list.isEmpty() && !list.contains(((WireRelayContainer)this.container).type.getType())) continue;
                conns.add(str);
            }
        } else {
            conns.addAll(((WireRelayContainer)this.container).conns);
        }
        int l = 0;
        for (int i = 0; i < 8; ++i) {
            int j = i + scroll;
            if (j >= conns.size()) {
                WireRelayChooser.t[i].string = "";
                WireRelayChooser.b0[i].tx = 244;
                WireRelayChooser.b1[i].tx = 244;
                continue;
            }
            WireRelayChooser.t[i].string = conns.get(j);
            boolean pass = this.filtered;
            relay = ((WireRelayContainer)this.container).holder.get(conns.get(j));
            if (!pass) {
                list = ((WireRelayContainer)this.container).data.types.get(conns.get(j));
                boolean bl = pass = list.isEmpty() || list.contains(((WireRelayContainer)this.container).type.getType());
            }
            if (pass) {
                l = ((WireRelayContainer)this.container).data.limits.get(WireRelayChooser.t[i].string);
                if (relay.size() == 0) {
                    WireRelayChooser.b0[i].tx = 202;
                    WireRelayChooser.b1[i].tx = 216;
                    continue;
                }
                if (l == 0 || relay.size() < l) {
                    WireRelayChooser.b0[i].tx = 202;
                    WireRelayChooser.b1[i].tx = 230;
                    continue;
                }
                WireRelayChooser.b0[i].tx = 188;
                WireRelayChooser.b1[i].tx = 230;
                continue;
            }
            WireRelayChooser.b0[i].tx = 174;
            WireRelayChooser.b1[i].tx = relay.size() > 0 ? 230 : 216;
        }
        this.filtered = true;
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        for (int i = 0; i < 8; ++i) {
            if (WireRelayChooser.b0[i].tx > 174) continue;
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 17 + i * 14, 0, 244, 158, 12);
        }
    }

    protected void drawlast(float pticks, int mouseX, int mouseY) {
        this.tooltip.clear();
        for (int i = 0; i < 8; ++i) {
            if (WireRelayChooser.b0[i].hovered) {
                if (WireRelayChooser.b0[i].tx == 174) {
                    this.tooltip.add("invalid wire for this relay");
                } else if (WireRelayChooser.b0[i].tx == 188) {
                    this.tooltip.add("relay reached wire limit");
                } else {
                    this.tooltip.add("add wire to relay");
                }
            }
            if (!WireRelayChooser.b1[i].hovered) continue;
            this.tooltip.add("open wire relay editor");
            if (WireRelayChooser.b1[i].tx != 216) continue;
            this.tooltip.add("(relay has no wires connected)");
        }
        if (((GenericGui.BasicButton)this.buttons.get((Object)"filter")).hovered) {
            this.tooltip.add(Formatter.format((String)("filter: " + (filter ? "&aon" : "&coff"))));
        }
        if (this.tooltip.size() > 0) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("prev")) {
            if (--scroll < 0) {
                scroll = 0;
            }
            this.filtered = false;
        } else if (button.name.equals("next")) {
            ++scroll;
            this.filtered = false;
        } else {
            if (button.name.startsWith("idx0")) {
                if (button.tx == 188) {
                    Print.chat((ICommandSender)this.player, (String)"Relay reached wire limit.");
                } else if (button.tx == 174) {
                    Print.chat((ICommandSender)this.player, (String)"Wire not compatible with relay.");
                } else {
                    NBTTagCompound com = new NBTTagCompound();
                    com.func_74778_a("cargo", "connect");
                    com.func_74778_a("id", conns.get(Integer.parseInt(button.name.substring(4)) + scroll));
                    ((WireRelayContainer)this.container).send(Side.SERVER, com);
                }
                return true;
            }
            if (button.name.startsWith("idx1")) {
                int i = Integer.parseInt(button.name.substring(4)) + scroll;
                WireRelayContainer.SELRELAY = ((WireRelayContainer)this.container).conns.get(i);
                WireRelayContainer.WIRE = -1;
                NBTTagCompound com = new NBTTagCompound();
                com.func_74778_a("cargo", "open_editor");
                ((WireRelayContainer)this.container).send(Side.SERVER, com);
            } else if (button.name.equals("filter")) {
                filter = !filter;
                this.filtered = false;
            }
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        if ((scroll += am > 0 ? 1 : -1) < 0) {
            scroll = 0;
        }
        this.filtered = false;
    }

    static {
        conns = new ArrayList();
    }
}

