/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.wire;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.gui.rail.RailPlacer;
import net.fexcraft.mod.fvtm.gui.wire.WireRelayContainer;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class WireRelayEditor
extends GenericGui<WireRelayContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/wire_relay.png");
    private ArrayList<String> tooltip = new ArrayList();
    public static final float[][] WIRE_COLOR = new float[64][];
    public static final RGB[] WIRE_COLOR_RGB = new RGB[64];
    private static int GRIDSIZE;
    private static RGB[][] GRID;
    private static BlockPos[][] POSGRID;
    private static IBlockState[][] STATEGRID;
    private int scroll;

    public WireRelayEditor(EntityPlayer player, World world, int x, int y, int z) {
        super(texture, (GenericContainer)new WireRelayContainer(player, world, x, y, z, false), player);
        this.defbackground = true;
        this.deftexrect = true;
        ((WireRelayContainer)this.container).gui = this;
        this.field_146999_f = 248;
        this.field_147000_g = 187;
        GRID = null;
    }

    protected void init() {
        this.texts.put("title", new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 9, 205, Integer.valueOf(MapColor.field_151666_j.field_76291_p), ((WireRelayContainer)this.container).relay.getKey()));
        this.buttons.put("help", new GenericGui.BasicButton("help", this.field_147003_i + 216, this.field_147009_r + 7, 216, 7, 12, 12, true));
        this.buttons.put("copy", new GenericGui.BasicButton("copy", this.field_147003_i + 229, this.field_147009_r + 7, 229, 7, 12, 12, true));
        for (int i = 0; i < 6; ++i) {
            int j = i * 14;
            this.texts.put("wire" + i, new GenericGui.BasicText(this.field_147003_i + 12, this.field_147009_r + 96 + j, 211, Integer.valueOf(MapColor.field_151666_j.field_76291_p), ""));
            this.buttons.put("edit" + i, new GenericGui.BasicButton("edit" + i, this.field_147003_i + 226, this.field_147009_r + 94 + j, 226, 94 + j, 7, 12, true));
            this.buttons.put("del" + i, new GenericGui.BasicButton("del" + i, this.field_147003_i + 234, this.field_147009_r + 94 + j, 234, 94 + j, 7, 12, true));
            if (i >= 4) continue;
            this.texts.put("info" + i, new GenericGui.BasicText(this.field_147003_i + 75, this.field_147009_r + 28 + i * 14, 164, Integer.valueOf(MapColor.field_151666_j.field_76291_p), ""));
        }
        this.buttons.put("up", new GenericGui.BasicButton("up", this.field_147003_i + 193, this.field_147009_r + 88, 193, 88, 15, 5, true));
        this.buttons.put("dw", new GenericGui.BasicButton("dw", this.field_147003_i + 210, this.field_147009_r + 88, 210, 88, 15, 5, true));
        ((GenericGui.BasicText)this.texts.get((Object)"info0")).string = "Block: " + ((WireRelayContainer)this.container).tile.func_174877_v().func_177958_n() + ", " + ((WireRelayContainer)this.container).tile.func_174877_v().func_177956_o() + ", " + ((WireRelayContainer)this.container).tile.func_174877_v().func_177952_p();
        ((GenericGui.BasicText)this.texts.get((Object)"info1")).string = "Index: " + ((WireRelayContainer)this.container).conns.indexOf(WireRelayContainer.SELRELAY) + " / " + WireRelayContainer.SELRELAY;
    }

    private void initGrid() {
        GRID = new RGB[GRIDSIZE][GRIDSIZE];
        POSGRID = new BlockPos[GRIDSIZE][GRIDSIZE];
        STATEGRID = new IBlockState[GRIDSIZE][GRIDSIZE];
        BlockPos junc = ((WireRelayContainer)this.container).tile.func_174877_v();
        int half = GRIDSIZE / 2;
        for (int i = -half; i < half; ++i) {
            for (int j = -half; j < half; ++j) {
                BlockPos pos = RailPlacer.getPos(this.player.field_70170_p, i + junc.func_177958_n(), j + junc.func_177952_p());
                IBlockState state = this.player.field_70170_p.func_180495_p(pos);
                WireRelayEditor.POSGRID[i + half][j + half] = pos;
                WireRelayEditor.STATEGRID[i + half][j + half] = state;
            }
        }
        for (int i = 0; i < GRIDSIZE; ++i) {
            for (int j = 0; j < GRIDSIZE; ++j) {
                int m = 0;
                if (RailPlacer.isWater(STATEGRID[i][j].func_177230_c())) {
                    int d = 0;
                    for (int k = 0; k < 256 && RailPlacer.isWater(this.player.field_70170_p.func_180495_p(POSGRID[i][j].func_177979_c(k)).func_177230_c()); ++k) {
                        ++d;
                    }
                    m = d > 5 ? (d > 10 ? 0 : 1) : 2;
                } else {
                    m = 1;
                    if (this.player.field_70170_p.func_180495_p(POSGRID[i][j].func_177982_a(0, 1, -1)).func_185909_g((IBlockAccess)this.player.field_70170_p, POSGRID[i][j]) != MapColor.field_151660_b) {
                        --m;
                    }
                    if (this.player.field_70170_p.func_180495_p(POSGRID[i][j].func_177982_a(0, 0, -1)).func_185909_g((IBlockAccess)this.player.field_70170_p, POSGRID[i][j]) == MapColor.field_151660_b) {
                        ++m;
                    }
                }
                WireRelayEditor.GRID[i][j] = new RGB(STATEGRID[i][j].func_185909_g((IBlockAccess)this.player.field_70170_p, POSGRID[i][j]).func_151643_b(m));
            }
        }
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        if (GRID == null) {
            this.initGrid();
        }
        for (int i = 0; i < 6; ++i) {
            int j = i + this.scroll;
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"wire").append((int)i).toString())).string = j >= ((WireRelayContainer)this.container).relay.size() ? "" : ((WireRelayContainer)this.container).relay.wires.get((int)j).key.toString();
        }
        ((GenericGui.BasicText)this.texts.get((Object)"info2")).string = "Wires: " + ((WireRelayContainer)this.container).relay.size();
        ((GenericGui.BasicText)this.texts.get((Object)"info3")).string = "Section: w. in p.";
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        int j;
        int i;
        for (i = 0; i < 6; ++i) {
            j = i + this.scroll;
            if (j >= ((WireRelayContainer)this.container).relay.size()) continue;
            WIRE_COLOR_RGB[j].glColorApply();
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 95 + i * 14, 8, 95, 2, 10);
        }
        RGB.glColorReset();
        for (i = 0; i < GRIDSIZE; ++i) {
            for (j = 0; j < GRIDSIZE; ++j) {
                GRID[i][j].glColorApply();
                this.func_73729_b(this.field_147003_i + 7 + i * 2, this.field_147009_r + 21 + j * 2, 7, 21, 2, 2);
            }
        }
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)4.0f);
        for (i = 0; i < ((WireRelayContainer)this.container).relay.size(); ++i) {
            this.renderWire(((WireRelayContainer)this.container).relay.wires.get(i), WIRE_COLOR[i], ((WireRelayContainer)this.container).relay.getHolder().pos);
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void renderWire(Wire wire, float[] color, V3I junc) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (wire.vecpath.length == 2) {
            V3D vec0 = wire.vecpath[0];
            V3D vec1 = vec0.distance(wire.vecpath[1], 15.0);
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((vec0.x - (double)junc.x + 16.0) * 2.0 + (double)this.field_147003_i + 7.0, (vec0.z - (double)junc.z + 16.0) * 2.0 + (double)this.field_147009_r + 21.0, (double)(this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((vec1.x - (double)junc.x + 16.0) * 2.0 + (double)this.field_147003_i + 7.0, (vec1.z - (double)junc.z + 16.0) * 2.0 + (double)this.field_147009_r + 21.0, (double)(this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
            tessellator.func_78381_a();
            return;
        }
        for (int j = 0; j < wire.vecpath.length - 1; ++j) {
            V3D vec0 = wire.vecpath[j];
            V3D vec1 = wire.vecpath[j + 1];
            double x0 = vec0.x - (double)junc.x;
            double z0 = vec0.z - (double)junc.z;
            if (x0 < -16.0 || z0 < -16.0 || x0 > 16.0 || z0 > 16.0) continue;
            double x1 = vec1.x - (double)junc.x;
            double z1 = vec1.z - (double)junc.z;
            if (x1 < -16.0 || z1 < -16.0 || x1 > 16.0 || z1 > 16.0) continue;
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((x0 + 16.0) * 2.0 + (double)this.field_147003_i + 7.0, (z0 + 16.0) * 2.0 + (double)this.field_147009_r + 21.0, (double)(this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((x1 + 16.0) * 2.0 + (double)this.field_147003_i + 7.0, (z1 + 16.0) * 2.0 + (double)this.field_147009_r + 21.0, (double)(this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void drawlast(float pticks, int mouseX, int mouseY) {
        this.tooltip.clear();
        for (int i = 0; i < 6; ++i) {
            if (((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"edit").append((int)i).toString())).hovered) {
                this.tooltip.add(Formatter.format((String)"&eEdit this wire's appearance and function."));
            }
            if (!((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"del").append((int)i).toString())).hovered) continue;
            this.tooltip.add(Formatter.format((String)"&eRemove wire from relay."));
        }
        if (this.tooltip.size() > 0) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("copy")) {
            ((GenericGui.BasicText)this.texts.get((Object)"title")).string = "Position Copied to clipboard!";
            StringSelection selection = new StringSelection(WireKey.str(((WireRelayContainer)this.container).relay.getHolder().pos) + ":" + ((WireRelayContainer)this.container).relay.getKey());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            return true;
        }
        if (button.name.equals("help")) {
            WireRelayEditor parent = this;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "https://fexcraft.net/wiki/mod/fvtm/wire_relay", 31102009, true, (GuiScreen)parent){
                final /* synthetic */ GuiScreen val$parent;
                {
                    this.val$parent = guiScreen;
                    super(x0, x1, x2, x3);
                }

                public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
                    this.val$parent.func_73863_a(-1, -1, partialTicks);
                    super.func_73863_a(mouseX, mouseY, partialTicks);
                }
            });
            return true;
        }
        if (button.name.equals("up")) {
            --this.scroll;
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            return true;
        }
        if (button.name.equals("dw")) {
            ++this.scroll;
            return true;
        }
        int i = -1;
        try {
            i = Integer.parseInt(button.name.replace("del", "").replace("edit", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (button.name.startsWith("edit")) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "edit_wire");
            WireRelayContainer.WIRE = i + this.scroll;
            ((WireRelayContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        if (button.name.startsWith("del")) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "del_wire");
            compound.func_74768_a("index", i + this.scroll);
            compound.func_74778_a("relay", WireRelayContainer.SELRELAY);
            ((WireRelayContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        this.scroll += am > 0 ? 1 : -1;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }

    static {
        for (int i = 0; i < WIRE_COLOR.length; ++i) {
            WireRelayEditor.WIRE_COLOR_RGB[i] = RGB.random();
            WireRelayEditor.WIRE_COLOR[i] = WIRE_COLOR_RGB[i].toFloatArray();
        }
        GRIDSIZE = 32;
    }
}

