/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.registry.ItemBlock16;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.generated.PlainBase;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockItem
extends ItemBlock16
implements ContentItem.ContentDataItem<Block, BlockData>,
ItemTextureable.TextureableItem<Block> {
    @SideOnly(value=Side.CLIENT)
    private CreativeTabs ctab;
    private Block type;

    public BlockItem(net.minecraft.block.Block block) {
        super(block);
        this.type = ((PlainBase)block).type;
        this.func_77627_a(true);
        this.func_77625_d(this.type.getMaxStackSize());
        this.setRegistryName(block.getRegistryName());
        this.func_77655_b(block.func_149739_a());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.ctab = (CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.type);
        this.func_77637_a(this.ctab);
    }

    public BlockItem(Block block) {
        this((net.minecraft.block.Block)block.getBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        VehicleAndPartDataCache cache = (VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null);
        if (!cache.overridesLang(false)) {
            tooltip.add(Formatter.format((String)("&9Name: &7" + this.type.getName())));
        }
        for (String s : this.type.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        if (this.type.getBlockType().isGenericRoad()) {
            tooltip.add(Formatter.format((String)("&9Height: &7" + (stack.func_77960_j() == 0 ? 16 : stack.func_77960_j()))));
        } else if (this.type.getBlockType().getMetaVariants() > 0) {
            tooltip.add(Formatter.format((String)("&9Variant: &7" + stack.func_77960_j())));
        }
        BlockData data = cache.getBlockData();
        if (data == null) {
            return;
        }
        if (!((Block)data.getType()).hasPlainModel()) {
            tooltip.add(Formatter.format((String)("&9Texture: &7" + this.getTexTitle(data))));
        }
        if (!data.getFunctions().isEmpty()) {
            for (BlockFunction func : data.getFunctions()) {
                func.addInformation(UniStack.getStack((Object)stack), WrapperHolder.getWorld((Object)world), data, tooltip, flag.func_194127_a());
            }
            tooltip.add(Formatter.format((String)"&9- - - - - - &7-"));
        }
        if (this.type.getModel() == null) {
            return;
        }
        if (this.type.getModel().getCreators().size() > 0) {
            tooltip.add(Formatter.format((String)"&9Model by:"));
            for (String str : this.type.getModel().getCreators()) {
                tooltip.add(Formatter.format((String)("&7- " + str)));
            }
        }
    }

    private String getTexTitle(BlockData data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + ((Block)data.getType()).getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public BlockData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public BlockData getData(TagCW compound) {
        return new BlockData(this.type).read(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.type.shouldHideItem()) {
            return;
        }
        if (tab == CreativeTabs.field_78027_g || tab == this.ctab) {
            if (this.type.getBlockType().isGenericRoad()) {
                items.add((Object)new ItemStack((Item)this, 1, 0));
                items.add((Object)new ItemStack((Item)this, 1, 12));
                items.add((Object)new ItemStack((Item)this, 1, 8));
                items.add((Object)new ItemStack((Item)this, 1, 4));
                items.add((Object)new ItemStack((Item)this, 1, 2));
                items.add((Object)new ItemStack((Item)this, 1, 1));
            } else if (this.type.getBlockType().getMetaVariants() > 0) {
                for (int i = 0; i < this.type.getBlockType().getMetaVariants(); ++i) {
                    items.add((Object)new ItemStack((Item)this, 1, i));
                }
            } else {
                items.add(this.type.getNewStack().local());
            }
        }
    }

    public int getItemBurnTime(ItemStack stack) {
        return this.type.getItemBurnTime() * stack.func_190916_E();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.type.getBlockType().isMultiBlock()) {
            return EnumActionResult.PASS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public Block getContent() {
        return this.type;
    }

    @Override
    public ContentType getType() {
        return ContentType.BLOCK;
    }
}

