/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PartItem
extends Item
implements ContentItem.ContentDataItem<Part, PartData>,
ItemTextureable.TextureableItem<Part> {
    private Part part;

    public PartItem(Part content) {
        this.part = content;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setRegistryName(this.part.getID().colon());
        this.func_77655_b(this.part.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.part));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        VehicleAndPartDataCache cache = (VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null);
        if (!cache.overridesLang(false)) {
            tooltip.add(Formatter.format((String)("&9Name: &7" + this.part.getName())));
        }
        tooltip.add(Formatter.format((String)("&9Type: &7" + this.part.getCategory())));
        for (String s : this.part.getDescription()) {
            tooltip.add(Formatter.format((String)net.minecraft.client.resources.I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        PartData data = cache.getPartData();
        if (data == null) {
            return;
        }
        tooltip.add(Formatter.format((String)("&9Texture: &7" + this.getTexTitle(data))));
        if (this.part.getInstallHandlerData() != null && this.part.getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData) {
            DefaultPartInstallHandler.DPIHData idata = (DefaultPartInstallHandler.DPIHData)this.part.getInstallHandlerData();
            if (!idata.removable) {
                tooltip.add(Formatter.format((String)(idata.swappable ? "&c&oPermanent, &a&oSwappable" : "&c&oPermanent")));
            } else {
                tooltip.add(Formatter.format((String)(idata.swappable ? "&a&oSwappable" : "&e&oNot Swappable")));
            }
        }
        if (!data.getFunctions().isEmpty()) {
            StackWrapper wrapper = UniStack.getStack((Object)stack);
            for (PartFunction func : data.getFunctions().values()) {
                func.addInformation(wrapper, WrapperHolder.getWorld((Object)world), data, tooltip, flag.func_194127_a());
            }
            tooltip.add(Formatter.format((String)"&9- - - - - - &7-"));
        }
        if (this.part.getDefaultAttributes().size() > 0) {
            tooltip.add(Formatter.format((String)"&0&9This part has &7%s &9Attribute/s.", (Object[])new Object[]{this.part.getDefaultAttributes().size()}));
        }
        if (this.part.getStaticModifiers().size() > 0) {
            tooltip.add(Formatter.format((String)"&0&3This part has &7%s &3Modifier/s.", (Object[])new Object[]{this.part.getStaticModifiers().size()}));
        }
        if (this.part.getDefaultFunctions().size() > 0) {
            tooltip.add(Formatter.format((String)"&0&bThis part has &7%s &bFunction/s.", (Object[])new Object[]{this.part.getDefaultFunctions().size()}));
        }
        if (this.part.getModel() != null && this.part.getModel().getCreators().size() > 0) {
            tooltip.add(Formatter.format((String)"&9Model by:"));
            for (String str : this.part.getModel().getCreators()) {
                tooltip.add(Formatter.format((String)("&7- " + str)));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (!((VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null)).overridesLang(false)) {
            String langname = "item." + stack.func_77973_b().getRegistryName().toString() + ".name";
            if ((langname = I18n.func_74838_a((String)langname).trim()).length() > 0) {
                return langname;
            }
            ((VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null)).overridesLang(true);
        }
        return Formatter.format((String)this.part.getName());
    }

    private String getTexTitle(PartData data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + ((Part)data.getType()).getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public PartData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public PartData getData(TagCW compound) {
        return new PartData(this.part).read(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.part.getNewStack().local());
        }
    }

    @Override
    public Part getContent() {
        return this.part;
    }

    @Override
    public ContentType getType() {
        return ContentType.PART;
    }
}

