/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.api.registry.fItem;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.signal.SignalType;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@fItem(modid="fvtm", name="simple_signal")
public class SignalItem0
extends Item
implements JunctionGridItem {
    public static SignalItem0 INSTANCE;
    private static float[][] gridcolour;

    public SignalItem0() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        INSTANCE = this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Formatter.format((String)"&9Rightclick on a Junction to change Signal type."));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Junction junction;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        RailSystem syscap = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
        if (syscap == null) {
            Print.chat((ICommandSender)player, (String)"&cWorld Capability not found.");
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        QV3D vector = new QV3D((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((junction = syscap.getJunction(vector.pos, true)) == null) {
            return EnumActionResult.PASS;
        }
        EnumActionResult result = SignalItem0.onSignalUse(junction, player, player.func_70093_af());
        if (result == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return result;
    }

    public static EnumActionResult onSignalUse(Junction junction, EntityPlayer player, boolean remove) {
        if (remove) {
            junction.setSignal(null, null);
            Print.bar((EntityPlayer)player, (String)"&bJunction Signal &creset&b.");
            junction.checkTrackSectionConsistency();
            junction.pollSignal(null);
            return EnumActionResult.SUCCESS;
        }
        if (junction.signal != null) {
            if (junction.signal.type == SignalType.Kind.BLOCK) {
                EntryDirection dir = EntryDirection.FORWARD;
                if (junction.signal.oneway.booleanValue() && junction.signal_dir == EntryDirection.FORWARD) {
                    junction.setSignal(SignalType.ONE_WAY_BLOCK, EntryDirection.BACKWARD);
                    dir = EntryDirection.BACKWARD;
                } else if (junction.signal.oneway.booleanValue() && junction.signal_dir == EntryDirection.BACKWARD) {
                    junction.setSignal(SignalType.TWO_WAY_BLOCK, EntryDirection.BOTH);
                    dir = EntryDirection.BOTH;
                } else if (!junction.signal.oneway.booleanValue()) {
                    junction.setSignal(SignalType.ONE_WAY_BLOCK, EntryDirection.FORWARD);
                    dir = EntryDirection.FORWARD;
                } else {
                    Print.bar((EntityPlayer)player, (String)"A strange error happened, see location in log.");
                    Static.exception(null, (boolean)false);
                }
                junction.pollSignal(null);
                Print.bar((EntityPlayer)player, (String)("&bJunction Signal &aupdated&b. [" + dir.getSaveByte() + "/" + dir.name().toLowerCase() + "]"));
                return EnumActionResult.SUCCESS;
            }
            Print.bar((EntityPlayer)player, (String)"&cThis Junction has already a Signal.");
            return EnumActionResult.FAIL;
        }
        if (junction.size() != 2) {
            Print.bar((EntityPlayer)player, (String)"&cOnly Junctions with 2 Tracks can have Signals.");
            return EnumActionResult.FAIL;
        }
        junction.setSignal(SignalType.TWO_WAY_BLOCK, EntryDirection.BOTH);
        Print.chat((ICommandSender)player, (String)"&bJunction Signal &7set&b.");
        junction.checkTrackSectionConsistency();
        junction.pollSignal(null);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public float[][] getGridColours() {
        return gridcolour;
    }

    static {
        RGB cyan = new RGB(Color.CYAN.getRGB());
        gridcolour = new float[][]{cyan.toFloatArray(), cyan.toFloatArray()};
    }
}

