/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WireItem
extends Item
implements ContentItem<WireType>,
JunctionGridItem {
    private WireType wire;

    public WireItem(WireType type) {
        this.wire = type;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setRegistryName(this.wire.getID().colon());
        this.func_77655_b(this.wire.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.wire));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.wire.getName())));
        for (String s : this.wire.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)("&9Def. Slack: &7" + this.wire.getDefaultSlack())));
        tooltip.add(Formatter.format((String)("&9Customisable: &7" + this.wire.isCustomisable())));
        tooltip.add(Formatter.format((String)"&9- &6- &9- - - - &6-"));
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fvtm:wirepoint")) {
            tooltip.add(Formatter.format((String)("&9Block: &7" + stack.func_77978_p().func_74759_k("fvtm:wirepoint"))));
            tooltip.add(Formatter.format((String)("&9Relay: &7" + stack.func_77978_p().func_74779_i("fvtm:wirepoint_key"))));
        } else {
            tooltip.add("No Connection data.");
        }
        tooltip.add(Formatter.format((String)"&9- &6- &9- - - - &6-"));
        tooltip.add(Formatter.format((String)"&6Usage:"));
        tooltip.add(Formatter.format((String)"&b- Rightclick on a relay to select."));
        tooltip.add(Formatter.format((String)"&b- Rightclick 2 relays in sequence to create a wire. "));
        tooltip.add(Formatter.format((String)"&b- Rightclick + Sneak to reset point cache (sequence)."));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || Config.DISABLE_WIRES || hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)world));
        if (system == null) {
            Print.chat((ICommandSender)player, (String)"&cWire System not found. Is it enabled?");
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fvtm:wirepoint")) {
                stack.func_77978_p().func_82580_o("fvtm:wirepoint");
                stack.func_77978_p().func_82580_o("fvtm:wirepoint_key");
                UniEntity.getEntity((Object)player).send("interact.fvtm.relay.cache_reset");
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public WireType getContent() {
        return this.wire;
    }

    @Override
    public ContentType getType() {
        return ContentType.WIRE;
    }
}

