/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.ProgramUtils;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;

public class AnimationPrograms {
    public static void init() {
        ModelGroup.PROGRAMS.add(new AttrBoolAnimation(null, 0));
    }

    public static class AttrBoolAnimation
    extends AttrAnimation {
        public AttrBoolAnimation(String attr, int tt) {
            super(attr, tt);
        }

        @Override
        public String id() {
            return "fvtm:attribute_bool_animation";
        }

        @Override
        public void collectActive(ModelGroup group, ModelRenderData data) {
            this.passed = data.cache.get(this, ProgramUtils.FLOAT_BOOL_SUPP);
            if (this.attr.asBoolean() != this.passed.bl) {
                this.passed.bl = this.attr.asBoolean();
                for (Program program : this.progs.values()) {
                    program.reverse(data, this.passed.bl);
                }
            }
            if (this.passed.bl) {
                if (this.passed.fl > 0.0f) {
                    this.passed.fl -= data.partialticks;
                    if (this.passed.fl < 0.0f) {
                        this.passed.fl = 0.0f;
                    }
                }
            } else if (this.passed.fl < (float)this.time) {
                this.passed.fl += data.partialticks;
                if (this.passed.fl > (float)this.time) {
                    this.passed.fl = this.time;
                }
            }
            for (Map.Entry entry : this.progs.entrySet()) {
                if (this.passed.fl < (float)((V3I)entry.getKey()).x || this.passed.fl > (float)((V3I)entry.getKey()).y) continue;
                this.active.add(((Program)entry.getValue()).pause(data, this.passed.fl > (float)(((V3I)entry.getKey()).x + ((V3I)entry.getKey()).z)));
            }
        }

        @Override
        public Program parse(String[] args) {
            return new AttrBoolAnimation(args[0], Integer.parseInt(args[1]));
        }
    }

    public static abstract class AttrAnimation
    extends DefaultPrograms.AttributeBased
    implements AnimationRoot {
        protected HashMap<V3I, Program> progs = new HashMap();
        protected ArrayList<Program> active = new ArrayList();
        protected ProgramUtils.FloatBool passed;
        protected int time;

        public AttrAnimation(String attr, int tt) {
            super(attr);
            this.time = tt;
        }

        @Override
        public void addProgram(int offset, int dur, Program prog) {
            if (prog == null) {
                return;
            }
            if (dur <= 0) {
                dur = this.time;
            }
            this.progs.put(new V3I(offset, dur, prog.ticktime()), prog);
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.active.clear();
            this.collectActive(list, data);
            for (Program program : this.active) {
                program.pre(list, data);
            }
        }

        public void collectActive(ModelGroup group, ModelRenderData data) {
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || this.attr == null) {
                return;
            }
            for (Program program : this.active) {
                program.post(list, data);
            }
        }
    }

    public static interface AnimationRoot {
        public void addProgram(int var1, int var2, Program var3);
    }
}

