/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.util.HashMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandlerVar;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.GetWheelPos;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.ProgramUtils;
import net.fexcraft.mod.fvtm.model.RenderOrder;
import net.fexcraft.mod.fvtm.model.program.AnimationPrograms;
import net.fexcraft.mod.fvtm.model.program.BakedPrograms;
import net.fexcraft.mod.fvtm.model.program.BlockPrograms;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.model.program.OpenGlPrograms;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.Pos;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.opengl.GL11;

public class DefaultPrograms12
extends DefaultPrograms {
    public static boolean DIDLOAD = false;
    private static FontRenderer fr;
    public static final Program BOGIE_AXLE_WHEEL;
    public static final HashMap<String, RGBChannel> RGB_CHANNELS;
    public static final HashMap<String, DefaultPrograms.AlwaysGlow> CUSTOM_LIGHTS;
    private static boolean was_blended;
    private static boolean was_alpha;
    private static boolean was_alpha_tested;

    public static void init() {
        DefaultPrograms.init();
        GLOW = new Transparent(189.0f, 4.0f);
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:rgb_primary";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.color != null) {
                    data.color.getPrimaryColor().glColorApply();
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                RGB.glColorReset();
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:rgb_secondary";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.color != null) {
                    data.color.getSecondaryColor().glColorApply();
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                RGB.glColorReset();
            }
        });
        ModelGroup.PROGRAMS.add(new RGBCustom(0xFFFFFF));
        ModelGroup.PROGRAMS.add(new RGBChannel("custom"));
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:hide";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                list.visible = false;
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                list.visible = true;
            }
        });
        ModelGroup.PROGRAMS.add(new Window());
        ModelGroup.PROGRAMS.add(new WindowTinted());
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelTireData wtd;
            private WheelSlot slot;

            @Override
            public String id() {
                return "fvtm:wheel_auto_all";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)(-data.vehicle.getAttribute("steering_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        GL11.glRotatef((float)(-this.wtd.rotation), (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        GL11.glRotatef((float)this.wtd.rotation, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)data.vehicle.getAttribute("steering_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;

            @Override
            public String id() {
                return "fvtm:wheel_auto_steering";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)data.vehicle.getAttribute("steering_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)(-data.vehicle.getAttribute("steering_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;
            private WheelTireData wtd;

            @Override
            public String id() {
                return "fvtm:wheel_auto_all_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)(-data.vehicle.getAttribute("steering_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        GL11.glRotatef((float)this.wtd.rotation, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        GL11.glRotatef((float)(-this.wtd.rotation), (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)data.vehicle.getAttribute("steering_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;

            @Override
            public String id() {
                return "fvtm:wheel_auto_steering_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)(-data.vehicle.getAttribute("steering_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                if (this.slot != null && this.slot.steering) {
                    GL11.glRotatef((float)data.vehicle.getAttribute("steering_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.slot != null && this.slot.mirror) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        });
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 0.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheelCentered(0, 0.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(2, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(1, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(2, 1.0f, false));
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 1.0f, false));
        ModelGroup.PROGRAMS.add(new SteeringWheel(1, 1.0f, false));
        ModelGroup.PROGRAMS.add(new SteeringWheelCentered(2, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheelCentered(0, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheelCentered(1, 1.0f));
        ModelGroup.PROGRAMS.add(new DefaultPrograms.AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState() && data.vehicle.getAttribute("forward").asBoolean();
            }

            @Override
            public String id() {
                return "fvtm:lights_rail_forward";
            }
        });
        ModelGroup.PROGRAMS.add(new DefaultPrograms.AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState() && !data.vehicle.getAttribute("forward").asBoolean();
            }

            @Override
            public String id() {
                return "fvtm:lights_rail_backward";
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_auto";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)(-data.vehicle.getAttribute(data.part_category + "_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_auto_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)(-data.vehicle.getAttribute(data.part_category + "_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_front";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)data.vehicle.getAttribute("bogie_front_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)(-data.vehicle.getAttribute("bogie_front_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_rear";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)data.vehicle.getAttribute("bogie_rear_angle").asFloat(), (float)0.0f, (float)1.0f, (float)0.0f);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                GL11.glRotatef((float)(-data.vehicle.getAttribute("bogie_rear_angle").asFloat()), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        });
        ModelGroup.PROGRAMS.add(new Scale(1.0f));
        ModelGroup.PROGRAMS.add(new Scale3D(1.0f, 1.0f, 1.0f));
        ModelGroup.PROGRAMS.add(new Transparent(63.0f, 63.0f));
        ModelGroup.PROGRAMS.add(new AttributeRotator("", false, 0.0f, 0.0f, 0.0f, 0, Float.valueOf(0.0f)));
        ModelGroup.PROGRAMS.add(new AttributeTranslator("", false, 0.0f, 0.0f, 0.0f, 0));
        ModelGroup.PROGRAMS.add(new AttributeVisible("", false));
        ModelGroup.PROGRAMS.add(new Gauge("", 0, 0.0f, 0.0f, 0.0f, 0));
        ModelGroup.PROGRAMS.add(new RotationSetter(0, 0.0f, 0.0f, false));
        ModelGroup.PROGRAMS.add(new TranslationSetter(0.0f, 0.0f, 0.0f, 0.0f));
        ModelGroup.PROGRAMS.add(new TextureBinder("minecraft:textures/blocks/stone.png"));
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bind_selected_texture";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                TexUtil.bindTexture(data.texture.getCurrentTexture());
            }

            @Override
            public boolean post() {
                return false;
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bind_block_4x4rot_texture";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.texture == null || data.tile == null) {
                    return;
                }
                TexUtil.bindTexture(data.texture.getTexHolder().getDefaultTextures().get(((TileEntity)data.tile).func_145832_p() / 4));
            }

            @Override
            public boolean post() {
                return false;
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bind_block_variant_texture";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                TexUtil.bindTexture(data.texture.getTexHolder().getDefaultTextures().get(((TileEntity)data.tile).func_145832_p()));
            }

            @Override
            public boolean post() {
                return false;
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:rescale_normal";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                GL11.glEnable((int)32826);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                GL11.glDisable((int)32826);
            }
        });
        ModelGroup.PROGRAMS.add(new TextRenderer(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, true));
        ModelGroup.PROGRAMS.add(new AttributeTextRenderer("", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, true));
        ModelGroup.PROGRAMS.add(new Rotator(0.0f, 0.0f, 0.0f, 0, null, false, false));
        ModelGroup.PROGRAMS.add(new Translator(0.0f, 0.0f, 0.0f, 0, false));
        ModelGroup.PROGRAMS.add(new DisplayBarrel());
        ModelGroup.PROGRAMS.add(new RenderOrderSetter(null));
        ModelGroup.PROGRAMS.add(new RotateTo());
        ModelGroup.PROGRAMS.add(new TranslateTo());
        ModelGroup.PROGRAMS.add(new SignText());
        AnimationPrograms.init();
        OpenGlPrograms.init();
        BlockPrograms.init();
        BakedPrograms.init();
        DefaultPrograms.LightBeam.LBR = new DefaultPrograms.LightBeam.LBRender(){

            @Override
            public void pre(DefaultPrograms.LightBeam beam, ModelGroup list, ModelRenderData data) {
                TexUtil.bindTexture(EffectRenderer.LIGHT_TEXTURE);
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3008);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA);
                GL11.glPushMatrix();
                if (beam.swivel == null || beam.swivel.equals("vehicle")) {
                    Renderer.RENDERER.translate(beam.pos);
                } else {
                    SwivelPoint point = data.vehicle.getRotationPoint(beam.swivel);
                    V3D pos = point.getRelativeVector(beam.pos);
                    GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)-180.0, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }

            @Override
            public void post(DefaultPrograms.LightBeam beam, ModelGroup list, ModelRenderData data) {
                GL11.glPopMatrix();
                GL11.glDisable((int)3008);
                GL11.glDepthMask((boolean)true);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GL11.glDisable((int)3042);
            }
        };
        DIDLOAD = true;
    }

    public static RGBChannel getRGBChannel(String channel_id) {
        if (RGB_CHANNELS.containsKey(channel_id)) {
            return RGB_CHANNELS.get(channel_id);
        }
        RGBChannel channel = new RGBChannel(channel_id);
        RGB_CHANNELS.put(channel_id, channel);
        return channel;
    }

    public static DefaultPrograms.AlwaysGlow getCustomLights(final String attr_id) {
        if (CUSTOM_LIGHTS.containsKey(attr_id)) {
            return CUSTOM_LIGHTS.get(attr_id);
        }
        DefaultPrograms.AlwaysGlow glow = new DefaultPrograms.AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getAttribute(attr_id).asBoolean();
            }
        };
        CUSTOM_LIGHTS.put(attr_id, glow);
        return glow;
    }

    public static void enableBlend() {
        was_blended = GL11.glGetBoolean((int)3042);
        if (!was_blended) {
            GL11.glEnable((int)3042);
        }
    }

    public static void disableBlend() {
        if (!was_blended) {
            GL11.glDisable((int)3042);
        }
    }

    public static void enableAlpha() {
        was_alpha = GL11.glGetBoolean((int)3008);
        if (!was_alpha) {
            GL11.glEnable((int)3008);
        }
    }

    public static void disableAlpha() {
        if (!was_alpha) {
            GL11.glDisable((int)3008);
        }
    }

    public static void disableAlphaTest() {
        was_alpha_tested = GL11.glGetBoolean((int)3008);
        if (!was_alpha_tested) {
            GL11.glDisable((int)3008);
        }
    }

    public static void enableAlphaTest() {
        if (!was_alpha_tested) {
            GL11.glEnable((int)3008);
        }
    }

    static {
        BOGIE_AXLE_WHEEL = new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_axle_wheel";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
            }
        };
        RGB_CHANNELS = new HashMap();
        CUSTOM_LIGHTS = new HashMap();
    }

    public static class SignText
    implements Program {
        @Override
        public String id() {
            return "fvtm:sign_text";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.sign == null || data.sign.text == null || data.sign.text.length() == 0) {
                return;
            }
            if (fr == null) {
                fr = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            fr.func_78276_b(data.sign.text, data.sign.centered ? -fr.func_78256_a(data.sign.text) / 2 : 0, 0, data.sign.getColorChannel((String)"text").packed - 0x1000000);
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return this;
        }
    }

    public static class TranslateTo
    implements Program {
        private float fx;
        private float fy;
        private float fz;
        private float tx;
        private float ty;
        private float tz;
        private ProgramUtils.FloatBool2 progress;
        private float mul;
        private int time;

        @Override
        public String id() {
            return "fvtm:translate";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glPushMatrix();
            this.progress = data.cache.get(this, ProgramUtils.FLOAT_BOOL2_SUPP);
            if (!this.progress.bl1) {
                if (this.progress.bl0) {
                    this.progress.fl -= data.partialticks;
                    if (this.progress.fl < 0.0f) {
                        this.progress.fl = 0.0f;
                    }
                } else {
                    this.progress.fl += data.partialticks;
                    if (this.progress.fl > (float)this.time) {
                        this.progress.fl = this.time;
                    }
                }
            }
            this.mul = this.progress.fl / (float)this.time;
            GL11.glTranslatef((float)(this.fx + (this.tx - this.fx) * this.mul), (float)(this.fy + (this.ty - this.fy) * this.mul), (float)(this.fz + (this.tz - this.fz) * this.mul));
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            GL11.glPopMatrix();
        }

        @Override
        public void reverse(ModelRenderData data, boolean bool) {
            this.progress = data.cache.get(this, ProgramUtils.FLOAT_BOOL2_SUPP);
            this.progress.bl0 = bool;
        }

        @Override
        public Program pause(ModelRenderData data, boolean pause) {
            data.cache.get((Program)this, ProgramUtils.FLOAT_BOOL2_SUPP).bl1 = pause;
            return this;
        }

        @Override
        public Program parse(String[] args) {
            TranslateTo trs = new TranslateTo();
            trs.fx = Float.parseFloat(args[0]);
            trs.fy = Float.parseFloat(args[1]);
            trs.fz = Float.parseFloat(args[2]);
            trs.tx = Float.parseFloat(args[3]);
            trs.ty = Float.parseFloat(args[4]);
            trs.tz = Float.parseFloat(args[5]);
            trs.time = Integer.parseInt(args[6]);
            return trs;
        }

        @Override
        public int ticktime() {
            return this.time;
        }
    }

    public static class RotateTo
    implements Program {
        private float from;
        private float to;
        private float def;
        private float mul;
        private int time;
        private int axis;
        private boolean or;
        private ProgramUtils.FloatBool2 progress;

        @Override
        public String id() {
            return "fvtm:rotate";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.progress = data.cache.get(this, ProgramUtils.FLOAT_BOOL2_SUPP);
            if (!this.progress.bl1) {
                if (this.progress.bl0) {
                    this.progress.fl -= data.partialticks;
                    if (this.progress.fl < 0.0f) {
                        this.progress.fl = 0.0f;
                    }
                } else {
                    this.progress.fl += data.partialticks;
                    if (this.progress.fl > (float)this.time) {
                        this.progress.fl = this.time;
                    }
                }
            }
            this.mul = this.progress.fl / (float)this.time;
            this.mul = this.from + (this.to - this.from) * this.mul;
            list.rotate(this.mul + this.def, this.axis, this.or);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            list.rotate(this.or ? this.def : -this.mul + this.def, this.axis, this.or);
        }

        @Override
        public Program parse(String[] args) {
            RotateTo rot = new RotateTo();
            rot.axis = Integer.parseInt(args[0]);
            rot.from = Float.parseFloat(args[1]);
            rot.to = Float.parseFloat(args[2]);
            rot.time = Integer.parseInt(args[3]);
            rot.def = args.length > 4 ? Float.parseFloat(args[4]) : 0.0f;
            rot.or = args.length > 5 && Boolean.parseBoolean(args[5]);
            return rot;
        }

        @Override
        public void reverse(ModelRenderData data, boolean bool) {
            this.progress = data.cache.get(this, ProgramUtils.FLOAT_BOOL2_SUPP);
            this.progress.bl0 = bool;
        }

        @Override
        public Program pause(ModelRenderData data, boolean pause) {
            data.cache.get((Program)this, ProgramUtils.FLOAT_BOOL2_SUPP).bl1 = pause;
            return this;
        }

        @Override
        public int ticktime() {
            return this.time;
        }
    }

    public static class RenderOrderSetter
    implements Program {
        private HashMap<RenderOrder, RenderOrderSetter> map = new HashMap();
        private RenderOrder order;

        private RenderOrderSetter(RenderOrder ord) {
            if (ord == null) {
                ord = RenderOrder.NORMAL;
                this.map.put(ord, this);
                this.map.put(RenderOrder.BLENDED, new RenderOrderSetter(RenderOrder.BLENDED));
                this.map.put(RenderOrder.LAST, new RenderOrderSetter(RenderOrder.LAST));
                this.map.put(RenderOrder.SEPARATE, new RenderOrderSetter(RenderOrder.SEPARATE));
            }
            this.order = this.order;
        }

        @Override
        public String id() {
            return "fvtm:render_order";
        }

        @Override
        public Program parse(String[] args) {
            return this.map.get((Object)RenderOrder.valueOf(args[0].toUpperCase()));
        }
    }

    public static class DisplayBarrel
    implements Program {
        private String inv;
        private int index;
        private Pos pos;
        private BlockData bdata;
        private BlockData odata;
        private InvHandlerVar var;
        private Model model;

        public DisplayBarrel() {
            this.pos = new Pos(0.0f, 0.0f, 0.0f);
            this.index = 0;
        }

        public DisplayBarrel(String inv, int idx, float x, float y, float z) {
            this.pos = new Pos(x, y, z);
            this.inv = inv;
            this.index = idx;
        }

        @Override
        public String id() {
            return "fvtm:display_barrel";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.tile == null) {
                return;
            }
            this.var = (InvHandlerVar)((MultiblockTileEntity)data.tile).getMultiBlockData().getInventory(this.inv);
            if (this.var == null || this.var.stackAt(this.index).empty()) {
                return;
            }
            this.bdata = ((VehicleAndPartDataCache)((ItemStack)this.var.stackAt(this.index).direct()).getCapability(Capabilities.VAPDATA, null)).getBlockData();
            if (((Block)this.bdata.getType()).getModel() == null) {
                return;
            }
            this.pos.translate();
            TexUtil.bindTexture(this.bdata.getTexture().getTexture());
            this.odata = data.block;
            data.block = this.bdata;
            data.color = this.bdata;
            ((Block)this.bdata.getType()).getModel().render(data);
            this.pos.translateR();
            data.block = this.odata;
            data.color = this.odata;
            TexUtil.bindTexture(data.block.getTexture().getTexture());
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return new DisplayBarrel(args[0], Integer.parseInt(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]));
        }
    }

    public static class Translator
    extends Duplicable {
        private boolean loop;
        private float min;
        private float max;
        private float step;
        private Float[] cd;
        private int axis;

        public Translator(float min, float max, float step, int axis, boolean loop) {
            this.axis = axis;
            this.step = step;
            this.min = min;
            this.max = max;
            this.loop = loop;
        }

        @Override
        public String id() {
            return "fvtm:translator";
        }

        @Override
        public void init(ModelGroup list) {
            super.init(list);
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.cd = data.cache.get(this, ProgramUtils.FLOAT2_SUPP);
            if (this.cd[1].floatValue() == 0.0f) {
                this.cd[1] = Float.valueOf(this.step);
            }
            Float[] floatArray = this.cd;
            Float.valueOf(floatArray[0].floatValue() + this.cd[1].floatValue());
            if (this.cd[0].floatValue() > this.max) {
                if (this.loop) {
                    this.cd[0] = Float.valueOf(this.min + (this.cd[0].floatValue() - this.max));
                    this.cd[1] = Float.valueOf(this.step);
                } else {
                    this.cd[0] = Float.valueOf(this.max - (this.cd[0].floatValue() - this.max));
                    this.cd[1] = Float.valueOf(-this.step);
                }
            }
            if (this.cd[0].floatValue() < this.min) {
                if (this.loop) {
                    this.cd[0] = Float.valueOf(this.max + (this.cd[0].floatValue() - this.min));
                    this.cd[1] = Float.valueOf(this.step);
                } else {
                    this.cd[0] = Float.valueOf(this.min - (this.cd[0].floatValue() - this.min));
                    this.cd[1] = Float.valueOf(-this.step);
                }
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.cd[0].floatValue() * 0.0625f : 0.0f), (float)(this.axis == 1 ? this.cd[0].floatValue() * 0.0625f : 0.0f), (float)(this.axis == 2 ? this.cd[0].floatValue() * 0.0625f : 0.0f));
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.cd[0].floatValue() * -0.0625f : 0.0f), (float)(this.axis == 1 ? this.cd[0].floatValue() * -0.0625f : 0.0f), (float)(this.axis == 2 ? this.cd[0].floatValue() * -0.0625f : 0.0f));
        }

        @Override
        public Program parse(String[] args) {
            float min = Float.parseFloat(args[0]);
            float max = Float.parseFloat(args[1]);
            float step = Float.parseFloat(args[2]);
            int axis = Integer.parseInt(args[3]);
            boolean loop = Boolean.parseBoolean(args[4]);
            return new Translator(min, max, step, axis, loop);
        }
    }

    public static class Rotator
    extends Duplicable {
        private float min;
        private float max;
        private float step = 1.0f;
        private float defrot;
        private Float[] cd;
        private int axis;
        private boolean loop;
        private boolean override;

        public Rotator(float mn, float mx, float step, int axis, Float defrot, boolean loop, boolean ntadd) {
            this.min = mn;
            this.max = mx;
            this.step = step;
            this.axis = axis;
            float f = this.defrot = defrot == null ? 0.0f : defrot.floatValue();
            if (this.min == this.max || this.min == 0.0f && this.max == 0.0f) {
                this.min = -180.0f;
                this.max = 180.0f;
            }
            this.loop = loop;
            this.override = ntadd;
        }

        @Override
        public String id() {
            return "fvtm:rotator";
        }

        @Override
        public void init(ModelGroup list) {
            super.init(list);
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.cd = data.cache.get(this, ProgramUtils.FLOAT2_SUPP);
            if (this.cd[1].floatValue() == 0.0f) {
                this.cd[1] = Float.valueOf(this.step);
            }
            Float[] floatArray = this.cd;
            Float.valueOf(floatArray[0].floatValue() + this.cd[1].floatValue());
            if (this.cd[0].floatValue() > this.max) {
                if (this.loop) {
                    this.cd[0] = Float.valueOf(this.min + (this.cd[0].floatValue() - this.max));
                    this.cd[1] = Float.valueOf(this.step);
                } else {
                    this.cd[0] = Float.valueOf(this.max - (this.cd[0].floatValue() - this.max));
                    this.cd[1] = Float.valueOf(-this.step);
                }
            }
            if (this.cd[0].floatValue() < this.min) {
                if (this.loop) {
                    this.cd[0] = Float.valueOf(this.max + (this.cd[0].floatValue() - this.min));
                    this.cd[1] = Float.valueOf(this.step);
                } else {
                    this.cd[0] = Float.valueOf(this.min - (this.cd[0].floatValue() - this.min));
                    this.cd[1] = Float.valueOf(-this.step);
                }
            }
            list.rotate(this.cd[0].floatValue() + this.defrot, this.axis, this.override);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            list.rotate(this.override ? this.defrot : -(this.cd[0].floatValue() + this.defrot), this.axis, this.override);
        }

        @Override
        public Program parse(String[] args) {
            float min = Float.parseFloat(args[0]);
            float max = Float.parseFloat(args[1]);
            float step = Float.parseFloat(args[2]);
            int axis = Integer.parseInt(args[3]);
            float dero = Float.parseFloat(args[4]);
            boolean loop = Boolean.parseBoolean(args[5]);
            boolean noad = args.length > 6 ? Boolean.parseBoolean(args[6]) : true;
            return new Rotator(min, max, step, axis, Float.valueOf(dero), loop, noad);
        }
    }

    public static abstract class Duplicable
    implements Program {
        @Override
        public void init(ModelGroup list) {
        }
    }

    public static class AttributeTextRenderer
    extends TextRenderer {
        protected Attribute<?> attr;
        protected String attribute;

        public AttributeTextRenderer(String attribute, float x, float y, float z, float rx, float ry, float rz, float scale, boolean centered) {
            super(x, y, z, rx, ry, rz, scale, centered);
            this.attribute = attribute;
        }

        @Override
        public String id() {
            return "fvtm:attr_text_renderer";
        }

        @Override
        public boolean pre() {
            return true;
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.text = this.attr.asString();
        }

        @Override
        public Program parse(String[] args) {
            float px = args.length > 0 ? Float.parseFloat(args[0]) : 0.0f;
            float py = args.length > 1 ? Float.parseFloat(args[1]) : 0.0f;
            float pz = args.length > 2 ? Float.parseFloat(args[2]) : 0.0f;
            float rx = args.length > 3 ? Float.parseFloat(args[3]) : 0.0f;
            float ry = args.length > 4 ? Float.parseFloat(args[4]) : 0.0f;
            float rz = args.length > 5 ? Float.parseFloat(args[5]) : 0.0f;
            float scale = args.length > 6 ? Float.parseFloat(args[6]) : 4.0f;
            boolean cen = args.length > 7 ? Boolean.parseBoolean(args[7]) : true;
            String attr = args.length > 8 && !args[8].equals("null") ? args[8] : "";
            int color = args.length > 9 ? new RGB((String)args[9]).packed : RGB.BLACK.packed;
            boolean glow = args.length > 10 ? Boolean.parseBoolean(args[10]) : false;
            return new AttributeTextRenderer(attr, px, py, pz, rx, ry, rz, scale, cen).setColor(color).setGlow(glow);
        }
    }

    public static class TextRenderer
    extends Transparent {
        protected static Attribute<?> attr;
        protected FontRenderer font_renderer;
        protected float downscale_font = 0.00390625f;
        protected float rx;
        protected float ry;
        protected float rz;
        protected float scale;
        protected boolean glow;
        protected boolean no_depth_test;
        protected boolean centered;
        protected String text = "";
        protected String attrid;
        protected int color;
        protected int lx;
        protected int ly;
        protected Pos pos;

        public TextRenderer(float x, float y, float z, float rx, float ry, float rz, float scale, boolean centered) {
            super(189.0f, 4.0f);
            this.color = RGB.BLACK.packed;
            this.centered = centered;
            this.scale = scale;
            this.rx = rx;
            this.ry = ry;
            this.rz = rz;
            this.pos = new Pos(-x, y, z);
        }

        public TextRenderer(float x, float y, float z, float rx, float ry, float rz, float scale, boolean centered, String string) {
            this(x, y, z, rx, ry, rz, scale, centered);
            this.text = string;
        }

        public TextRenderer setFontRenderer(FontRenderer renderer) {
            this.font_renderer = renderer;
            return this;
        }

        public TextRenderer disableDepthTest(boolean bool) {
            this.no_depth_test = bool;
            return this;
        }

        public TextRenderer setColor(RGB rgb) {
            this.color = rgb.packed;
            return this;
        }

        public TextRenderer setColor(int color) {
            this.color = color;
            return this;
        }

        public TextRenderer setGlow(boolean bool) {
            this.glow = bool;
            return this;
        }

        public TextRenderer glow() {
            this.glow = true;
            return this;
        }

        public TextRenderer setLightAttribute(String string) {
            this.attrid = string;
            return this;
        }

        @Override
        public String id() {
            return "fvtm:text_renderer";
        }

        @Override
        public boolean pre() {
            return false;
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (this.text.length() == 0) {
                return;
            }
            if (this.font_renderer == null) {
                this.font_renderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            }
            if (this.font_renderer == null) {
                return;
            }
            GlStateManager.func_179094_E();
            if (this.glow || this.attrid != null && this.attr(data.vehicle)) {
                super.pre(list, data);
            }
            this.pos.translate();
            RGB.WHITE.glColorApply();
            GL11.glScalef((float)this.downscale_font, (float)this.downscale_font, (float)this.downscale_font);
            if (this.scale != 1.0f) {
                GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.ry != 0.0f) {
                GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rz != 0.0f) {
                GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rx != 0.0f) {
                GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179132_a((boolean)false);
            if (this.no_depth_test) {
                GL11.glDisable((int)2929);
            }
            this.font_renderer.func_78276_b(this.text, this.centered ? -this.font_renderer.func_78256_a(this.text) / 2 : 0, 0, this.color);
            if (this.no_depth_test) {
                GL11.glEnable((int)2929);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.glow || this.attrid != null && this.attr(data.vehicle)) {
                super.post(list, data);
            }
            GlStateManager.func_179121_F();
        }

        protected boolean attr(VehicleData data) {
            attr = data.getAttribute(this.attrid);
            return attr != null && attr.asBoolean();
        }

        @Override
        public Program parse(String[] args) {
            float px = args.length > 0 ? Float.parseFloat(args[0]) : 0.0f;
            float py = args.length > 1 ? Float.parseFloat(args[1]) : 0.0f;
            float pz = args.length > 2 ? Float.parseFloat(args[2]) : 0.0f;
            float rx = args.length > 3 ? Float.parseFloat(args[3]) : 0.0f;
            float ry = args.length > 4 ? Float.parseFloat(args[4]) : 0.0f;
            float rz = args.length > 5 ? Float.parseFloat(args[5]) : 0.0f;
            float scale = args.length > 6 ? Float.parseFloat(args[6]) : 4.0f;
            boolean cen = args.length > 7 ? Boolean.parseBoolean(args[7]) : true;
            String text = args.length > 8 && !args[8].equals("null") ? args[8] : "";
            int color = args.length > 9 ? new RGB((String)args[9]).packed : RGB.BLACK.packed;
            boolean glow = args.length > 10 ? Boolean.parseBoolean(args[10]) : false;
            return new TextRenderer(px, py, pz, rx, ry, rz, scale, cen, text).setColor(color).setGlow(glow);
        }
    }

    public static class TextureBinder
    implements Program {
        private ResourceLocation resloc;

        public TextureBinder(String rs) {
            this.resloc = new ResourceLocation(rs);
        }

        public TextureBinder(ResourceLocation rs) {
            this.resloc = rs;
        }

        @Override
        public String id() {
            return "fvtm:bind_texture";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            TexUtil.bindTexture(this.resloc);
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            return new TextureBinder(args[0]);
        }
    }

    public static class TranslationSetter
    implements Program {
        private float x;
        private float y;
        private float z;

        public TranslationSetter(float x, float y, float z) {
            this(x, y, z, 0.0625f);
        }

        public TranslationSetter(float x, float y, float z, float scale) {
            this.x = x * scale;
            this.y = y * scale;
            this.z = z * scale;
        }

        @Override
        public String id() {
            return "fvtm:translation_setter";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            GL11.glPopMatrix();
        }

        @Override
        public Program parse(String[] args) {
            float x = Float.parseFloat(args[0]);
            float y = Float.parseFloat(args[1]);
            float z = Float.parseFloat(args[2]);
            float s = args.length > 3 ? Float.parseFloat(args[3]) : 0.0625f;
            return new TranslationSetter(x, y, z, s);
        }
    }

    public static class RotationSetter
    implements Program {
        private Float defrot;
        private int axis;
        private boolean override;
        private float rot;

        public RotationSetter(int axis, float rot_by, float def_rot, boolean set) {
            this.override = set;
            this.axis = axis;
            this.defrot = Float.valueOf(def_rot);
            this.rot = rot_by;
        }

        @Override
        public String id() {
            return "fvtm:rotation_setter";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            list.rotate(this.rot + this.defrot.floatValue(), this.axis, this.override);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.rotate(this.override ? this.defrot.floatValue() : -(this.rot + this.defrot.floatValue()), this.axis, this.override);
        }

        @Override
        public Program parse(String[] args) {
            int axis = Integer.parseInt(args[0]);
            float to = Float.parseFloat(args[1]);
            float def = Float.parseFloat(args[2]);
            boolean set = Boolean.parseBoolean(args[3]);
            return new RotationSetter(axis, def, to, set);
        }
    }

    public static enum GaugeLimit {
        RPM{

            @Override
            public float getMaxValue(float maxval, Entity ent, VehicleData data) {
                part = data.getPart("engine");
                if (part == null) {
                    return maxval;
                }
                func = (EngineFunction)part.getFunction("fvtm:engine");
                if (func == null) {
                    return maxval;
                }
                return func.maxRPM();
            }
        };

        private static PartData part;
        private static EngineFunction func;

        public abstract float getMaxValue(float var1, Entity var2, VehicleData var3);

        static boolean parseable(String string) {
            for (GaugeLimit limit : GaugeLimit.values()) {
                if (!string.equals(limit.name())) continue;
                return true;
            }
            return false;
        }
    }

    public static class Gauge
    implements Program {
        private byte axis;
        private float minrot;
        private float maxrot;
        private float minval;
        private float maxval;
        private String attribute;
        private String maxvalattr;
        private Attribute<?> attr;
        private Attribute<?> mvattr;
        private float current;
        private float rotdiff;
        private float valdiff;
        private GaugeLimit limit;

        public <V> Gauge(String attribute, int axis, float min_rot, float max_rot, float min_value, V max_value) {
            this.attribute = attribute;
            this.axis = (byte)axis;
            this.minrot = min_rot;
            this.maxrot = max_rot;
            this.minval = min_value;
            if (max_value instanceof GaugeLimit) {
                this.limit = (GaugeLimit)((Object)max_value);
                this.maxval = min_value * 2.0f;
            } else if (max_value instanceof String) {
                this.maxvalattr = (String)max_value;
                this.maxval = min_value * 2.0f;
            } else {
                this.maxval = ((Number)max_value).floatValue();
            }
            this.rotdiff = this.maxrot - this.minrot;
            this.valdiff = this.maxval - this.minval;
        }

        @Override
        public String id() {
            return "fvtm:gauge";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            float f = this.current = this.attr.asFloat() < this.minval ? this.minval : this.attr.asFloat();
            if (this.current > this.maxval((Entity)data.entity, data.vehicle)) {
                this.current = this.maxval;
            }
            list.rotate(this.minrot + (this.current - this.minval) / this.valdiff() * this.rotdiff, this.axis, true);
        }

        private float maxval(Entity ent, VehicleData data) {
            if (this.maxvalattr != null && (this.mvattr = data.getAttribute(this.maxvalattr)) != null) {
                this.maxval = this.mvattr.asFloat();
                return this.maxval;
            }
            if (this.limit != null) {
                this.maxval = this.limit.getMaxValue(this.maxval, ent, data);
                return this.maxval;
            }
            return this.maxval;
        }

        private float valdiff() {
            if (this.maxvalattr != null || this.limit != null) {
                this.valdiff = this.maxval - this.minval;
                return this.valdiff;
            }
            return this.valdiff;
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.rotate(0.0f, this.axis, true);
        }

        @Override
        public Program parse(String[] args) {
            int axis = args.length < 2 ? 0 : Integer.parseInt(args[1]);
            float minr = args.length < 3 ? 0.0f : Float.parseFloat(args[2]);
            float maxr = args.length < 4 ? 0.0f : Float.parseFloat(args[3]);
            float minv = args.length < 5 ? 0.0f : Float.parseFloat(args[4]);
            Object maxv = 0;
            if (args.length > 5) {
                maxv = NumberUtils.isCreatable((String)args[5]) ? Float.valueOf(Float.parseFloat(args[5])) : (GaugeLimit.parseable(args[5]) ? GaugeLimit.valueOf(args[5]) : args[5]);
            }
            return new Gauge(args[0], axis, minr, maxr, minv, maxv);
        }
    }

    public static class Scale3D
    implements Program {
        private float x;
        private float y;
        private float z;

        public Scale3D(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public String id() {
            return "fvtm:scale_3d";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            GL11.glPopMatrix();
        }

        @Override
        public Program parse(String[] args) {
            return new Scale3D(args.length > 0 ? Float.parseFloat(args[0]) : 1.0f, args.length > 1 ? Float.parseFloat(args[1]) : 1.0f, args.length > 2 ? Float.parseFloat(args[2]) : 1.0f);
        }
    }

    public static class Scale
    implements Program {
        private float scale;

        public Scale(float scale) {
            this.scale = scale;
        }

        @Override
        public String id() {
            return "fvtm:scale";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            GL11.glPopMatrix();
        }

        @Override
        public Program parse(String[] args) {
            return new Scale(Float.parseFloat(args[0]));
        }
    }

    public static class Transparent
    implements Program {
        protected float lx;
        protected float ly;
        protected float x;
        protected float y;

        public Transparent(float mapx, float mapy) {
            this.x = mapx;
            this.y = mapy;
        }

        @Override
        public String id() {
            return "fvtm:transparent";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            DefaultPrograms12.enableBlend();
            DefaultPrograms12.disableAlphaTest();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR);
            this.lx = OpenGlHelper.lastBrightnessX;
            this.ly = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.x, (float)this.y);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lx, (float)this.ly);
            DefaultPrograms12.disableBlend();
            DefaultPrograms12.enableAlphaTest();
        }

        @Override
        public Program parse(String[] args) {
            if (args.length < 2) {
                return this;
            }
            float x = Float.parseFloat(args[0]);
            float y = Float.parseFloat(args[1]);
            return new Transparent(x, y);
        }

        @Override
        public RenderOrder order() {
            return RenderOrder.BLENDED;
        }
    }

    public static class AttributeVisible
    implements Program {
        private Attribute<?> attr;
        private String attribute;
        private boolean equals;

        public AttributeVisible(String attribute, boolean equals) {
            this.attribute = attribute;
            this.equals = equals;
        }

        @Override
        public String id() {
            return "fvtm:attribute_visible";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.vehicle.getAttributeBoolean(this.attribute, !this.equals) != this.equals) {
                list.visible = false;
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return new AttributeVisible(args[0], args.length > 1 ? Boolean.parseBoolean(args[1]) : false);
        }
    }

    public static class AttributeTranslator
    extends DefaultPrograms.AttributeBased {
        private boolean bool;
        private float min;
        private float max;
        private float step;
        private Float current;
        private int axis;

        public AttributeTranslator(String attribute, boolean boolstatebased, float min, float max, float step, int axis) {
            super(attribute);
            this.bool = boolstatebased;
            this.axis = axis;
            this.step = step;
            this.min = min;
            this.max = max;
        }

        @Override
        public String id() {
            return "fvtm:attribute_translator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(this.bool ? (this.attr.asBoolean() ? this.current.floatValue() + this.step : this.current.floatValue() - this.step) : this.attr.asFloat());
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.current.floatValue() * 0.0625f : 0.0f), (float)(this.axis == 1 ? this.current.floatValue() * 0.0625f : 0.0f), (float)(this.axis == 2 ? this.current.floatValue() * 0.0625f : 0.0f));
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || this.attr == null) {
                return;
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.current.floatValue() * -0.0625f : 0.0f), (float)(this.axis == 1 ? this.current.floatValue() * -0.0625f : 0.0f), (float)(this.axis == 2 ? this.current.floatValue() * -0.0625f : 0.0f));
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean boolstate = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            return new AttributeTranslator(attr, boolstate, min, max, step, axis);
        }
    }

    public static class AttributeRotator
    extends DefaultPrograms.AttributeBased {
        private float min;
        private float max;
        private float step = 1.0f;
        private Float current;
        private int axis;
        private boolean boolstatebased;
        private boolean override;
        private float defrot;

        public AttributeRotator(String attribute, boolean boolstatebased, float mn, float mx, float step, int axis, Float defrot) {
            super(attribute);
            this.boolstatebased = boolstatebased;
            this.override = true;
            this.min = mn;
            this.max = mx;
            this.step = step;
            this.axis = axis;
            float f = this.defrot = defrot == null ? 0.0f : defrot.floatValue();
            if (this.min == this.max || this.min == 0.0f && this.max == 0.0f) {
                this.min = -180.0f;
                this.max = 180.0f;
            }
        }

        public AttributeRotator(String attribute, boolean boolstatebased, float min, float max, float step, int axis, Float defrot, boolean notadditive) {
            this(attribute, boolstatebased, min, max, step, axis, defrot);
            this.override = notadditive;
        }

        @Override
        public String id() {
            return "fvtm:attribute_rotator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(this.boolstatebased ? (this.attr.asBoolean() ? this.current.floatValue() + this.step : this.current.floatValue() - this.step) : this.attr.asFloat() * this.step);
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            list.rotate(this.current.floatValue() + this.defrot, this.axis, this.override);
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || this.attr == null) {
                return;
            }
            list.rotate(this.override ? this.defrot : -(this.current.floatValue() + this.defrot), this.axis, this.override);
            this.current = Float.valueOf(0.0f);
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean boolstate = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            Float defrot = args.length > 6 && NumberUtils.isCreatable((String)args[6]) ? Float.valueOf(Float.parseFloat(args[6])) : null;
            return new AttributeRotator(attr, boolstate, min, max, step, axis, defrot, args.length >= 7 && Boolean.parseBoolean(args[7]));
        }
    }

    public static class SteeringWheelCentered
    implements Program {
        private byte x;
        private byte y;
        private byte z;
        private float ratio;
        private String id;

        public SteeringWheelCentered(int axis, float ratio) {
            this.x = (byte)(axis == 0 ? 1 : 0);
            this.y = (byte)(axis == 1 ? 1 : 0);
            this.z = (byte)(axis == 2 ? 1 : 0);
            this.ratio = ratio;
            this.id = axis == 0 && ratio == 0.0f ? "fvtm:steering_base_centered" : "fvtm:steering_c" + (axis == 0 ? "x" : (axis == 1 ? "y" : "z"));
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glRotatef((float)(data.vehicle.getAttribute("steering_angle").asFloat() * this.ratio), (float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            GL11.glRotatef((float)(-data.vehicle.getAttribute("steering_angle").asFloat() * this.ratio), (float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public Program parse(String[] args) {
            return new SteeringWheelCentered(Integer.parseInt(args[0]), Float.parseFloat(args[1]));
        }
    }

    public static class SteeringWheel
    implements Program {
        private byte axis;
        private float ratio;
        private float rotated;
        private boolean apply;
        private String id;

        public SteeringWheel(int axis, float ratio) {
            this(axis, ratio, true);
        }

        public SteeringWheel(int axis, float ratio, boolean override) {
            this.axis = (byte)axis;
            this.ratio = ratio;
            this.id = axis == 0 && ratio == 0.0f ? "fvtm:steering_base" : "fvtm:steering_" + (axis == 0 ? "x" : (axis == 1 ? "y" : "z")) + (override ? "" : "_no_apply");
            this.apply = override;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.rotated = -data.vehicle.getAttribute("steering_angle").asFloat() * this.ratio;
            list.rotate(this.rotated, this.axis, this.apply);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.rotate(this.rotated, this.axis, this.apply);
        }

        @Override
        public Program parse(String[] args) {
            return new SteeringWheel(Integer.parseInt(args[0]), Float.parseFloat(args[1]));
        }
    }

    public static final class WindowTinted
    implements Program {
        protected RGB color = new RGB(29192).setAlpha(0.3f);

        public WindowTinted() {
        }

        public WindowTinted(int color) {
            this.color = new RGB(color).setAlpha(0.3f);
        }

        public WindowTinted(int color, float alpha) {
            this.color = new RGB(color).setAlpha(alpha);
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GlStateManager.func_179094_E();
            DefaultPrograms12.enableBlend();
            GL11.glDepthMask((boolean)false);
            DefaultPrograms12.enableAlpha();
            this.color.glColorApply();
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            RGB.glColorReset();
            DefaultPrograms12.disableAlpha();
            GL11.glDepthMask((boolean)true);
            DefaultPrograms12.disableBlend();
            GlStateManager.func_179121_F();
        }

        @Override
        public String id() {
            return "fvtm:window_tinted";
        }

        @Override
        public Program parse(String[] args) {
            int color = args.length > 0 ? Integer.parseInt(args[0].replace("#", "").replace("0x", ""), 16) : 29192;
            float alpha = args.length > 1 ? Float.parseFloat(args[1]) : 0.3f;
            return new WindowTinted(color, alpha);
        }

        @Override
        public RenderOrder order() {
            return RenderOrder.LAST;
        }
    }

    public static final class Window
    implements Program {
        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GlStateManager.func_179094_E();
            DefaultPrograms12.enableBlend();
            GL11.glDepthMask((boolean)false);
            DefaultPrograms12.enableAlpha();
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            DefaultPrograms12.disableAlpha();
            GL11.glDepthMask((boolean)true);
            DefaultPrograms12.disableBlend();
            GlStateManager.func_179121_F();
        }

        @Override
        public String id() {
            return "fvtm:window";
        }

        @Override
        public RenderOrder order() {
            return RenderOrder.LAST;
        }
    }

    public static class RGBChannel
    implements Program {
        private String channel;

        public RGBChannel(String colorchannel) {
            this.channel = colorchannel;
        }

        @Override
        public String id() {
            return "fvtm:rgb_channel";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            data.color.getColorChannel(this.channel).glColorApply();
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            RGB.glColorReset();
        }

        @Override
        public Program parse(String[] args) {
            return new RGBChannel(args[0]);
        }
    }

    public static class RGBCustom
    implements Program {
        private RGB color;

        public RGBCustom(int color) {
            this.color = new RGB(color);
        }

        public RGBCustom(RGB rgb) {
            this.color = rgb;
        }

        @Override
        public String id() {
            return "fvtm:rgb_custom";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.color.glColorApply();
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            RGB.glColorReset();
        }

        @Override
        public Program parse(String[] args) {
            return new RGBCustom(new RGB(args[0]));
        }
    }
}

