/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.uni.packet.PacketBase;
import net.fexcraft.mod.uni.world.EntityW;

public class Packet_SPUpdate
implements PacketBase<Packet_SPUpdate> {
    public int entid;
    public String pointid;
    public double posX;
    public double posY;
    public double posZ;
    public float yaw;
    public float pitch;
    public float roll;

    public Packet_SPUpdate fill(Object[] data) {
        this.entid = ((EntityW)data[0]).getId();
        SwivelPoint point = (SwivelPoint)data[1];
        this.posX = point.getPos().x;
        this.posY = point.getPos().y;
        this.posZ = point.getPos().z;
        this.yaw = point.getPivot().deg_yaw();
        this.pitch = point.getPivot().deg_pitch();
        this.roll = point.getPivot().deg_roll();
        this.pointid = point.id;
        return this;
    }

    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.entid);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.roll);
        byte[] bytes = this.pointid.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
    }

    public void decode(ByteBuf buffer) {
        this.entid = buffer.readInt();
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.roll = buffer.readFloat();
        int length = buffer.readInt();
        this.pointid = buffer.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }
}

