/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.attribute.AttrBox;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.container.ContainerHolder;
import net.fexcraft.mod.fvtm.data.container.ContainerSlot;
import net.fexcraft.mod.fvtm.data.container.ContainerType;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartSlot;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.event.ResizeHandler;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.item.ClothItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.MultiBlockItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.MRWrapper;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelGroupList;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.render.VehicleRenderer;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.Command;
import net.fexcraft.mod.fvtm.util.GLUtils112;
import net.fexcraft.mod.fvtm.util.MathUtils;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    public static final ResourceLocation LIGHT_TEXTURE = new ResourceLocation("fvtm:textures/entity/light_beam.png");
    private static ArrayList<V3D> toggpos = new ArrayList();
    private static ContainerHolder tempholder;
    private static final ModelRendererTurbo blkpreview;
    private static ItemStack stack;

    @SubscribeEvent
    public void renderLights(RenderWorldLastEvent event) {
        if (SeparateRenderCache.VEHICLES.size() == 0 && SeparateRenderCache.SORTED_BLK_QUEUE.size() == 0) {
            return;
        }
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.getPartialTicks();
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.getPartialTicks();
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.getPartialTicks();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (SeparateRenderCache.VEHICLES.size() > 0) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
            for (VehicleInstance inst : SeparateRenderCache.VEHICLES) {
                if (inst.entity == null) continue;
                if (inst.cache == null) {
                    inst.cache = (RenderCache)((Entity)inst.entity.direct()).getCapability(Capabilities.RENDERCACHE, null);
                }
                SeparateRenderCache.SepVehCache cache = inst.cache.get(SeparateRenderCache.SEP_VEH_CACHE, data -> new SeparateRenderCache.SepVehCache());
                GL11.glPushMatrix();
                GL11.glTranslated((double)cache.pos[0], (double)cache.pos[1], (double)cache.pos[2]);
                GL11.glRotated((double)(-cache.rot.x), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)cache.rot.y, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)cache.rot.z, (double)0.0, (double)0.0, (double)1.0);
                Model vehmod = ((Vehicle)inst.data.getType()).getModel();
                if (vehmod != null && vehmod.getSeparateGroups() != null) {
                    GL11.glPushMatrix();
                    TexUtil.bindTexture(inst.data.getCurrentTexture());
                    vehmod.getSeparateGroups().render(DefaultModel.RENDERDATA.set(inst, event.getPartialTicks()).rc(inst.cache).sep());
                    GL11.glPopMatrix();
                }
                if (cache.parts.size() > 0) {
                    VehicleRenderer.renderPointSep(inst.point, inst, cache.parts, event.getPartialTicks());
                }
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        if (SeparateRenderCache.SORTED_BLK_QUEUE.size() > 0) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
            for (int i = 0; i < SeparateRenderCache.SORTED_BLK_QUEUE.size(); ++i) {
                ModelGroupList.SeparateModelGroupList sgroup = SeparateRenderCache.SORTED_BLK_QUEUE.get(i);
                BlockData data2 = SeparateRenderCache.SORTED_BLK_DATA.get(i);
                TileEntity tile = (TileEntity)SeparateRenderCache.SORTED_BLK_ENTITY.get(i);
                GL11.glPushMatrix();
                GL11.glTranslated((double)((double)tile.func_174877_v().func_177958_n() + 0.5), (double)tile.func_174877_v().func_177956_o(), (double)((double)tile.func_174877_v().func_177952_p() + 0.5));
                GL11.glRotated((double)((Block)data2.getType()).getBlockType().getRotationFor(tile.func_145832_p()), (double)0.0, (double)1.0, (double)0.0);
                sgroup.render(DefaultModel.RENDERDATA.set(data2, tile, null).rcs((RenderCache)tile.getCapability(Capabilities.RENDERCACHE, null)));
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        SeparateRenderCache.clear();
    }

    private static int isImpact() {
        if (!(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof MaterialItem)) {
            return -1;
        }
        return ((MaterialItem)Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b()).getContent().getImpactLevel();
    }

    public static int isToolbox() {
        if (!(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ToolboxItem)) {
            return -1;
        }
        return Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77952_i();
    }

    private static PartData isWheelOrTire() {
        if (!(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof PartItem)) {
            return null;
        }
        PartData data = ((VehicleAndPartDataCache)Minecraft.func_71410_x().field_71439_g.func_184614_ca().getCapability(Capabilities.VAPDATA, null)).getPartData();
        return data.hasFunction("fvtm:wheel") || data.hasFunction("fvtm:tire") ? data : null;
    }

    private static PartData isNormalPart() {
        if (!(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof PartItem)) {
            return null;
        }
        PartData data = ((VehicleAndPartDataCache)Minecraft.func_71410_x().field_71439_g.func_184614_ca().getCapability(Capabilities.VAPDATA, null)).getPartData();
        return ((Part)data.getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData ? data : null;
    }

    public static void preMeshCalls() {
        GL11.glDisable((int)3553);
        TexturedPolygon.TRIANGULATED_QUADS = false;
        GL11.glLineWidth((float)4.0f);
    }

    public static void postMeshCalls() {
        GL11.glLineWidth((float)1.0f);
        TexturedPolygon.TRIANGULATED_QUADS = true;
        GL11.glEnable((int)3553);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderVehicleInfo(VehicleInstance inst, V3D vehpos, VehicleData data) {
        V3D vec;
        V3D pes;
        SwivelPoint point;
        EffectRenderer.preMeshCalls();
        V3D ply = new V3D(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
        boolean red = false;
        for (InteractZone interactZone : data.getInteractZones().values()) {
            if (!Command.TOGGABLE) continue;
            V3D v3D = interactZone.pos(data);
            GLUtils112.translate(v3D);
            (interactZone.inRange(data, vehpos, ply) ? DebugModels.SPHERE_GRN : DebugModels.SPHERE_GRY).render(interactZone.range);
            GLUtils112.translateR(v3D);
            RGB.glColorReset();
        }
        if (Command.HOTSWAP) {
            for (Map.Entry entry : data.getPartSlotProviders().entrySet()) {
                V3D v3D = ((String)entry.getKey()).equals("vehicle") ? V3D.NULL : data.getPart((String)entry.getKey()).getInstalledPos();
                point = data.getRotationPointOfPart((String)entry.getKey());
                for (PartSlot value : ((PartSlots)entry.getValue()).values()) {
                    pes = v3D.add(value.pos);
                    if (point.isVehicle()) {
                        GL11.glTranslated((double)pes.x, (double)pes.y, (double)pes.z);
                    } else {
                        GL11.glPushMatrix();
                        vec = point.getRelativeVector(pes);
                        GL11.glTranslated((double)vec.x, (double)vec.y, (double)vec.z);
                        GL11.glRotatef((float)point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GL11.glPushMatrix();
                    GL11.glScalef((float)value.radius, (float)value.radius, (float)value.radius);
                    DebugModels.CUBE_CYN.render(1.0f);
                    GL11.glPopMatrix();
                    if (!point.isVehicle()) {
                        GL11.glPopMatrix();
                        continue;
                    }
                    GL11.glTranslated((double)(-pes.x), (double)(-pes.y), (double)(-pes.z));
                }
            }
        } else {
            int n;
            int n2;
            PartData part = EffectRenderer.isNormalPart();
            if (part != null) {
                for (Map.Entry<String, PartSlots> entry : data.getPartSlotProviders().entrySet()) {
                    V3D pos2 = entry.getKey().equals("vehicle") ? V3D.NULL : data.getPart(entry.getKey()).getInstalledPos();
                    point = data.getRotationPointOfPart(entry.getKey());
                    red = false;
                    for (Object value : entry.getValue().values()) {
                        if (data.hasPart(((PartSlot)value).type)) {
                            Part epart = (Part)data.getPart(((PartSlot)value).type).getType();
                            if (!(epart.getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                            red = !((DefaultPartInstallHandler.DPIHData)epart.getInstallHandlerData()).swappable;
                        }
                        String type = ((PartSlot)value).type;
                        for (String str : ((Part)part.getType()).getCategories()) {
                            if (!str.equals(type)) continue;
                            V3D pes2 = pos2.add(((PartSlot)value).pos);
                            if (point.isVehicle()) {
                                GL11.glTranslated((double)pes2.x, (double)pes2.y, (double)pes2.z);
                            } else {
                                GL11.glPushMatrix();
                                V3D vec2 = point.getRelativeVector(pes2);
                                GL11.glTranslated((double)vec2.x, (double)vec2.y, (double)vec2.z);
                                GL11.glRotatef((float)point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                                GL11.glRotatef((float)point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                                GL11.glRotatef((float)point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
                            }
                            GL11.glPushMatrix();
                            GL11.glScalef((float)((PartSlot)value).radius, (float)((PartSlot)value).radius, (float)((PartSlot)value).radius);
                            (red ? DebugModels.CUBE_RED : DebugModels.CUBE_CYN).render(1.0f);
                            GL11.glPopMatrix();
                            if (!point.isVehicle()) {
                                GL11.glPopMatrix();
                                continue;
                            }
                            GL11.glTranslated((double)(-pes2.x), (double)(-pes2.y), (double)(-pes2.z));
                        }
                    }
                }
            }
            if ((n2 = EffectRenderer.isImpact()) > -1) {
                red = ((Vehicle)data.getType()).getImpactWrenchLevel() > n2;
                for (WheelSlot slot : data.getWheelSlots().values()) {
                    GL11.glTranslated((double)slot.position.x, (double)slot.position.y, (double)slot.position.z);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)slot.max_radius, (float)slot.max_radius, (float)slot.max_radius);
                    (red ? DebugModels.CUBE_RED : DebugModels.CUBE_CYN).render(1.0f);
                    GL11.glPopMatrix();
                    GL11.glTranslated((double)(-slot.position.x), (double)(-slot.position.y), (double)(-slot.position.z));
                }
            }
            if ((part = EffectRenderer.isWheelOrTire()) != null) {
                boolean wheel = part.hasFunction("fvtm:wheel");
                for (Map.Entry<String, WheelSlot> entry : data.getWheelSlots().entrySet()) {
                    boolean green = ((Part)part.getType()).getInstallHandler().validInstall(FvtmLogger.NONE, part, entry.getKey(), data, true);
                    if (wheel) {
                        red = data.hasPart(entry.getKey());
                    } else {
                        boolean bl = red = data.hasPart(entry.getKey()) && ((WheelInstallationHandler.WheelData)((Part)data.getPart(entry.getKey()).getType()).getInstallHandlerData()).hasTire();
                        if (!red) {
                            red = data.hasPart(entry.getKey() + ":tire");
                        }
                    }
                    WheelSlot wheelSlot = entry.getValue();
                    GL11.glTranslated((double)wheelSlot.position.x, (double)wheelSlot.position.y, (double)wheelSlot.position.z);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)wheelSlot.max_radius, (float)wheelSlot.max_radius, (float)wheelSlot.max_radius);
                    (red ? DebugModels.CUBE_RED : (green ? DebugModels.CUBE_GRN : DebugModels.CUBE_CYN)).render(1.0f);
                    GL11.glPopMatrix();
                    GL11.glTranslated((double)(-wheelSlot.position.x), (double)(-wheelSlot.position.y), (double)(-wheelSlot.position.z));
                }
            }
            if ((n = EffectRenderer.isToolbox()) > 0) {
                DebugModels.CUBE_ORG.render(1.0f);
            }
            if (n > -1 && n < 2) {
                for (Map.Entry<String, PartData> entry : data.getParts().entrySet()) {
                    void var8_26;
                    if (n == 0 && !(((Part)entry.getValue().getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData)) continue;
                    red = n != 0 || !((DefaultPartInstallHandler.DPIHData)((Part)entry.getValue().getType()).getInstallHandlerData()).removable;
                    point = data.getRotationPointOfPart(entry.getKey());
                    V3D v3D = entry.getValue().getInstalledPos();
                    if (point.isVehicle()) {
                        GL11.glTranslated((double)v3D.x, (double)v3D.y, (double)v3D.z);
                    } else {
                        GL11.glPushMatrix();
                        V3D v3D2 = point.getRelativeVector(v3D);
                        GL11.glTranslated((double)v3D2.x, (double)v3D2.y, (double)v3D2.z);
                        GL11.glRotatef((float)point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    GL11.glPushMatrix();
                    if (red) {
                        GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
                        DebugModels.CUBE_YLW.render(1.0f);
                    } else {
                        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
                        DebugModels.CUBE_RED.render(1.0f);
                    }
                    GL11.glPopMatrix();
                    if (!point.isVehicle()) {
                        GL11.glPopMatrix();
                        continue;
                    }
                    GL11.glTranslated((double)(-var8_26.x), (double)(-var8_26.y), (double)(-var8_26.z));
                }
            }
        }
        EffectRenderer.postMeshCalls();
        if (Command.HOTSWAP && Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            for (Map.Entry entry : data.getPartSlotProviders().entrySet()) {
                V3D v3D = ((String)entry.getKey()).equals("vehicle") ? V3D.NULL : data.getPart((String)entry.getKey()).getInstalledPos();
                point = data.getRotationPointOfPart((String)entry.getKey());
                for (Map.Entry entry2 : ((PartSlots)entry.getValue()).entrySet()) {
                    pes = v3D.add(((PartSlot)entry2.getValue()).pos);
                    if (point.isVehicle()) {
                        GL11.glTranslated((double)pes.x, (double)pes.y, (double)pes.z);
                    } else {
                        GL11.glPushMatrix();
                        vec = point.getRelativeVector(pes);
                        GL11.glTranslated((double)vec.x, (double)vec.y, (double)vec.z);
                        GL11.glRotatef((float)point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    EffectRenderer.drawString((String)entry2.getKey(), 0.0, ((PartSlot)entry2.getValue()).radius + 0.1f, 0.0, true, true, 0.5f, 0xFFFFFF, null);
                    if (!point.isVehicle()) {
                        GL11.glPopMatrix();
                        continue;
                    }
                    GL11.glTranslated((double)(-pes.x), (double)(-pes.y), (double)(-pes.z));
                }
            }
        }
        RGB.glColorReset();
    }

    public static void renderToggableInfo(Entity vehicle, VehicleData data) {
        if (!Command.TOGGABLE) {
            return;
        }
        GL11.glPushMatrix();
        EffectRenderer.preMeshCalls();
        GlStateManager.func_179140_f();
        for (Attribute<?> attr : data.getAttributes().values()) {
            if (!attr.hasBoxes()) continue;
            for (AttrBox box : attr.actboxes.values()) {
                SwivelPoint point = data.getRotationPoint(box.swivel_point);
                PartData part = data.getAttributeOrigin(attr);
                V3D temp = point.getRelativeVector(part == null ? box.pos : box.pos.add(part.getInstalledPos()));
                GL11.glTranslated((double)temp.x, (double)temp.y, (double)temp.z);
                float scal = box.size;
                GL11.glPushMatrix();
                GL11.glScalef((float)scal, (float)scal, (float)scal);
                DebugModels.CUBE_ATTR.render(2.0f);
                GL11.glPopMatrix();
                if (Command.TOGG_LABEL) {
                    boolean depth = temp.add(vehicle.field_70165_t, vehicle.field_70163_u, vehicle.field_70161_v).dis(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v) < 4.0;
                    EffectRenderer.postMeshCalls();
                    float by = EffectRenderer.consim(temp) * (scal * 0.5f);
                    GL11.glTranslatef((float)0.0f, (float)by, (float)0.0f);
                    EffectRenderer.drawString(box.id, scal * 2.0f, RGB.WHITE.packed, false, true, depth);
                    GL11.glTranslatef((float)0.0f, (float)(-by), (float)0.0f);
                    by = scal * 0.5f;
                    GL11.glTranslatef((float)0.0f, (float)(-by), (float)0.0f);
                    EffectRenderer.drawString(attr.id, scal * 2.0f, RGB.WHITE.packed, false, true, depth);
                    GL11.glTranslatef((float)0.0f, (float)by, (float)0.0f);
                    EffectRenderer.preMeshCalls();
                    toggpos.add(temp);
                }
                GL11.glTranslated((double)(-temp.x), (double)(-temp.y), (double)(-temp.z));
            }
            toggpos.clear();
        }
        EffectRenderer.postMeshCalls();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    private static float consim(V3D temp) {
        int i = 0;
        for (V3D vec : toggpos) {
            if (!(vec.dis(temp) < (double)0.01f)) continue;
            ++i;
        }
        return i;
    }

    public static void renderContainerInfo(Entity entity, V3D rot) {
        tempholder = (ContainerHolder)entity.getCapability(Capabilities.CONTAINER, null);
        if (tempholder != null) {
            tempholder.render(0.0, 0.0, 0.0, rot.x, rot.y, rot.z);
        }
        if (!Command.CONTAINER) {
            return;
        }
        if (tempholder != null) {
            ContainerHolder.ContainerHolderWrapper ent = tempholder.getWrapper();
            for (String slotid : tempholder.getContainerSlotIds()) {
                ContainerSlot slot = tempholder.getContainerSlot(slotid);
                ContainerType type = ContainerType.values()[Time.getSecond() % 5];
                for (int i = 0; i < slot.length; i += type.length()) {
                    Vec3d vec = ent.getContainerInSlotPosition(slot.id, tempholder, type, i);
                    entity.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public static void renderContainerInfo(World world, ContainerHolder.ContainerHolderWrapper entity, ContainerHolder holder, Vec3f rot) {
        tempholder = holder;
        if (tempholder != null) {
            tempholder.render(0.0, 0.0, 0.0, rot.x, rot.y, rot.z);
        }
        if (!Command.CONTAINER) {
            return;
        }
        if (tempholder != null) {
            for (String slotid : tempholder.getContainerSlotIds()) {
                ContainerSlot slot = tempholder.getContainerSlot(slotid);
                ContainerType type = ContainerType.values()[Time.getSecond() % 5];
                for (int i = 0; i < slot.length; i += type.length()) {
                    Vec3d vec = entity.getContainerInSlotPosition(slot.id, tempholder, type, i);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public static void renderSeatsAndInvs(VehicleInstance vehicle) {
        if (!(Command.HOTSWAP || Command.TOGGABLE || Command.OTHER)) {
            return;
        }
        EffectRenderer.preMeshCalls();
        GL11.glPushMatrix();
        for (SeatInstance seat : vehicle.seats) {
            GL11.glPushMatrix();
            GLUtils112.translate(seat.point.getRelativeVector(seat.seat.pos));
            if (!seat.point.isVehicle()) {
                GL11.glRotatef((float)seat.point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)seat.point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)seat.point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            (seat.passenger() != null ? DebugModels.SEAT_CUBE_OCCUPIED : (seat.seat.sitting ? DebugModels.SEAT_CUBE_SITTING : DebugModels.SEAT_CUBE_STANDING)).render(0.5f * seat.seat.scale());
            GL11.glPopMatrix();
        }
        for (int i = 0; i < vehicle.data.getVehInvKeys().size(); ++i) {
            FvtmInv inv = vehicle.data.getVehInventories().get(i);
            GL11.glPushMatrix();
            GLUtils112.translate(vehicle.pivot().get_vector(inv.pos));
            DebugModels.CUBE_YLW.render(inv.scale);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        EffectRenderer.postMeshCalls();
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            for (SeatInstance seat : vehicle.seats) {
                if (seat.point.isVehicle()) {
                    GLUtils112.translate(seat.seat.pos);
                } else {
                    GL11.glPushMatrix();
                    GLUtils112.translate(seat.point.getRelativeVector(seat.seat.pos));
                    GL11.glRotatef((float)seat.point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)seat.point.getPivot().deg_pitch(), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)seat.point.getPivot().deg_roll(), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                EffectRenderer.drawString(seat.seat.name, 0.0, 0.5, 0.0, true, true, 0.5f, 0xFFFFFF, null);
                if (!seat.point.isVehicle()) {
                    GL11.glPopMatrix();
                    continue;
                }
                GLUtils112.translateR(seat.seat.pos);
            }
        }
        RGB.glColorReset();
    }

    public static final void drawString(String str, float scale, int color, boolean light, boolean rot, boolean depth) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        GlStateManager.func_179094_E();
        RGB.WHITE.glColorApply();
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        if (light) {
            GlStateManager.func_179140_f();
        }
        if (rot) {
            GL11.glRotatef((float)Minecraft.func_71410_x().field_71439_g.field_70759_as, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179132_a((boolean)false);
        if (depth) {
            GL11.glDisable((int)2929);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, 0, color);
        if (depth) {
            GL11.glEnable((int)2929);
        }
        GlStateManager.func_179132_a((boolean)true);
        if (light) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static V3D getRotations(RootVehicle veh, float ticks) {
        double yaw = MathUtils.valDeg(veh.vehicle.pivot().deg_yaw() - veh.field_70126_B);
        double pitch = MathUtils.valDeg(veh.vehicle.pivot().deg_pitch() - veh.field_70127_C);
        double roll = MathUtils.valDeg(veh.vehicle.pivot().deg_roll() - veh.prevRotationRoll);
        return new V3D((double)veh.field_70126_B + yaw * (double)ticks, (double)veh.field_70127_C + pitch * (double)ticks, (double)veh.prevRotationRoll + roll * (double)ticks);
    }

    public static V3D getRotations(SwivelPoint point, float ticks) {
        double yaw = MathUtils.valDeg(point.getPivot().deg_yaw() - point.getPrevPivot().deg_yaw());
        double pitch = MathUtils.valDeg(point.getPivot().deg_pitch() - point.getPrevPivot().deg_pitch());
        double roll = MathUtils.valDeg(point.getPivot().deg_roll() - point.getPrevPivot().deg_roll());
        return new V3D((double)point.getPrevPivot().deg_yaw() + yaw * (double)ticks, (double)point.getPrevPivot().deg_pitch() + pitch * (double)ticks, (double)point.getPrevPivot().deg_roll() + roll * (double)ticks);
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Pre event) throws Exception {
        EntityPlayer player;
        if (event.getEntity().func_184187_bx() instanceof RootVehicle) {
            ((RootVehicle)event.getEntity().func_184187_bx()).updateSittingState(event.getEntity());
        }
        float scale = ResizeHandler.getScale((Entity)event.getEntityPlayer());
        GlStateManager.func_179094_E();
        if (scale != 1.0f) {
            player = event.getEntityPlayer();
            float width = player.field_70130_N;
            float height = player.field_70131_O;
            float hw = width * 0.5f;
            player.func_174826_a(new AxisAlignedBB(player.field_70165_t - (double)hw, player.field_70163_u + 0.25, player.field_70161_v - (double)hw, player.field_70165_t + (double)hw, player.field_70163_u + (double)height + 0.25, player.field_70161_v + (double)hw));
            scale = height * scale / height;
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + 0.25), (double)event.getZ());
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
        }
        player = event.getEntityPlayer();
        ModelPlayer model = event.getRenderer().func_177087_b();
        for (int idx = 2; idx < EntityEquipmentSlot.values().length; ++idx) {
            if (!(((ItemStack)player.field_71071_by.field_70460_b.get(idx - 2)).func_77973_b() instanceof ClothItem)) continue;
            ClothItem item = (ClothItem)((ItemStack)player.field_71071_by.field_70460_b.get(idx - 2)).func_77973_b();
            for (String key : item.getContent().getClothModel().getClothGroups().keySet()) {
                MRWrapper wrapper = this.getWrapper((ModelBiped)model, (RenderLivingBase<?>)event.getRenderer(), key);
                if (wrapper == null) continue;
                wrapper.set((EntityLivingBase)player, item, item.getContent().getClothModel().getClothGroups().get(key), key);
            }
        }
    }

    private MRWrapper getWrapper(ModelBiped model, RenderLivingBase<?> renderer, String key) {
        switch (key) {
            case "head": {
                return MRWrapper.get((ModelBase)model, model.field_78116_c, renderer, key);
            }
            case "body": {
                return MRWrapper.get((ModelBase)model, model.field_78115_e, renderer, key);
            }
            case "left_arm": 
            case "arm_left": {
                return MRWrapper.get((ModelBase)model, model.field_178724_i, renderer, key);
            }
            case "right_arm": 
            case "arm_right": {
                return MRWrapper.get((ModelBase)model, model.field_178723_h, renderer, key);
            }
            case "left_leg": 
            case "leg_left": {
                return MRWrapper.get((ModelBase)model, model.field_178722_k, renderer, key);
            }
            case "right_leg": 
            case "leg_right": {
                return MRWrapper.get((ModelBase)model, model.field_178721_j, renderer, key);
            }
            case "skirt_front": {
                if (model.field_178722_k.field_78795_f < model.field_178721_j.field_78795_f) {
                    return MRWrapper.get((ModelBase)model, model.field_178722_k, renderer, "left_leg");
                }
                return MRWrapper.get((ModelBase)model, model.field_178721_j, renderer, "right_leg");
            }
            case "skirt_back": 
            case "skirt_rear": {
                if (model.field_178722_k.field_78795_f >= model.field_178721_j.field_78795_f) {
                    return MRWrapper.get((ModelBase)model, model.field_178722_k, renderer, "left_leg");
                }
                return MRWrapper.get((ModelBase)model, model.field_178721_j, renderer, "right_leg");
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Post event) throws Exception {
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onRender(RenderLivingEvent.Pre<EntityLivingBase> event) throws Exception {
        EntityLivingBase entity;
        if (event.getEntity() instanceof EntityPlayer) {
            return;
        }
        if (event.getEntity().func_184187_bx() instanceof RootVehicle) {
            ((RootVehicle)event.getEntity().func_184187_bx()).updateSittingState((Entity)event.getEntity());
        }
        float scale = ResizeHandler.getScale((Entity)event.getEntity());
        GlStateManager.func_179094_E();
        if (scale != 1.0f) {
            entity = event.getEntity();
            float height = entity.field_70131_O * scale;
            float hw = entity.field_70130_N * scale * 0.5f;
            entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t - (double)hw, entity.field_70163_u, entity.field_70161_v - (double)hw, entity.field_70165_t + (double)hw, entity.field_70163_u + (double)height, entity.field_70161_v + (double)hw));
            scale = height * scale / height;
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
        }
        if (!(event.getRenderer().func_177087_b() instanceof ModelBiped)) {
            return;
        }
        entity = event.getEntity();
        ModelBiped model = (ModelBiped)event.getRenderer().func_177087_b();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ClothItem)) continue;
            ClothItem item = (ClothItem)stack.func_77973_b();
            for (String key : item.getContent().getClothModel().getClothGroups().keySet()) {
                MRWrapper wrapper = this.getWrapper(model, event.getRenderer(), key);
                if (wrapper == null) continue;
                wrapper.set(entity, item, item.getContent().getClothModel().getClothGroups().get(key), key);
            }
        }
    }

    @SubscribeEvent
    public void onRender(RenderLivingEvent.Post<EntityLivingBase> event) throws Exception {
        if (event.getEntity() instanceof EntityPlayer) {
            return;
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void preview(DrawBlockHighlightEvent event) {
        if (!Command.OTHER) {
            return;
        }
        stack = event.getPlayer().func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MultiBlockItem)) {
            return;
        }
        if (event.getTarget() == null || event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (event.getTarget().field_178784_b != EnumFacing.UP) {
            return;
        }
        MultiBlockItem item = (MultiBlockItem)stack.func_77973_b();
        BlockPos pos = event.getTarget().func_178782_a().func_177982_a(0, 1, 0);
        pos = event.getPlayer().field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)event.getPlayer().field_70170_p, pos) ? pos : pos.func_177982_a(0, 1, 0);
        ArrayList<V3I> poslist = item.getContent().getPositions(new V3I(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), WrapperHolder.getSide((Object)event.getPlayer().func_174811_aO()));
        EntityPlayer player = event.getPlayer();
        GlStateManager.func_179090_x();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TexUtil.bindTexture(FvtmRegistry.WHITE_TEXTURE);
        for (V3I vec : poslist) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)vec.x, (double)vec.y, (double)vec.z);
            blkpreview.render();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public static void drawString(String str, double x, double y, double z, boolean centered, boolean glow, float scale, int color, Double yaw) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        if (scale != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        if (glow) {
            GlStateManager.func_179140_f();
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)true);
        if (yaw != null) {
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        }
        fontRenderer.func_78276_b(str, centered ? -fontRenderer.func_78256_a(str) / 2 : -24, 0, color);
        if (glow) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    static {
        blkpreview = new ModelRendererTurbo(null).addBox(0.0f, 0.0f, 0.0f, 14.0f, 14.0f, 14.0f);
    }
}

