/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.Command;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.fvtm.util.VecUtil;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RailRenderer {
    private JunctionGridItem jitem;
    private ItemStack stack;
    public static final RGB MIDDLE_GRAY = new RGB(127, 127, 127);
    public static boolean HOLDING;
    protected static final ModelRendererTurbo model;
    protected static final ModelRendererTurbo model0;
    protected static final ModelRendererTurbo model1;
    protected static final ModelRendererTurbo junction_core;
    protected static final ModelRendererTurbo railentcore;
    public static final ModelRendererTurbo junction_signal;
    protected static final ModelRendererTurbo[] all;
    public static final ResourceLocation WOOLTEX;
    private static RailSystem raildata;

    @SubscribeEvent
    public void preview(DrawBlockHighlightEvent event) {
        double yy;
        BlockPos pos;
        float[][] color;
        BufferBuilder bufferbuilder;
        Tessellator tessellator;
        double z;
        double y;
        double x;
        QV3D vec;
        HOLDING = false;
        this.stack = event.getPlayer().func_184614_ca();
        if (this.stack.func_190926_b()) {
            return;
        }
        if (event.getTarget() == null || event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (this.stack.func_77973_b() instanceof JunctionGridItem && ((JunctionGridItem)this.stack.func_77973_b()).showJunctionGrid()) {
            this.jitem = (JunctionGridItem)this.stack.func_77973_b();
            HOLDING = true;
            vec = new QV3D(event.getTarget().field_72307_f.field_72450_a, event.getTarget().field_72307_f.field_72448_b, event.getTarget().field_72307_f.field_72449_c);
            EntityPlayer player = event.getPlayer();
            GlStateManager.func_179090_x();
            x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(vec.vec.x - x), (double)(vec.vec.y - y), (double)(vec.vec.z - z));
            model1.render();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179132_a((boolean)false);
            tessellator = Tessellator.func_178181_a();
            bufferbuilder = tessellator.func_178180_c();
            color = ((JunctionGridItem)this.stack.func_77973_b()).getGridColours();
            pos = event.getTarget().func_178782_a();
            yy = vec.y == 0 ? 1.0 : (double)((float)vec.y * 0.0625f);
            for (int i = 0; i < 4; ++i) {
                bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b((double)pos.func_177958_n() + ((double)i * 0.25 + 0.125) - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() - z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)pos.func_177958_n() + ((double)i * 0.25 + 0.125) - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)(pos.func_177952_p() + 1) - z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b((double)pos.func_177958_n() - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() + ((double)i * 0.25 + 0.125) - z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b((double)(pos.func_177958_n() + 1) - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() + ((double)i * 0.25 + 0.125) - z).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        } else {
            return;
        }
        double v = vec.x < 0 ? (double)(-vec.x - 16) * -0.0625 : (double)vec.x * 0.0625;
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)pos.func_177958_n() + v - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() - z).func_181666_a(color[0][0], color[0][1], color[0][2], color[0][3]).func_181675_d();
        bufferbuilder.func_181662_b((double)pos.func_177958_n() + v - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)(pos.func_177952_p() + 1) - z).func_181666_a(color[0][0], color[0][1], color[0][2], color[0][3]).func_181675_d();
        tessellator.func_78381_a();
        v = vec.z < 0 ? (double)(-vec.z - 16) * -0.0625 : (double)vec.z * 0.0625;
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)pos.func_177958_n() - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() + v - z).func_181666_a(color[0][0], color[0][1], color[0][2], color[0][3]).func_181675_d();
        bufferbuilder.func_181662_b((double)(pos.func_177958_n() + 1) - x, (double)pos.func_177956_o() + yy + 0.01 - y, (double)pos.func_177952_p() + v - z).func_181666_a(color[0][0], color[0][1], color[0][2], color[0][3]).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
        GlStateManager.func_179098_w();
    }

    public static void renderRails(World world, double cx, double cy, double cz, float partialticks) {
        if (Config.DISABLE_RAILS) {
            return;
        }
        raildata = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world), RailSystem.class);
        if (raildata == null || raildata.getRegions() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SystemRegion reg : raildata.getRegions().values()) {
            Junction[] junctions = reg.getObjects().values().toArray(new Junction[0]);
            for (int i = 0; i < junctions.length; ++i) {
                if (!RenderView.FRUSTUM.func_78546_a((AxisAlignedBB)junctions[i].getAABB().local())) continue;
                GL11.glPushMatrix();
                TexUtil.bindTexture(WOOLTEX);
                GL11.glTranslated((double)(junctions[i].getV3D().x - cx), (double)(junctions[i].getV3D().y - cy), (double)(junctions[i].getV3D().z - cz));
                if (junctions[i].tracks.isEmpty() || HOLDING) {
                    model.render();
                } else {
                    junction_core.render();
                }
                GL11.glPopMatrix();
                RailRenderer.renderLines(junctions[i], cx, cy, cz);
            }
        }
        if (RailPlacingUtil.CL_CURRENT != null && RailPlacingUtil.CL_CURRENT.points.size() > 1) {
            V3D vec0;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RailPlacingUtil.NewTrack conn = RailPlacingUtil.CL_CURRENT;
            if (conn.preview == null) {
                conn.genpreview();
            }
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)4.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            for (int j = 0; j < conn.track.vecpath.length - 1; ++j) {
                vec0 = conn.track.vecpath[j].sub(cx, cy, cz);
                V3D vec1 = conn.track.vecpath[j + 1].sub(cx, cy, cz);
                bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b(vec0.x, vec0.y + 0.1, vec0.z).func_181666_a(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(vec1.x, vec1.y + 0.1, vec1.z).func_181666_a(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
            }
            if (RailPlacingUtil.CL_CURRENT.points.size() > 2) {
                int size = RailPlacingUtil.CL_CURRENT.points.size();
                double[] arr = null;
                for (int i = 1; i < size - 1; ++i) {
                    arr = conn.track.getPosition(conn.track.length / (double)(size - 1) * (double)i);
                    V3D vec1 = RailPlacingUtil.CL_CURRENT.points.get((int)i).vec.sub(cx, cy, cz);
                    bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                    bufferbuilder.func_181662_b(arr[0] - cx, arr[1] + 0.05 - cy, arr[2] - cz).func_181666_a(0.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_181662_b(vec1.x, vec1.y + 0.05, vec1.z).func_181666_a(0.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            for (ArrayList<V3D> l : conn.preview) {
                for (int j = 0; j < l.size() - 1; ++j) {
                    bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                    vec0 = l.get(j).sub(cx, cy, cz);
                    bufferbuilder.func_181662_b(vec0.x, vec0.y + (double)conn.gauge.getHeight() + 0.05, vec0.z).func_181666_a(1.0f, 0.75f, 0.0f, 1.0f).func_181675_d();
                    V3D vec1 = l.get(j + 1).sub(cx, cy, cz);
                    bufferbuilder.func_181662_b(vec1.x, vec1.y + (double)conn.gauge.getHeight() + 0.05, vec1.z).func_181666_a(1.0f, 0.75f, 0.0f, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private static void renderLines(Junction value, double cx, double cy, double cz) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < value.size(); ++i) {
            if (i > 2) {
                GL11.glTranslatef((float)0.0f, (float)-0.02f, (float)0.0f);
            }
            if (value.tracks.get(i).isOppositeCopy()) continue;
            GL11.glPushMatrix();
            Track track = value.tracks.get(i);
            GL11.glTranslated((double)(track.vecpath[0].x - cx), (double)(track.vecpath[0].y - cy), (double)(track.vecpath[0].z - cz));
            RailGaugeModel model = track.gauge.getModel();
            if (track.railmodel == null) {
                PathModelGenerator.generateTrackModel(track, model);
            }
            TexUtil.bindTexture(track.gauge.getRailTexture());
            if (track.getGauge().getModel().rail_tempcull) {
                GlStateManager.func_179129_p();
            }
            track.railmodel.render();
            if (track.getGauge().getModel().rail_tempcull) {
                GlStateManager.func_179089_o();
            }
            TexUtil.bindTexture(track.gauge.getTiesTexture());
            track.restmodel.render();
            GL11.glPopMatrix();
        }
        if (Command.OTHER) {
            for (int i = 0; i < value.size(); ++i) {
                Track track = value.tracks.get(i);
                V3D pos = track.getVectorPosition(track.length * 0.5, false);
                double off = track.isOppositeCopy() ? 0.125 : -0.125;
                double deg = (float)Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176736_b() * 90.0f;
                EffectRenderer.drawString(track.getUnit().section().getUID() + "", pos.x + off, pos.y + 0.5, pos.z, true, true, 0.8f, track.isOppositeCopy() ? 12106808 : 3319890, deg);
                if (track.isOppositeCopy() || track.getUnit().getEntities().size() <= 0) continue;
                RailEntity[] ents = track.getUnit().getEntities().toArray(new RailEntity[0]);
                String str = ents[0].uid + "";
                for (int j = 1; j < ents.length; ++j) {
                    str = str + ", " + ents[j].uid;
                }
                EffectRenderer.drawString(str, pos.x, pos.y + 0.75, pos.z, true, true, 0.8f, 4360181, deg);
            }
        }
        if (value.signal != null && value.size() == 2) {
            V3D vec1;
            if (value.signalpos0 == null) {
                Track track = value.tracks.get(value.signal_dir.getTrackId());
                V3D vec0 = track.start.vec;
                vec1 = track.getVectorPosition0(0.001f, false);
                value.signalrot0 = Math.atan2(vec0.x - vec1.x, vec0.z - vec1.z);
                value.signalpos0 = vec0.add(VecUtil.rotByRad(value.signalrot0, new V3D((double)track.gauge.getModel().signal_offset, 0.0, 0.0)));
                value.signalrot0 = Math.toDegrees(value.signalrot0);
            }
            if (value.signal_dir.isBoth() && value.signalpos1 == null) {
                Track track = value.tracks.get(1);
                V3D vec0 = track.start.vec;
                vec1 = track.getVectorPosition0(0.001f, false);
                value.signalrot1 = Math.atan2(vec0.x - vec1.x, vec0.z - vec1.z);
                value.signalpos1 = vec0.add(VecUtil.rotByRad(value.signalrot1, new V3D((double)track.gauge.getModel().signal_offset, 0.0, 0.0)));
                value.signalrot1 = Math.toDegrees(value.signalrot1);
            }
            TexUtil.bindTexture(value.tracks.get((int)0).gauge.getModelTexture());
            if (value.signalpos0 != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(value.signalpos0.x - cx), (double)(value.signalpos0.y - cy), (double)(value.signalpos0.z - cz));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotated((double)value.signalrot0, (double)0.0, (double)1.0, (double)0.0);
                value.tracks.get((int)value.signal_dir.getTrackId()).gauge.getModel().renderSignal(value, value.signal_dir.isBoth() ? EntryDirection.BACKWARD : value.signal_dir, value.signal0);
                GL11.glPopMatrix();
            }
            if (value.signalpos1 != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(value.signalpos1.x - cx), (double)(value.signalpos1.y - cy), (double)(value.signalpos1.z - cz));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotated((double)value.signalrot1, (double)0.0, (double)1.0, (double)0.0);
                value.tracks.get((int)1).gauge.getModel().renderSignal(value, EntryDirection.FORWARD, value.signal1);
                GL11.glPopMatrix();
            }
            if (Command.OTHER) {
                double deg = (float)Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176736_b() * 90.0f;
                long uid = value.tracks.get(value.signal_dir.getTrackId()).getUnit().section().getUID();
                V3D pos = value.signalpos0;
                EffectRenderer.drawString(uid + "/" + value.signal0, pos.x, pos.y + 1.0, pos.z, true, true, 0.8f, 0xFFFFFF, deg);
                if (value.signal_dir.isBoth()) {
                    uid = value.tracks.get(1).getUnit().section().getUID();
                    pos = value.signalpos1;
                    EffectRenderer.drawString(uid + "/" + value.signal1, pos.x, pos.y + 1.0, pos.z, true, true, 0.8f, 0xFFFFFF, deg);
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    static {
        model = new ModelRendererTurbo(null, 0, 0, 32, 32).addCylinder(0.0f, 0.0f, 0.0f, 0.4f, 8.0f, 32, 1.0f, 1.0f, 4).setColor(RGB.RED);
        model0 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(245, 234, 128));
        model1 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(123, 245, 126));
        junction_core = new ModelRendererTurbo(null, 0, 0, 32, 32).addCylinder(0.0f, -0.5f, 0.0f, 0.9f, 1.0f, 8, 1.0f, 1.0f, 4).setColor(new RGB(120, 120, 120));
        junction_signal = new ModelRendererTurbo(null, 0, 0, 32, 32).setRotationAngle(0.0f, 0.0f, 0.0f).addCylinder(0.0f, -0.5f, 0.0f, 0.9f, 1.0f, 3, 1.0f, 1.0f, 4).setColor(new RGB(35, 35, 35));
        railentcore = new ModelRendererTurbo(null, 0, 0, 32, 32).addHollowCylinder(0.0f, -4.0f, 0.0f, 8.0f, 4.0f, 8.0f, 8, 0, 1.0f, 1.0f, 4).setColor(new RGB(128, 128, 128));
        for (ModelRendererTurbo turbo : all = new ModelRendererTurbo[]{model, model0, model1, junction_core, railentcore}) {
            for (TexturedPolygon poly : turbo.getFaces()) {
                poly.setColor(turbo.polygonColor);
            }
        }
        WOOLTEX = new ResourceLocation("minecraft:textures/blocks/wool_colored_white.png");
    }
}

